/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import pl.baczkowicz.mqttspy.common.generated.SecureSocketSettings;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.spy.common.generated.SecureSocketModeEnum;
import pl.baczkowicz.spy.ui.utils.DialogFactory;

public class EditConnectionSecurityTlsKeyStoresController
extends AnchorPane
implements Initializable {
    private EditMqttConnectionController parent;
    @FXML
    private AnchorPane tlsKeyStoresPane;
    @FXML
    private TextField trustStoreFile;
    @FXML
    private PasswordField trustStorePassword;
    @FXML
    private TextField clientKeyStoreFile;
    @FXML
    private PasswordField clientKeyStorePassword;
    @FXML
    private PasswordField clientKeyPassword;
    @FXML
    private Label clientKeyPasswordLabel;
    @FXML
    private Label clientKeyStorePasswordLabel;
    @FXML
    private Label clientKeyFileLabel;
    @FXML
    private Button editTrustStoreFileButton;
    @FXML
    private Button editClientKeyStoreFileButton;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionSecurityTlsKeyStoresController.this.onChange();
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        DialogFactory.setUpTextFieldFileOpenButton(this.trustStoreFile, this.editTrustStoreFileButton);
        DialogFactory.setUpTextFieldFileOpenButton(this.clientKeyStoreFile, this.editClientKeyStoreFileButton);
        this.trustStoreFile.textProperty().addListener(this.basicOnChangeListener);
        this.trustStorePassword.textProperty().addListener(this.basicOnChangeListener);
        this.clientKeyStoreFile.textProperty().addListener(this.basicOnChangeListener);
        this.clientKeyStorePassword.textProperty().addListener(this.basicOnChangeListener);
        this.clientKeyPassword.textProperty().addListener(this.basicOnChangeListener);
    }

    public void init() {
    }

    public void onChange() {
        this.parent.onChange();
    }

    public void updateSSL(SecureSocketModeEnum mode) {
        boolean keyStores;
        boolean bl = keyStores = SecureSocketModeEnum.SERVER_KEYSTORE.equals((Object)mode) || SecureSocketModeEnum.SERVER_AND_CLIENT_KEYSTORES.equals((Object)mode);
        if (keyStores) {
            boolean serverAndClient = SecureSocketModeEnum.SERVER_AND_CLIENT_KEYSTORES.equals((Object)mode);
            this.clientKeyStoreFile.setVisible(serverAndClient);
            this.clientKeyStorePassword.setVisible(serverAndClient);
            this.clientKeyPassword.setVisible(serverAndClient);
            this.editClientKeyStoreFileButton.setVisible(serverAndClient);
            this.clientKeyPasswordLabel.setVisible(serverAndClient);
            this.clientKeyStorePasswordLabel.setVisible(serverAndClient);
            this.clientKeyFileLabel.setVisible(serverAndClient);
        }
    }

    public void readAndSetValues(SecureSocketModeEnum mode, UserInterfaceMqttConnectionDetails connection) {
        if (mode == null || SecureSocketModeEnum.DISABLED.equals((Object)mode)) {
            connection.setSSL(null);
        } else {
            boolean keyStores;
            SecureSocketSettings sslSettings = connection.getSSL();
            boolean bl = keyStores = SecureSocketModeEnum.SERVER_KEYSTORE.equals((Object)mode) || SecureSocketModeEnum.SERVER_AND_CLIENT_KEYSTORES.equals((Object)mode);
            if (keyStores) {
                sslSettings.setServerKeyStoreFile(this.trustStoreFile.getText());
                sslSettings.setServerKeyStorePassword(this.trustStorePassword.getText());
                sslSettings.setClientKeyStoreFile(this.clientKeyStoreFile.getText());
                sslSettings.setClientKeyStorePassword(this.clientKeyStorePassword.getText());
                sslSettings.setClientKeyPassword(this.clientKeyPassword.getText());
            }
            connection.setSSL(sslSettings);
        }
    }

    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        if (connection.getSSL() != null) {
            this.trustStoreFile.setText(connection.getSSL().getServerKeyStoreFile());
            this.trustStorePassword.setText(connection.getSSL().getServerKeyStorePassword());
            this.clientKeyStoreFile.setText(connection.getSSL().getClientKeyStoreFile());
            this.clientKeyStorePassword.setText(connection.getSSL().getClientKeyStorePassword());
            this.clientKeyPassword.setText(connection.getSSL().getClientKeyPassword());
        }
    }

    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }

    public AnchorPane getTlsKeyStoresPane() {
        return this.tlsKeyStoresPane;
    }

    public void setTlsKeyStoresPane(AnchorPane tlsKeyStoresPane) {
        this.tlsKeyStoresPane = tlsKeyStoresPane;
    }
}

