/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import pl.baczkowicz.mqttspy.common.generated.SecureSocketSettings;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.spy.common.generated.SecureSocketModeEnum;
import pl.baczkowicz.spy.ui.utils.DialogFactory;

public class EditConnectionSecurityTlsCertificatesController
extends AnchorPane
implements Initializable {
    private EditMqttConnectionController parent;
    @FXML
    private AnchorPane tlsCertificatesPane;
    @FXML
    private TextField caCertificateFile;
    @FXML
    private Button caCertificateFileButton;
    @FXML
    private PasswordField clientPassword;
    @FXML
    private TextField clientKeyFile;
    @FXML
    private Button clientKeyFileButton;
    @FXML
    private TextField clientCertificateFile;
    @FXML
    private Button clientCertificateFileButton;
    @FXML
    private Label clientKeyPasswordLabel;
    @FXML
    private Label clientKeyFileLabel;
    @FXML
    private Label clientCertificateFileLabel;
    @FXML
    private Label clientKeyPemLabel;
    @FXML
    private CheckBox clientKeyPemFormatted;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionSecurityTlsCertificatesController.this.onChange();
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        DialogFactory.setUpTextFieldFileOpenButton(this.caCertificateFile, this.caCertificateFileButton);
        DialogFactory.setUpTextFieldFileOpenButton(this.clientCertificateFile, this.clientCertificateFileButton);
        DialogFactory.setUpTextFieldFileOpenButton(this.clientKeyFile, this.clientKeyFileButton);
        this.caCertificateFile.textProperty().addListener(this.basicOnChangeListener);
        this.clientCertificateFile.textProperty().addListener(this.basicOnChangeListener);
        this.clientKeyFile.textProperty().addListener(this.basicOnChangeListener);
        this.clientPassword.textProperty().addListener(this.basicOnChangeListener);
        this.clientKeyPemFormatted.selectedProperty().addListener(this.basicOnChangeListener);
    }

    public void init() {
    }

    public void onChange() {
        this.parent.onChange();
    }

    public void updateSSL(SecureSocketModeEnum mode) {
        boolean certificates;
        boolean bl = certificates = SecureSocketModeEnum.SERVER_ONLY.equals((Object)mode) || SecureSocketModeEnum.SERVER_AND_CLIENT.equals((Object)mode);
        if (certificates) {
            boolean serverAndClient = SecureSocketModeEnum.SERVER_AND_CLIENT.equals((Object)mode);
            this.clientPassword.setVisible(serverAndClient);
            this.clientKeyFile.setVisible(serverAndClient);
            this.clientCertificateFile.setVisible(serverAndClient);
            this.clientKeyPasswordLabel.setVisible(serverAndClient);
            this.clientKeyFileLabel.setVisible(serverAndClient);
            this.clientCertificateFileLabel.setVisible(serverAndClient);
            this.clientKeyPemLabel.setVisible(serverAndClient);
            this.clientKeyPemFormatted.setVisible(serverAndClient);
            this.clientCertificateFileButton.setVisible(serverAndClient);
            this.clientKeyFileButton.setVisible(serverAndClient);
        }
    }

    public void readAndSetValues(SecureSocketModeEnum mode, UserInterfaceMqttConnectionDetails connection) {
        if (mode == null || SecureSocketModeEnum.DISABLED.equals((Object)mode)) {
            connection.setSSL(null);
        } else {
            boolean certificates;
            SecureSocketSettings sslSettings = connection.getSSL();
            boolean bl = certificates = SecureSocketModeEnum.SERVER_ONLY.equals((Object)mode) || SecureSocketModeEnum.SERVER_AND_CLIENT.equals((Object)mode);
            if (certificates) {
                sslSettings.setCertificateAuthorityFile(this.caCertificateFile.getText());
                sslSettings.setClientCertificateFile(this.clientCertificateFile.getText());
                sslSettings.setClientKeyFile(this.clientKeyFile.getText());
                sslSettings.setClientKeyPassword(this.clientPassword.getText());
                sslSettings.setClientKeyPEM(this.clientKeyPemFormatted.isSelected());
            }
            connection.setSSL(sslSettings);
        }
    }

    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        if (connection.getSSL() != null) {
            this.caCertificateFile.setText(connection.getSSL().getCertificateAuthorityFile());
            this.clientCertificateFile.setText(connection.getSSL().getClientCertificateFile());
            this.clientKeyFile.setText(connection.getSSL().getClientKeyFile());
            this.clientPassword.setText(connection.getSSL().getClientKeyPassword());
            this.clientKeyPemFormatted.setSelected(Boolean.TRUE.equals(connection.getSSL().isClientKeyPEM()));
        }
    }

    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }

    public AnchorPane getTlsCertificatesPane() {
        return this.tlsCertificatesPane;
    }

    public void setTlsCertificatesPane(AnchorPane tlsCertificatesPane) {
        this.tlsCertificatesPane = tlsCertificatesPane;
    }
}

