/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.net.ssl.SSLContext;
import pl.baczkowicz.mqttspy.common.generated.SecureSocketSettings;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserAuthenticationOptions;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionSecurityTlsCertificatesController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionSecurityTlsKeyStoresController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionSecurityTlsPropertiesController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.IEditConnectionSubController;
import pl.baczkowicz.spy.common.generated.SecureSocketModeEnum;
import pl.baczkowicz.spy.common.generated.UserCredentials;
import pl.baczkowicz.spy.configuration.BaseConfigurationUtils;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public class EditConnectionSecurityController
extends AnchorPane
implements Initializable,
IEditConnectionSubController {
    private EditMqttConnectionController parent;
    @FXML
    private EditConnectionSecurityTlsCertificatesController certificatesPaneController;
    @FXML
    private EditConnectionSecurityTlsKeyStoresController keyStoresPaneController;
    @FXML
    private EditConnectionSecurityTlsPropertiesController propertiesPaneController;
    @FXML
    private CheckBox userAuthentication;
    @FXML
    private TextField username;
    @FXML
    private RadioButton predefinedUsername;
    @FXML
    private RadioButton askForUsername;
    @FXML
    private RadioButton askForPassword;
    @FXML
    private RadioButton predefinedPassword;
    @FXML
    private PasswordField password;
    @FXML
    private ComboBox<SecureSocketModeEnum> modeCombo;
    @FXML
    private ComboBox<String> protocolCombo;
    @FXML
    private AnchorPane customSocketFactoryPane;
    @FXML
    private Tab tlsTab;
    @FXML
    private Tab authTab;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionSecurityController.this.onChange();
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        this.userAuthentication.selectedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionSecurityController.this.updateUserAuthentication();
                EditConnectionSecurityController.this.onChange();
            }
        });
        this.username.textProperty().addListener(this.basicOnChangeListener);
        this.password.textProperty().addListener(this.basicOnChangeListener);
        this.askForUsername.selectedProperty().addListener(this.basicOnChangeListener);
        this.askForPassword.selectedProperty().addListener(this.basicOnChangeListener);
        this.predefinedUsername.selectedProperty().addListener(this.basicOnChangeListener);
        this.predefinedPassword.selectedProperty().addListener(this.basicOnChangeListener);
        this.protocolCombo.getSelectionModel().selectedIndexProperty().addListener(this.basicOnChangeListener);
        final HashMap<SecureSocketModeEnum, String> modeEnumText = new HashMap<SecureSocketModeEnum, String>();
        modeEnumText.put(SecureSocketModeEnum.DISABLED, "Disabled");
        modeEnumText.put(SecureSocketModeEnum.BASIC, "Certificates & keys provided externally");
        modeEnumText.put(SecureSocketModeEnum.SERVER_ONLY, "CA certificate");
        modeEnumText.put(SecureSocketModeEnum.SERVER_KEYSTORE, "CA trust store");
        modeEnumText.put(SecureSocketModeEnum.SERVER_AND_CLIENT, "CA certificate & client certificate/key");
        modeEnumText.put(SecureSocketModeEnum.SERVER_AND_CLIENT_KEYSTORES, "CA trust store & client key store");
        modeEnumText.put(SecureSocketModeEnum.PROPERTIES, "TLS/SSL properties");
        try {
            SSLContext context = SSLContext.getDefault();
            String[] values = context.getSupportedSSLParameters().getProtocols();
            ArrayList<String> filteredValues = new ArrayList<String>();
            filteredValues.addAll(Arrays.asList(values));
            Iterator i = filteredValues.iterator();
            while (i.hasNext()) {
                if (!((String)i.next()).contains("Hello")) continue;
                i.remove();
            }
            this.protocolCombo.getSelectionModel().selectedIndexProperty().addListener(this.basicOnChangeListener);
            this.protocolCombo.getItems().addAll(filteredValues);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        this.modeCombo.getSelectionModel().selectedIndexProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionSecurityController.this.updateSSL();
                EditConnectionSecurityController.this.onChange();
            }
        });
        this.modeCombo.setCellFactory((Callback)new Callback<ListView<SecureSocketModeEnum>, ListCell<SecureSocketModeEnum>>(){

            public ListCell<SecureSocketModeEnum> call(ListView<SecureSocketModeEnum> l) {
                return new ListCell<SecureSocketModeEnum>(){

                    protected void updateItem(SecureSocketModeEnum item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText((String)modeEnumText.get((Object)item));
                        }
                    }
                };
            }
        });
        this.modeCombo.setConverter((StringConverter)new StringConverter<SecureSocketModeEnum>(){

            public String toString(SecureSocketModeEnum item) {
                if (item == null) {
                    return null;
                }
                return (String)modeEnumText.get((Object)item);
            }

            public SecureSocketModeEnum fromString(String id) {
                return null;
            }
        });
        for (SecureSocketModeEnum modeEnum : SecureSocketModeEnum.values()) {
            this.modeCombo.getItems().add((Object)modeEnum);
        }
    }

    public void init() {
        this.certificatesPaneController.setParent(this.parent);
        this.keyStoresPaneController.setParent(this.parent);
        this.propertiesPaneController.setParent(this.parent);
    }

    public void onChange() {
        this.parent.onChange();
    }

    public void updateSSL() {
        SecureSocketModeEnum mode = (SecureSocketModeEnum)((Object)this.modeCombo.getSelectionModel().getSelectedItem());
        boolean certificates = SecureSocketModeEnum.SERVER_ONLY.equals((Object)mode) || SecureSocketModeEnum.SERVER_AND_CLIENT.equals((Object)mode);
        boolean keyStores = SecureSocketModeEnum.SERVER_KEYSTORE.equals((Object)mode) || SecureSocketModeEnum.SERVER_AND_CLIENT_KEYSTORES.equals((Object)mode);
        this.propertiesPaneController.getPropertiesPane().setVisible(SecureSocketModeEnum.PROPERTIES.equals((Object)mode));
        this.certificatesPaneController.getTlsCertificatesPane().setVisible(certificates);
        this.keyStoresPaneController.getTlsKeyStoresPane().setVisible(keyStores);
        this.customSocketFactoryPane.setVisible(certificates || keyStores || SecureSocketModeEnum.BASIC.equals((Object)mode));
        if (certificates) {
            this.certificatesPaneController.updateSSL(mode);
        } else if (keyStores) {
            this.keyStoresPaneController.updateSSL(mode);
        }
        this.updateTlsIcon(!SecureSocketModeEnum.DISABLED.equals((Object)mode));
    }

    @Override
    public UserInterfaceMqttConnectionDetails readValues(UserInterfaceMqttConnectionDetails connection) {
        if (this.userAuthentication.isSelected()) {
            UserAuthenticationOptions userAuthentication = new UserAuthenticationOptions();
            userAuthentication.setAskForUsername(this.askForUsername.isSelected());
            userAuthentication.setAskForPassword(this.askForPassword.isSelected());
            UserCredentials userCredentials = new UserCredentials();
            userCredentials.setUsername(this.username.getText());
            userCredentials.setPassword(BaseConfigurationUtils.encodePassword(this.password.getText()));
            connection.setUserAuthentication(userAuthentication);
            connection.setUserCredentials(userCredentials);
        }
        if (this.modeCombo.getSelectionModel().getSelectedItem() == null || SecureSocketModeEnum.DISABLED.equals(this.modeCombo.getSelectionModel().getSelectedItem())) {
            connection.setSSL(null);
        } else {
            SecureSocketSettings sslSettings = new SecureSocketSettings();
            sslSettings.setMode((SecureSocketModeEnum)((Object)this.modeCombo.getSelectionModel().getSelectedItem()));
            connection.setSSL(sslSettings);
            boolean certificates = SecureSocketModeEnum.SERVER_ONLY.equals(this.modeCombo.getSelectionModel().getSelectedItem()) || SecureSocketModeEnum.SERVER_AND_CLIENT.equals(this.modeCombo.getSelectionModel().getSelectedItem());
            boolean keyStores = SecureSocketModeEnum.SERVER_KEYSTORE.equals(this.modeCombo.getSelectionModel().getSelectedItem()) || SecureSocketModeEnum.SERVER_AND_CLIENT_KEYSTORES.equals(this.modeCombo.getSelectionModel().getSelectedItem());
            this.propertiesPaneController.readAndSetValues((SecureSocketModeEnum)((Object)this.modeCombo.getSelectionModel().getSelectedItem()), connection);
            if (SecureSocketModeEnum.BASIC.equals(this.modeCombo.getSelectionModel().getSelectedItem())) {
                sslSettings.setProtocol((String)this.protocolCombo.getSelectionModel().getSelectedItem());
            } else if (certificates) {
                sslSettings.setProtocol((String)this.protocolCombo.getSelectionModel().getSelectedItem());
                this.certificatesPaneController.readAndSetValues((SecureSocketModeEnum)((Object)this.modeCombo.getSelectionModel().getSelectedItem()), connection);
            } else if (keyStores) {
                sslSettings.setProtocol((String)this.protocolCombo.getSelectionModel().getSelectedItem());
                this.keyStoresPaneController.readAndSetValues((SecureSocketModeEnum)((Object)this.modeCombo.getSelectionModel().getSelectedItem()), connection);
            }
        }
        return connection;
    }

    public void updateUserAuthentication() {
        if (this.userAuthentication.isSelected()) {
            this.predefinedUsername.setDisable(false);
            this.predefinedPassword.setDisable(false);
            this.askForUsername.setDisable(false);
            this.askForPassword.setDisable(false);
            if (this.askForUsername.isSelected()) {
                this.username.setDisable(true);
            } else {
                this.username.setDisable(false);
            }
            if (this.askForPassword.isSelected()) {
                this.password.setDisable(true);
            } else {
                this.password.setDisable(false);
            }
        } else {
            this.username.setDisable(true);
            this.password.setDisable(true);
            this.predefinedUsername.setDisable(true);
            this.predefinedPassword.setDisable(true);
            this.askForUsername.setDisable(true);
            this.askForPassword.setDisable(true);
        }
        this.updateAuthIcon(this.userAuthentication.isSelected());
    }

    @Override
    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        this.userAuthentication.setSelected(connection.getUserAuthentication() != null && connection.getUserCredentials() != null);
        if (this.userAuthentication.isSelected()) {
            this.username.setText(connection.getUserCredentials().getUsername());
            this.password.setText(BaseConfigurationUtils.decodePassword(connection.getUserCredentials().getPassword()));
            this.askForUsername.setSelected(connection.getUserAuthentication().isAskForUsername());
            this.askForPassword.setSelected(connection.getUserAuthentication().isAskForPassword());
            this.predefinedUsername.setSelected(!connection.getUserAuthentication().isAskForUsername());
            this.predefinedPassword.setSelected(!connection.getUserAuthentication().isAskForPassword());
        } else {
            this.username.setText("");
            this.password.setText("");
            this.predefinedUsername.setSelected(false);
            this.predefinedPassword.setSelected(false);
            this.askForUsername.setSelected(true);
            this.askForPassword.setSelected(true);
        }
        if (connection.getSSL() == null) {
            this.modeCombo.getSelectionModel().select((Object)SecureSocketModeEnum.DISABLED);
        } else {
            this.propertiesPaneController.displayConnectionDetails(connection);
            this.modeCombo.getSelectionModel().select((Object)connection.getSSL().getMode());
            for (String item : this.protocolCombo.getItems()) {
                if (!item.equals(connection.getSSL().getProtocol())) continue;
                this.protocolCombo.getSelectionModel().select((Object)item);
                break;
            }
            this.certificatesPaneController.displayConnectionDetails(connection);
            this.keyStoresPaneController.displayConnectionDetails(connection);
        }
        this.showIcons(connection);
        this.updateUserAuthentication();
        this.updateSSL();
    }

    private void updateAuthIcon(boolean authEnabled) {
        HBox authIcon = new HBox();
        UiUtils.createAuthIcon(authIcon, authEnabled, true);
        this.authTab.setGraphic((Node)authIcon);
    }

    private void updateTlsIcon(boolean tlsEnabled) {
        HBox tlsIcon = new HBox();
        UiUtils.createTlsIcon(tlsIcon, tlsEnabled, true);
        this.tlsTab.setGraphic((Node)tlsIcon);
    }

    private void showIcons(ConfiguredMqttConnectionDetails connection) {
        this.updateTlsIcon(connection.getSSL() != null);
        this.updateAuthIcon(connection.getUserCredentials() != null);
    }

    @Override
    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }
}

