/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import pl.baczkowicz.mqttspy.common.generated.MessageLogEnum;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.IEditConnectionSubController;

public class EditConnectionMessageLogController
extends AnchorPane
implements Initializable,
IEditConnectionSubController {
    private EditMqttConnectionController parent;
    @FXML
    private TextField messageLogLocation;
    @FXML
    private ComboBox<MessageLogEnum> loggingMode;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionMessageLogController.this.onChange();
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        this.messageLogLocation.textProperty().addListener(this.basicOnChangeListener);
        this.loggingMode.getSelectionModel().selectedIndexProperty().addListener(this.basicOnChangeListener);
    }

    public void init() {
        this.loggingMode.getItems().addAll((Object[])MessageLogEnum.values());
    }

    public void onChange() {
        this.parent.onChange();
    }

    @Override
    public UserInterfaceMqttConnectionDetails readValues(UserInterfaceMqttConnectionDetails connection) {
        connection.getMessageLog().setLogFile(this.messageLogLocation.getText());
        connection.getMessageLog().setValue((MessageLogEnum)((Object)this.loggingMode.getValue()));
        return connection;
    }

    @Override
    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        this.loggingMode.setValue((Object)(connection.getMessageLog() == null ? MessageLogEnum.DISABLED : connection.getMessageLog().getValue()));
        this.messageLogLocation.setText(connection.getMessageLog() == null ? "" : connection.getMessageLog().getLogFile());
    }

    @Override
    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }
}

