/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.ProtocolVersionEnum;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.IEditConnectionSubController;
import pl.baczkowicz.mqttspy.utils.ConnectionUtils;
import pl.baczkowicz.mqttspy.utils.MqttUtils;
import pl.baczkowicz.spy.common.generated.ReconnectionSettings;
import pl.baczkowicz.spy.ui.keyboard.KeyboardUtils;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;

public class EditConnectionConnectivityController
extends AnchorPane
implements Initializable,
IEditConnectionSubController {
    private static final Logger logger = LoggerFactory.getLogger(EditConnectionConnectivityController.class);
    @FXML
    private Label keepAliveLabel;
    @FXML
    private Label timeoutLabel;
    @FXML
    private Label reconnectIntervalLabel;
    @FXML
    private Label resubscribeLabel;
    @FXML
    private ComboBox<String> connectionTypeCombo;
    @FXML
    private ComboBox<ProtocolVersionEnum> protocolCombo;
    @FXML
    private TextField brokerAddressText;
    @FXML
    private CheckBox reconnect;
    @FXML
    private TextField reconnectionInterval;
    @FXML
    private CheckBox resubscribe;
    @FXML
    private TextField clientIdText;
    @FXML
    private Button addTimestampButton;
    @FXML
    private Label lengthLabel;
    @FXML
    private TextField connectionTimeout;
    @FXML
    private TextField keepAlive;
    @FXML
    private CheckBox cleanSession;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionConnectivityController.this.onChange();
        }
    };
    private EditMqttConnectionController parent;

    public void initialize(URL location, ResourceBundle resources) {
        this.protocolCombo.getSelectionModel().selectedIndexProperty().addListener(this.basicOnChangeListener);
        this.protocolCombo.setCellFactory((Callback)new Callback<ListView<ProtocolVersionEnum>, ListCell<ProtocolVersionEnum>>(){

            public ListCell<ProtocolVersionEnum> call(ListView<ProtocolVersionEnum> l) {
                return new ListCell<ProtocolVersionEnum>(){

                    protected void updateItem(ProtocolVersionEnum item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setText(null);
                        } else if (item.equals((Object)ProtocolVersionEnum.MQTT_DEFAULT)) {
                            this.setText("MQTT (auto-resolve)");
                        } else {
                            this.setText(item.value());
                        }
                    }
                };
            }
        });
        this.protocolCombo.setConverter((StringConverter)new StringConverter<ProtocolVersionEnum>(){

            public String toString(ProtocolVersionEnum item) {
                if (item == null) {
                    return null;
                }
                if (item.equals((Object)ProtocolVersionEnum.MQTT_DEFAULT)) {
                    return "MQTT (auto-resolve)";
                }
                return item.value();
            }

            public ProtocolVersionEnum fromString(String id) {
                return null;
            }
        });
        for (ProtocolVersionEnum protocolEnum : ProtocolVersionEnum.values()) {
            this.protocolCombo.getItems().add((Object)protocolEnum);
        }
        this.connectionTypeCombo.getItems().add((Object)"Default");
        this.connectionTypeCombo.getItems().add((Object)"WebSockets");
        this.connectionTypeCombo.getSelectionModel().selectedIndexProperty().addListener(this.basicOnChangeListener);
        this.brokerAddressText.textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionConnectivityController.this.parent.updateConnectionName();
                EditConnectionConnectivityController.this.onChange();
            }
        });
        this.clientIdText.textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionConnectivityController.this.parent.updateConnectionName();
                EditConnectionConnectivityController.this.onChange();
            }
        });
        this.cleanSession.selectedProperty().addListener(this.basicOnChangeListener);
        this.connectionTimeout.textProperty().addListener(this.basicOnChangeListener);
        this.connectionTimeout.addEventFilter(KeyEvent.KEY_TYPED, KeyboardUtils.nonNumericKeyConsumer);
        this.keepAlive.textProperty().addListener(this.basicOnChangeListener);
        this.keepAlive.addEventFilter(KeyEvent.KEY_TYPED, KeyboardUtils.nonNumericKeyConsumer);
        this.reconnect.selectedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionConnectivityController.this.updateReconnection();
                EditConnectionConnectivityController.this.onChange();
            }
        });
        this.reconnectionInterval.textProperty().addListener(this.basicOnChangeListener);
        this.reconnectionInterval.addEventFilter(KeyEvent.KEY_TYPED, KeyboardUtils.nonNumericKeyConsumer);
        this.resubscribe.selectedProperty().addListener(this.basicOnChangeListener);
    }

    public void init() {
    }

    @FXML
    private void addTimestamp() {
        this.updateClientId(true);
    }

    public boolean updateClientId(boolean addTimestamp) {
        String clientId;
        String newClientId = clientId = this.clientIdText.getText();
        if (MqttUtils.limitClientId(this.parent.getEditedConnectionDetails().getProtocol()) && clientId.length() > 23) {
            newClientId = clientId.substring(0, 23);
        }
        if (addTimestamp) {
            newClientId = MqttUtils.generateClientIdWithTimestamp(System.getProperty("user.name").replaceAll("[^A-Za-z0-9]", ""), this.parent.getEditedConnectionDetails().getProtocol());
        }
        if (!clientId.equals(newClientId)) {
            int currentCurrentPosition = this.clientIdText.getCaretPosition();
            this.clientIdText.setText(newClientId);
            this.clientIdText.positionCaret(currentCurrentPosition);
            return true;
        }
        return false;
    }

    public void updateClientIdLength() {
        if (MqttUtils.limitClientId(this.parent.getEditedConnectionDetails().getProtocol())) {
            this.lengthLabel.setText("Length = " + this.clientIdText.getText().length() + "/" + 23);
        } else {
            this.lengthLabel.setText("Length = " + this.clientIdText.getText().length());
        }
    }

    private void onChange() {
        this.parent.onChange();
    }

    @Override
    public UserInterfaceMqttConnectionDetails readValues(UserInterfaceMqttConnectionDetails connection) {
        List<String> serverURIs = Arrays.asList(this.brokerAddressText.getText().split(";"));
        for (String serverURI : serverURIs) {
            logger.trace("Adding " + serverURI);
            connection.getServerURI().add(serverURI.trim().replaceAll("tcp://", "").replaceAll("ssl://", ""));
        }
        if (this.brokerAddressText.getText().endsWith(";")) {
            logger.trace("Adding empty");
            connection.getServerURI().add("");
        }
        connection.setClientID(this.clientIdText.getText());
        connection.setProtocol((ProtocolVersionEnum)((Object)this.protocolCombo.getSelectionModel().getSelectedItem()));
        connection.setWebSocket(this.connectionTypeCombo.getSelectionModel().getSelectedIndex() == 1);
        connection.setCleanSession(this.cleanSession.isSelected());
        connection.setConnectionTimeout(Integer.valueOf(this.connectionTimeout.getText()));
        connection.setKeepAliveInterval(Integer.valueOf(this.keepAlive.getText()));
        if (this.reconnect.isSelected()) {
            connection.setReconnectionSettings(new ReconnectionSettings(Integer.valueOf(this.reconnectionInterval.getText()) * 1000, this.resubscribe.isSelected()));
        }
        return connection;
    }

    public void updateReconnection() {
        if (this.reconnect.isSelected()) {
            this.reconnectionInterval.setDisable(false);
            if (this.reconnectionInterval.getText().length() == 0) {
                this.reconnectionInterval.setText(String.valueOf(5));
                this.resubscribe.setSelected(true);
            }
            this.resubscribe.setDisable(false);
        } else {
            this.reconnectionInterval.setDisable(true);
            this.reconnectionInterval.setText("");
            this.resubscribe.setDisable(true);
            this.resubscribe.setSelected(false);
        }
    }

    @Override
    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        this.protocolCombo.getSelectionModel().select((Object)connection.getProtocol());
        this.connectionTypeCombo.getSelectionModel().select(connection.isWebSocket() != false ? 1 : 0);
        this.brokerAddressText.setText(ConnectionUtils.serverURIsToString(connection.getServerURI()));
        this.clientIdText.setText(connection.getClientID());
        this.connectionTimeout.setText(connection.getConnectionTimeout().toString());
        this.keepAlive.setText(connection.getKeepAliveInterval().toString());
        this.cleanSession.setSelected(connection.isCleanSession().booleanValue());
        this.reconnect.setSelected(connection.getReconnectionSettings() != null);
        if (connection.getReconnectionSettings() != null) {
            this.reconnect.setSelected(true);
            this.reconnectionInterval.setText(String.valueOf(connection.getReconnectionSettings().getRetryInterval() / 1000));
            this.resubscribe.setSelected(connection.getReconnectionSettings().isResubscribe());
        } else {
            this.reconnect.setSelected(false);
            this.reconnectionInterval.setText("");
            this.resubscribe.setSelected(false);
        }
        this.updateReconnection();
    }

    @Override
    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }

    public TextField getClientIdText() {
        return this.clientIdText;
    }

    public TextField getBrokerAddressText() {
        return this.brokerAddressText;
    }

    public void setPerspective(SpyPerspective perspective) {
        boolean detailed = perspective.equals((Object)SpyPerspective.DETAILED) || perspective.equals((Object)SpyPerspective.SUPER_SPY);
        this.connectionTimeout.setVisible(detailed);
        this.keepAlive.setVisible(detailed);
        this.reconnectionInterval.setVisible(detailed);
        this.resubscribe.setVisible(detailed);
        this.keepAliveLabel.setVisible(detailed);
        this.timeoutLabel.setVisible(detailed);
        this.reconnectIntervalLabel.setVisible(detailed);
        this.resubscribeLabel.setVisible(detailed);
    }
}

