/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttRuntimeConnectionProperties;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.MqttSubscriptionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.MqttMessageController;
import pl.baczkowicz.mqttspy.ui.controllers.SearchWindowController;
import pl.baczkowicz.mqttspy.ui.controllers.SubscriptionSummaryTableController;
import pl.baczkowicz.mqttspy.ui.events.SubscriptionStatusChangeEvent;
import pl.baczkowicz.mqttspy.ui.messagelog.MqttMessageAuditUtils;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.formatting.FormattingUtils;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.controllers.MessageNavigationController;
import pl.baczkowicz.spy.ui.events.ClearTabEvent;
import pl.baczkowicz.spy.ui.events.FormattersChangedEvent;
import pl.baczkowicz.spy.ui.events.MessageAddedEvent;
import pl.baczkowicz.spy.ui.events.MessageFormatChangeEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexChangeEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexIncrementEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexToFirstEvent;
import pl.baczkowicz.spy.ui.events.MessageListChangedEvent;
import pl.baczkowicz.spy.ui.events.MessageRemovedEvent;
import pl.baczkowicz.spy.ui.events.ShowFormattersWindowEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseReceivedMessageEvent;
import pl.baczkowicz.spy.ui.layout.MessageBrowserLayout;
import pl.baczkowicz.spy.ui.panes.TabController;
import pl.baczkowicz.spy.ui.panes.TabStatus;
import pl.baczkowicz.spy.ui.search.UniqueContentOnlyFilter;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.storage.MessageListWithObservableTopicSummary;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.utils.UiUtils;
import pl.baczkowicz.spy.utils.ConversionUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class SubscriptionController
implements Initializable,
TabController {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionController.class);
    public static final String AVG300_TOPIC = "5 minute average";
    public static final String AVG30_TOPIC = "30 second average";
    public static final String AVG5_TOPIC = "5 second average";
    private static final int MIN_EXPANDED_SUMMARY_PANE_HEIGHT = 130;
    private static final int MIN_COLLAPSED_SUMMARY_PANE_HEIGHT = 31;
    private static final String SUMMARY_PANE_TITLE = "Received messages summary";
    private static final String SUMMARY_PANE_STATS_FORMAT = " (%s, %s, " + StatisticsManager.STATS_FORMAT + ")";
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane messagePane;
    @FXML
    private MessageNavigationController messageNavigationPaneController;
    @FXML
    private MqttMessageController messagePaneController;
    @FXML
    private SubscriptionSummaryTableController summaryTablePaneController;
    @FXML
    private TitledPane summaryTitledPane;
    @FXML
    private ToggleGroup wholeMessageFormat;
    @FXML
    private ToggleGroup messageBrowserLayout;
    @FXML
    private MenuButton formattingMenuButton;
    @FXML
    private CheckMenuItem uniqueOnlyMenu;
    @FXML
    private Menu customFormatterMenu;
    @FXML
    private ToggleButton searchButton;
    @FXML
    private ScrollBar messageIndexScrollBar;
    @FXML
    private VBox messagesPane;
    @FXML
    private Slider messageCountSlider;
    private final List<MqttMessageController> messageControllers = new ArrayList<MqttMessageController>();
    private ManagedMessageStoreWithFiltering<FormattedMqttMessage> store;
    private BasicMessageStoreWithSummary<FormattedMqttMessage> statsHistory;
    private Tab tab;
    private MqttRuntimeConnectionProperties connectionProperties;
    private MqttSubscription subscription;
    private Stage searchStage;
    private SearchWindowController searchWindowController;
    private IKBus eventBus;
    private MqttConnectionController connectionController;
    private Label statsLabel;
    private AnchorPane paneTitle;
    private TextField searchBox;
    private HBox topicFilterBox;
    private boolean replayMode;
    private List<FormatterDetails> formatters;
    private UniqueContentOnlyFilter<FormattedMqttMessage> uniqueContentOnlyFilter;
    private TabStatus tabStatus;
    private HBox titleBox;
    private IConfigurationManager configurationManager;
    private FormattingManager formattingManager;
    private long messageIndexLastChangedWithScrollBar;
    private int maxMessagesDisplayed = 1;
    private int messagesDisplayed = 1;
    private Map<MqttMessageController, AnchorPane> messagePanes = new HashMap<MqttMessageController, AnchorPane>();
    private boolean detailedView;
    private Orientation orientation = Orientation.VERTICAL;
    private double summaryTitledPaneTargetWidth;

    public void initialize(URL location, ResourceBundle resources) {
        this.statsLabel = new Label();
        this.topicFilterBox = new HBox();
        this.topicFilterBox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        List<FormatterDetails> formatters = FormattingUtils.createBaseFormatters();
        formatters.addAll(FormattingManager.createDefaultScriptFormatters());
        for (int i = 0; i < formatters.size(); ++i) {
            ((Toggle)this.wholeMessageFormat.getToggles().get(i)).setUserData((Object)formatters.get(i));
        }
        this.wholeMessageFormat.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (SubscriptionController.this.wholeMessageFormat.getSelectedToggle() != null) {
                    SubscriptionController.this.formatWholeMessage();
                }
            }
        });
        ((Toggle)this.messageBrowserLayout.getToggles().get(0)).setUserData((Object)MessageBrowserLayout.SINGLE_TOP);
        ((Toggle)this.messageBrowserLayout.getToggles().get(1)).setUserData((Object)MessageBrowserLayout.SINGLE_BOTTOM);
        ((Toggle)this.messageBrowserLayout.getToggles().get(2)).setUserData((Object)MessageBrowserLayout.SINGLE_RIGHT);
        ((Toggle)this.messageBrowserLayout.getToggles().get(3)).setUserData((Object)MessageBrowserLayout.MULTI_TOP);
        ((Toggle)this.messageBrowserLayout.getToggles().get(4)).setUserData((Object)MessageBrowserLayout.MULTI_BOTTOM);
        ((Toggle)this.messageBrowserLayout.getToggles().get(5)).setUserData((Object)MessageBrowserLayout.MULTI_RIGHT);
        this.messageBrowserLayout.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (SubscriptionController.this.messageBrowserLayout.getSelectedToggle() != null) {
                    SubscriptionController.this.updateLayout((MessageBrowserLayout)((Object)newValue.getUserData()));
                }
            }
        });
        final SubscriptionController controller = this;
        this.messageIndexScrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (SubscriptionController.this.store.getMessages().size() > 0 && TimeUtils.getMonotonicTime() > SubscriptionController.this.messageIndexLastChangedWithScrollBar + 50L) {
                    SubscriptionController.this.eventBus.publish(new MessageIndexChangeEvent(newValue.intValue(), SubscriptionController.this.store, controller));
                    SubscriptionController.this.messageIndexLastChangedWithScrollBar = TimeUtils.getMonotonicTime();
                }
            }
        });
        this.messageCountSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int newNumber = newValue.intValue();
                if (newNumber >= 1) {
                    SubscriptionController.this.messageCountSlider.setValue((double)newNumber);
                    SubscriptionController.this.updateMessagesDisplayed(newNumber);
                    SubscriptionController.this.messageNavigationPaneController.updateRange(SubscriptionController.this.messagesDisplayed);
                } else {
                    SubscriptionController.this.messageCountSlider.setValue(1.0);
                }
            }
        });
        this.messagesPane.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int prevMaxMessagesDisplayed = SubscriptionController.this.maxMessagesDisplayed;
                SubscriptionController.this.maxMessagesDisplayed = (int)Math.floor((newValue.intValue() - 10) / 85);
                if (SubscriptionController.this.maxMessagesDisplayed <= 0) {
                    SubscriptionController.this.maxMessagesDisplayed = 1;
                }
                SubscriptionController.this.messageCountSlider.setMax((double)SubscriptionController.this.maxMessagesDisplayed);
                if (SubscriptionController.this.messageCountSlider.isVisible() && (int)SubscriptionController.this.messageCountSlider.getValue() == prevMaxMessagesDisplayed) {
                    SubscriptionController.this.messageCountSlider.setValue((double)SubscriptionController.this.maxMessagesDisplayed);
                }
            }
        });
        this.summaryTitledPane.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                SubscriptionController.this.updateMinHeights();
            }
        });
        this.messageControllers.add(this.messagePaneController);
        this.messagePanes.put(this.messagePaneController, this.messagePane);
        this.updateMinHeights();
    }

    public void init() {
        Tooltip summaryTitledPaneTooltip = new Tooltip("Load, the average number of messages per second, is calculated over the following intervals: " + StatisticsManager.getPeriodList() + ".");
        this.statsHistory = new BasicMessageStoreWithSummary("stats" + this.store.getName(), this.store.getMessageList().getPreferredSize(), this.store.getMessageList().getMaxSize(), 0, this.formattingManager);
        this.eventBus.subscribeWithFilterOnly(this, this::onClearTab, ClearTabEvent.class, this.store);
        this.getSummaryTablePaneController().setStore(this.store);
        this.getSummaryTablePaneController().setConnectionController(this.connectionController);
        this.getSummaryTablePaneController().setEventBus(this.eventBus);
        this.getSummaryTablePaneController().init();
        this.initialiseMessagePaneController(this.messagePaneController);
        this.messageNavigationPaneController.setMessageAuditUtils(new MqttMessageAuditUtils());
        this.messageNavigationPaneController.setStore(this.store);
        this.messageNavigationPaneController.setEventBus(this.eventBus);
        this.messageNavigationPaneController.init();
        this.eventBus.subscribe(this, this::onMessageIndexChange, MessageIndexChangeEvent.class, new SimpleRunLaterExecutor(), this.store);
        this.eventBus.subscribe(this.messageNavigationPaneController, this.messageNavigationPaneController::onMessageIndexChange, MessageIndexChangeEvent.class, new SimpleRunLaterExecutor(), this.store);
        this.eventBus.subscribe(this.messageNavigationPaneController, this.messageNavigationPaneController::onNavigateToFirst, MessageIndexToFirstEvent.class, new SimpleRunLaterExecutor(), this.store);
        this.eventBus.subscribe(this.messageNavigationPaneController, this.messageNavigationPaneController::onMessageIndexIncrement, MessageIndexIncrementEvent.class, new SimpleRunLaterExecutor(), this.store);
        this.eventBus.subscribe(this, this::handleFormattersChange, FormattersChangedEvent.class);
        this.eventBus.subscribeWithFilterOnly(this.messageNavigationPaneController, this.messageNavigationPaneController::onMessageAdded, MessageAddedEvent.class, this.store.getMessageList());
        this.eventBus.subscribeWithFilterOnly(this.messageNavigationPaneController, this.messageNavigationPaneController::onMessageRemoved, MessageRemovedEvent.class, this.store.getMessageList());
        this.populateFormatters();
        this.paneTitle = new AnchorPane();
        this.paneTitle.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.paneTitle.setMaxWidth(Double.MAX_VALUE);
        this.searchBox = new TextField();
        this.searchBox.getStyleClass().add((Object)"small-font");
        this.searchBox.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        this.searchBox.setMaxWidth(400.0);
        this.searchBox.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SubscriptionController.this.getSummaryTablePaneController().updateTopicFilter(newValue);
            }
        });
        this.topicFilterBox.getChildren().addAll((Object[])new Node[]{new Label(" [search topics: "), this.searchBox, new Label("] ")});
        this.titleBox = new HBox();
        this.titleBox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.titleBox.getChildren().addAll((Object[])new Node[]{new Label(SUMMARY_PANE_TITLE), this.topicFilterBox});
        this.titleBox.prefWidth(Double.MAX_VALUE);
        this.summaryTitledPane.widthProperty().addListener(this.createPaneTitleWidthListener());
        this.statsLabel.widthProperty().addListener(this.createPaneTitleWidthListener());
        this.paneTitle.getChildren().addAll((Object[])new Node[]{this.titleBox, this.statsLabel});
        this.summaryTitledPane.setText(null);
        this.summaryTitledPane.setGraphic((Node)this.paneTitle);
        if (!this.replayMode) {
            this.statsLabel.setTextAlignment(TextAlignment.RIGHT);
            this.statsLabel.setAlignment(Pos.CENTER_RIGHT);
            this.statsLabel.setTooltip(summaryTitledPaneTooltip);
            AnchorPane.setRightAnchor((Node)this.statsLabel, (Double)5.0);
            this.updateSubscriptionStats();
        } else {
            this.messageNavigationPaneController.hideShowLatest();
        }
        this.uniqueContentOnlyFilter = new UniqueContentOnlyFilter<FormattedMqttMessage>(this.store, this.store.getUiEventQueue());
        this.uniqueContentOnlyFilter.setUniqueContentOnly(this.uniqueOnlyMenu.isSelected());
        this.store.getFilteredMessageStore().addMessageFilter(this.uniqueContentOnlyFilter);
        this.uniqueOnlyMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SubscriptionController.this.uniqueContentOnlyFilter.setUniqueContentOnly(SubscriptionController.this.uniqueOnlyMenu.isSelected());
                SubscriptionController.this.store.getFilteredMessageStore().runFilter(SubscriptionController.this.uniqueContentOnlyFilter);
                SubscriptionController.this.eventBus.publish(new MessageListChangedEvent(SubscriptionController.this.store.getMessageList()));
                SubscriptionController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionController.this.store));
            }
        });
        this.resetScrollBar();
    }

    private void initialiseMessagePaneController(MqttMessageController controller) {
        controller.setStore(this.store);
        controller.setConfingurationManager(this.configurationManager);
        controller.setFormattingManager(this.formattingManager);
        controller.init();
        controller.setViewVisibility(this.detailedView);
        this.eventBus.subscribe(controller, controller::onMessageIndexChange, MessageIndexChangeEvent.class, new SimpleRunLaterExecutor(), this.store);
        this.eventBus.subscribe(controller, controller::onFormatChange, MessageFormatChangeEvent.class, new SimpleRunLaterExecutor(), this.store);
    }

    private void updateMessagesDisplayed(int newValue) {
        while (newValue > this.messageControllers.size()) {
            FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("MessagePane.fxml");
            AnchorPane messagePane = FxmlUtils.loadAnchorPane(loader);
            MqttMessageController controller = (MqttMessageController)loader.getController();
            this.initialiseMessagePaneController(controller);
            controller.setMessageIndexOfset(this.messageControllers.size());
            this.messageControllers.add(controller);
            this.messagePanes.put(controller, messagePane);
            VBox.setVgrow((Node)messagePane, (Priority)Priority.ALWAYS);
        }
        while (this.messagesDisplayed > newValue) {
            this.messagesPane.getChildren().remove(this.messagesPane.getChildren().size() - 1);
            --this.messagesDisplayed;
        }
        while (this.messagesDisplayed < newValue) {
            MqttMessageController mc = this.messageControllers.get(this.messagesDisplayed);
            if (mc == null) continue;
            this.messagesPane.getChildren().add((Object)this.messagePanes.get(mc));
            ++this.messagesDisplayed;
        }
        this.eventBus.publish(new MessageIndexChangeEvent((int)this.messageIndexScrollBar.getValue(), this.store, this));
    }

    private void updateLayout(MessageBrowserLayout layout) {
        boolean summaryPaneFirst = true;
        boolean multi = true;
        Orientation newOrientation = Orientation.VERTICAL;
        switch (layout) {
            case MULTI_BOTTOM: {
                break;
            }
            case MULTI_RIGHT: {
                newOrientation = Orientation.HORIZONTAL;
                break;
            }
            case MULTI_TOP: {
                summaryPaneFirst = false;
                break;
            }
            case SINGLE_BOTTOM: {
                multi = false;
                break;
            }
            case SINGLE_RIGHT: {
                newOrientation = Orientation.HORIZONTAL;
                multi = false;
                break;
            }
            case SINGLE_TOP: {
                summaryPaneFirst = false;
                multi = false;
                break;
            }
        }
        if (!newOrientation.equals((Object)this.orientation) && newOrientation.equals((Object)Orientation.HORIZONTAL)) {
            this.summaryTitledPaneTargetWidth = this.summaryTitledPane.getWidth() * 0.65;
            this.splitPane.setDividerPositions(new double[]{0.65});
        }
        this.splitPane.setOrientation(newOrientation);
        if (!newOrientation.equals((Object)this.orientation) && newOrientation.equals((Object)Orientation.HORIZONTAL)) {
            Platform.runLater(() -> {
                logger.debug("layout => updating width with target = {}", (Object)this.summaryTitledPaneTargetWidth);
                this.updateWidth(null);
            });
        }
        this.orientation = newOrientation;
        if (!multi) {
            this.messageCountSlider.setValue(1.0);
            this.messageCountSlider.setMax(1.0);
        }
        this.messageCountSlider.setVisible(multi);
        if (this.splitPane.getItems().size() > 0) {
            if (summaryPaneFirst && ((Node)this.splitPane.getItems().get(1)).equals(this.summaryTitledPane)) {
                this.splitPane.getItems().remove((Object)this.summaryTitledPane);
                this.splitPane.getItems().add(0, (Object)this.summaryTitledPane);
            } else if (!summaryPaneFirst && ((Node)this.splitPane.getItems().get(0)).equals(this.summaryTitledPane)) {
                this.splitPane.getItems().remove((Object)this.summaryTitledPane);
                this.splitPane.getItems().add(1, (Object)this.summaryTitledPane);
            }
        }
    }

    private ChangeListener<Number> createPaneTitleWidthListener() {
        return new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                double oldV = (Double)oldValue;
                double newV = (Double)newValue;
                Double diff = oldV - newV;
                Platform.runLater(() -> SubscriptionController.this.updateWidth(diff));
            }
        };
    }

    private void updateWidth(Double target) {
        double absoluteSearchBoxX = this.searchBox.getLayoutX() + this.topicFilterBox.getLayoutX() + this.titleBox.getLayoutX();
        double titledPaneWidth = MqttViewManager.updateTitleWidth(this.summaryTitledPane, this.paneTitle, MqttViewManager.TITLE_MARGIN, target);
        AnchorPane.setRightAnchor((Node)this.statsLabel, (Double)5.0);
        this.searchBox.setPrefWidth(titledPaneWidth - absoluteSearchBoxX - this.statsLabel.getWidth() - 100.0);
    }

    private void resetScrollBar() {
        this.messageIndexScrollBar.setMin(1.0);
        this.messageIndexScrollBar.setValue(1.0);
        this.messageIndexScrollBar.setMax(1.0);
        this.messageIndexScrollBar.setVisibleAmount(1.0);
        this.messageIndexScrollBar.setDisable(true);
    }

    public void onMessageIndexChange(MessageIndexChangeEvent event) {
        if (event.getDispatcher() == this) {
            return;
        }
        if (event.getIndex() > 0) {
            this.messageIndexScrollBar.setValue((double)event.getIndex());
            this.messageIndexScrollBar.setMax((double)this.store.getMessages().size());
            this.messageIndexScrollBar.setDisable(false);
        } else {
            this.resetScrollBar();
        }
    }

    public void onClose() {
        this.eventBus.unsubscribeConsumer((Object)this, FormattersChangedEvent.class);
    }

    public void handleFormattersChange(FormattersChangedEvent event) {
        this.populateFormatters();
    }

    public void populateFormatters() {
        if (this.formatters.size() > 0) {
            this.customFormatterMenu.setDisable(false);
        }
        this.customFormatterMenu.getItems().clear();
        for (FormatterDetails formatter : this.formatters) {
            if (FormattingUtils.isDefault(formatter)) continue;
            RadioMenuItem customFormatterMenuItem = new RadioMenuItem(formatter.getName());
            customFormatterMenuItem.setToggleGroup(this.wholeMessageFormat);
            customFormatterMenuItem.setUserData((Object)formatter);
            this.customFormatterMenu.getItems().add((Object)customFormatterMenuItem);
            if (this.connectionProperties == null || !formatter.equals(this.connectionProperties.getFormatter())) continue;
            customFormatterMenuItem.setSelected(true);
        }
        this.store.setFormatter((FormatterDetails)this.wholeMessageFormat.getSelectedToggle().getUserData());
    }

    public void setReplayMode(boolean value) {
        this.replayMode = value;
    }

    public void setFormatters(List<FormatterDetails> formatters) {
        this.formatters = formatters;
    }

    public void setViewVisibility(boolean detailedView, boolean basicView) {
        this.detailedView = detailedView;
        for (MqttMessageController controller : this.messageControllers) {
            controller.setViewVisibility(detailedView);
        }
        this.messageNavigationPaneController.setViewVisibility(detailedView);
        if (basicView && this.splitPane.getItems().contains((Object)this.summaryTitledPane)) {
            this.splitPane.getItems().remove((Object)this.summaryTitledPane);
        } else if (!basicView && !this.splitPane.getItems().contains((Object)this.summaryTitledPane)) {
            this.splitPane.getItems().add((Object)this.summaryTitledPane);
        }
    }

    public void toggleDetailedViewVisibility() {
        this.detailedView = !this.detailedView;
        for (MqttMessageController controller : this.messageControllers) {
            controller.toggleDetailedViewVisibility();
        }
        this.messageNavigationPaneController.toggleDetaileledViewVisibility();
    }

    public void onClearTab(ClearTabEvent event) {
        for (MqttMessageController controller : this.messageControllers) {
            controller.clear();
        }
        this.messageNavigationPaneController.clear();
        this.resetScrollBar();
        this.store.setAllShowValues(false);
    }

    public void onSubscriptionStatusChanged(SubscriptionStatusChangeEvent event) {
        this.subscription = event.getChangedSubscription();
        this.updateContextMenu();
    }

    @FXML
    public void formatWholeMessage() {
        this.store.setFormatter((FormatterDetails)this.wholeMessageFormat.getSelectedToggle().getUserData());
        logger.debug("Format changed to {}", (Object)this.store.getFormatter().getName());
        this.eventBus.publish(new MessageFormatChangeEvent(this.store));
    }

    @FXML
    public void editFormatters() {
        this.eventBus.publish(new ShowFormattersWindowEvent(this.getParentWindow(), true));
    }

    public void updateMinHeights() {
        if (this.summaryTitledPane.isExpanded()) {
            this.topicFilterBox.setVisible(true);
            this.summaryTitledPane.setMinHeight(130.0);
        } else {
            this.topicFilterBox.setVisible(false);
            this.summaryTitledPane.setMinHeight(31.0);
            this.splitPane.setDividerPosition(0, 0.95);
        }
    }

    public void setStore(ManagedMessageStoreWithFiltering<FormattedMqttMessage> store) {
        this.store = store;
    }

    @Override
    public void setTab(Tab tab) {
        this.tab = tab;
    }

    public void setConnectionProperties(MqttRuntimeConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    @Override
    public Tab getTab() {
        return this.tab;
    }

    public void setConnectionController(MqttConnectionController connectionController) {
        this.connectionController = connectionController;
    }

    public void updateContextMenu() {
        if (this.subscription != null) {
            MqttSubscriptionViewManager.updateSubscriptionTabContextMenu(this.tab, this.subscription);
        }
    }

    private Window getParentWindow() {
        return this.tab.getTabPane().getScene().getWindow();
    }

    @FXML
    public void showSearchWindow() {
        if (this.searchStage == null) {
            FXMLLoader searchLoader = FxmlUtils.createFxmlLoaderForProjectFile("SearchWindow.fxml");
            AnchorPane searchWindow = FxmlUtils.loadAnchorPane(searchLoader);
            this.searchWindowController = (SearchWindowController)((Object)searchLoader.getController());
            this.searchWindowController.setStore(this.store);
            this.searchWindowController.setSubscription(this.subscription);
            this.searchWindowController.setConnection(this.connectionController.getConnection());
            this.searchWindowController.setSubscriptionName(this.subscription != null ? this.subscription.getTopic() : MqttSubscriptionViewManager.ALL_SUBSCRIPTIONS_TAB_TITLE);
            this.searchWindowController.setEventBus(this.eventBus);
            this.searchWindowController.setConfingurationManager(this.configurationManager);
            this.searchWindowController.setFormattingManager(this.formattingManager);
            this.searchWindowController.setConnectionController(this.connectionController);
            this.eventBus.subscribeWithFilterOnly((Object)this.searchWindowController, this.searchWindowController::onMessageAdded, MessageAddedEvent.class, this.store.getMessageList());
            this.eventBus.subscribeWithFilterOnly((Object)this.searchWindowController, this.searchWindowController::onMessageRemoved, MessageRemovedEvent.class, this.store.getMessageList());
            this.eventBus.subscribeWithFilterOnly((Object)this.searchWindowController, this.searchWindowController::onMessageListChanged, MessageListChangedEvent.class, this.store.getMessageList());
            Scene scene = new Scene((Parent)searchWindow, 780.0, 550.0);
            scene.getStylesheets().addAll((Collection)this.tab.getTabPane().getScene().getStylesheets());
            this.searchStage = new Stage();
            this.searchStage.initModality(Modality.NONE);
            this.searchStage.initOwner(this.getParentWindow());
            this.searchStage.setScene(scene);
            this.searchWindowController.init();
        }
        if (!this.searchStage.isShowing()) {
            this.searchStage.show();
            this.searchStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    SubscriptionController.this.searchButton.setSelected(false);
                    SubscriptionController.this.searchWindowController.handleClose();
                }
            });
        } else {
            this.searchStage.close();
        }
    }

    public void updateSubscriptionStats() {
        int topicCount = this.store.getNonFilteredMessageList().getTopicSummary().getObservableMessagesPerTopic().size();
        int filteredTopicCount = this.getSummaryTablePaneController().getFilteredDataSize();
        int messageCount = this.store.getNonFilteredMessageList().getMessages().size();
        String filteredTopics = topicCount != filteredTopicCount ? "showing " + filteredTopicCount + "/" : "";
        String topicCountText = filteredTopics + (topicCount == 1 ? "1 topic" : topicCount + " topics");
        String messageCountText = messageCount == 1 ? "1 message" : messageCount + " messages";
        Double avg5sec = 0.0;
        Double avg30sec = 0.0;
        Double avg300sec = 0.0;
        if (this.subscription == null) {
            avg5sec = StatisticsManager.getMessagesReceived((String)this.connectionProperties.getId(), (int)5).overallCount;
            avg30sec = StatisticsManager.getMessagesReceived((String)this.connectionProperties.getId(), (int)30).overallCount;
            avg300sec = StatisticsManager.getMessagesReceived((String)this.connectionProperties.getId(), (int)300).overallCount;
            this.statsLabel.setText(String.format(SUMMARY_PANE_STATS_FORMAT, topicCountText, messageCountText, avg5sec, avg30sec, avg300sec));
        } else {
            avg5sec = StatisticsManager.getMessagesReceived((String)this.connectionProperties.getId(), (int)5).messageCount.get(this.subscription.getTopic());
            avg30sec = StatisticsManager.getMessagesReceived((String)this.connectionProperties.getId(), (int)30).messageCount.get(this.subscription.getTopic());
            avg300sec = StatisticsManager.getMessagesReceived((String)this.connectionProperties.getId(), (int)300).messageCount.get(this.subscription.getTopic());
            avg5sec = avg5sec == null ? 0.0 : avg5sec;
            avg30sec = avg30sec == null ? 0.0 : avg30sec;
            avg300sec = avg300sec == null ? 0.0 : avg300sec;
            this.statsLabel.setText(String.format(SUMMARY_PANE_STATS_FORMAT, topicCountText, messageCountText, avg5sec == null ? 0.0 : avg5sec, avg30sec == null ? 0.0 : avg30sec, avg300sec == null ? 0.0 : avg300sec));
        }
        FormattedMqttMessage avg5message = new FormattedMqttMessage(0L, AVG5_TOPIC, new MqttMessage(ConversionUtils.stringToArray(String.valueOf(avg5sec))), null);
        FormattedMqttMessage avg30message = new FormattedMqttMessage(0L, AVG30_TOPIC, new MqttMessage(ConversionUtils.stringToArray(String.valueOf(avg30sec))), null);
        FormattedMqttMessage avg300message = new FormattedMqttMessage(0L, AVG300_TOPIC, new MqttMessage(ConversionUtils.stringToArray(String.valueOf(avg300sec))), null);
        this.statsHistory.storeMessage(avg5message);
        this.statsHistory.storeMessage(avg30message);
        this.statsHistory.storeMessage(avg300message);
        this.eventBus.publish(new MessageAddedEvent(Arrays.asList(new BrowseReceivedMessageEvent<FormattedMqttMessage>((MessageListWithObservableTopicSummary<FormattedMqttMessage>)this.statsHistory.getMessageList(), avg5message)), this.statsHistory.getMessageList()));
        this.eventBus.publish(new MessageAddedEvent(Arrays.asList(new BrowseReceivedMessageEvent<FormattedMqttMessage>((MessageListWithObservableTopicSummary<FormattedMqttMessage>)this.statsHistory.getMessageList(), avg30message)), this.statsHistory.getMessageList()));
        this.eventBus.publish(new MessageAddedEvent(Arrays.asList(new BrowseReceivedMessageEvent<FormattedMqttMessage>((MessageListWithObservableTopicSummary<FormattedMqttMessage>)this.statsHistory.getMessageList(), avg300message)), this.statsHistory.getMessageList()));
    }

    public BasicMessageStoreWithSummary<FormattedMqttMessage> getStatsHistory() {
        return this.statsHistory;
    }

    public void toggleMessagePayloadSize(boolean resize) {
        if (resize) {
            this.messagePane.setMaxHeight(Double.MAX_VALUE);
        } else {
            this.messagePane.setMaxHeight(85.0);
        }
        if (this.searchWindowController != null) {
            this.searchWindowController.toggleMessagePayloadSize(resize);
        }
    }

    @FXML
    private void copyMessageToClipboard() {
        this.messageNavigationPaneController.copyMessageToClipboard();
    }

    @FXML
    private void copyMessagesToClipboard() {
        this.messageNavigationPaneController.copyMessagesToClipboard();
    }

    @FXML
    private void copyMessageToFile() {
        this.messageNavigationPaneController.copyMessageToFile();
    }

    @FXML
    private void copyMessagesToFile() {
        this.messageNavigationPaneController.copyMessagesToFile();
    }

    @FXML
    private void copyBrowsedTopic() {
        this.messageNavigationPaneController.copyMessageTopicToClipboard();
    }

    @FXML
    private void copyBrowsedTopics() {
        UiUtils.copyToClipboard(MqttMessageAuditUtils.getAllTopicsAsString(this.store.getFilteredMessageStore().getBrowsedTopics()));
    }

    @FXML
    private void copyFilteredTopics() {
        UiUtils.copyToClipboard(MqttMessageAuditUtils.getAllTopicsAsString(this.getSummaryTablePaneController().getShownTopics()));
    }

    @FXML
    private void copyAllTopics() {
        UiUtils.copyToClipboard(MqttMessageAuditUtils.getAllTopicsAsString(this.store.getAllTopics()));
    }

    @FXML
    private void copyMessageToBinaryFile() {
        this.messageNavigationPaneController.copyMessageToBinaryFile();
    }

    public MqttSubscription getSubscription() {
        return this.subscription;
    }

    @Override
    public TabStatus getTabStatus() {
        return this.tabStatus;
    }

    @Override
    public void setTabStatus(TabStatus paneStatus) {
        this.tabStatus = paneStatus;
    }

    @Override
    public void refreshStatus() {
    }

    public SubscriptionSummaryTableController getSummaryTablePaneController() {
        return this.summaryTablePaneController;
    }

    public MqttConnectionController getConnectionController() {
        return this.connectionController;
    }

    public void setConfingurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public Scene getScene() {
        return this.splitPane.getScene();
    }

    public void setFormattingManager(FormattingManager formattingManager) {
        this.formattingManager = formattingManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

