/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.SearchPaneController;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.controllers.MessageNavigationController;
import pl.baczkowicz.spy.ui.events.MessageAddedEvent;
import pl.baczkowicz.spy.ui.events.MessageListChangedEvent;
import pl.baczkowicz.spy.ui.events.MessageRemovedEvent;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.utils.StylingUtils;

public class SearchWindowController
extends AnchorPane
implements Initializable {
    public static final int WIDTH = 780;
    public static final int HEIGHT = 550;
    static final Logger logger = LoggerFactory.getLogger(SearchWindowController.class);
    @FXML
    private Button createNewSearchButton;
    @FXML
    private TabPane searchTabs;
    private int searchNumber = 1;
    private Map<Tab, SearchPaneController> searchPaneControllers = new HashMap<Tab, SearchPaneController>();
    private ManagedMessageStoreWithFiltering<FormattedMqttMessage> store;
    private MqttSubscription subscription;
    private String subscriptionName;
    private Stage stage;
    private IKBus eventBus;
    private MqttAsyncConnection connection;
    private MqttConnectionController connectionController;
    private IConfigurationManager configurationManager;
    private FormattingManager formattingManager;

    public void setFormattingManager(FormattingManager formattingManager) {
        this.formattingManager = formattingManager;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.searchTabs.getTabs().clear();
    }

    public void createNewSearch() {
        final Tab tab = this.createSearchTab((Object)this);
        this.searchTabs.getTabs().add((Object)tab);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SearchWindowController.this.searchPaneControllers.get(tab) != null) {
                    ((SearchPaneController)SearchWindowController.this.searchPaneControllers.get(tab)).requestSearchFocus();
                }
            }
        });
    }

    public Tab createSearchTab(Object parent) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("SearchPane.fxml");
        AnchorPane searchPane = FxmlUtils.loadAnchorPane(loader);
        final SearchPaneController searchPaneController = (SearchPaneController)loader.getController();
        Tab tab = new Tab();
        tab.setText("New search " + this.searchNumber);
        ++this.searchNumber;
        tab.setClosable(true);
        tab.setContent((Node)searchPane);
        tab.setOnClosed((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                searchPaneController.cleanup();
            }
        });
        searchPaneController.setTab(tab);
        searchPaneController.setEventBus(this.eventBus);
        searchPaneController.setStore(this.store);
        searchPaneController.setConfingurationManager(this.configurationManager);
        searchPaneController.setFormattingManager(this.formattingManager);
        searchPaneController.setConnection(this.connection);
        searchPaneController.toggleMessagePayloadSize(this.connectionController.getResizeMessageContentMenu().isSelected());
        searchPaneController.init();
        this.searchPaneControllers.put(tab, searchPaneController);
        return tab;
    }

    public void toggleMessagePayloadSize(boolean resize) {
        for (SearchPaneController controller : this.searchPaneControllers.values()) {
            controller.toggleMessagePayloadSize(resize);
        }
    }

    public void handleClose() {
        for (SearchPaneController controller : this.searchPaneControllers.values()) {
            controller.disableAutoSearch();
        }
    }

    public void init() {
        this.stage = (Stage)this.searchTabs.getScene().getWindow();
        this.updateTitle();
        this.createNewSearchButton.setText("Create new search for \"" + this.subscriptionName + "\"");
        if (this.subscription != null) {
            this.createNewSearchButton.setStyle(StylingUtils.createBaseRGBString(this.subscription.getColor()));
        }
    }

    private void updateTitle() {
        String messagesText;
        String string = messagesText = this.store.getMessages().size() == 1 ? "message" : "messages";
        if (!this.store.browsingFiltersEnabled()) {
            this.stage.setTitle(this.subscriptionName + " - " + this.store.getMessages().size() + " " + messagesText + " available for searching");
        } else {
            this.stage.setTitle(this.subscriptionName + " - " + this.store.getMessages().size() + " " + messagesText + " available for searching (" + MessageNavigationController.getBrowsingTopicsInfo(this.store) + ")");
        }
    }

    public void onMessageAdded(MessageAddedEvent<FormattedMessage> event) {
        this.updateTitle();
    }

    public void onMessageRemoved(MessageRemovedEvent<FormattedMessage> event) {
        this.updateTitle();
    }

    public void onMessageListChanged(MessageListChangedEvent event) {
        this.updateTitle();
    }

    public void setStore(ManagedMessageStoreWithFiltering<FormattedMqttMessage> store) {
        this.store = store;
    }

    public void setSubscription(MqttSubscription subscription) {
        this.subscription = subscription;
    }

    public void setSubscriptionName(String name) {
        this.subscriptionName = name;
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    public void setConnectionController(MqttConnectionController connectionController) {
        this.connectionController = connectionController;
    }

    public void setConfingurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

