/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.scripts.MqttScriptManager;
import pl.baczkowicz.mqttspy.ui.controllers.MessageListTableController;
import pl.baczkowicz.mqttspy.ui.controllers.MqttMessageController;
import pl.baczkowicz.mqttspy.ui.controllers.NewPublicationController;
import pl.baczkowicz.mqttspy.ui.messagelog.MqttMessageAuditUtils;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.UiProperties;
import pl.baczkowicz.spy.ui.controllers.MessageNavigationController;
import pl.baczkowicz.spy.ui.events.MessageAddedEvent;
import pl.baczkowicz.spy.ui.events.MessageFormatChangeEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexChangeEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexIncrementEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexToFirstEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseReceivedMessageEvent;
import pl.baczkowicz.spy.ui.properties.MessageContentProperties;
import pl.baczkowicz.spy.ui.search.InlineScriptMatcher;
import pl.baczkowicz.spy.ui.search.ScriptMatcher;
import pl.baczkowicz.spy.ui.search.SearchMatcher;
import pl.baczkowicz.spy.ui.search.SearchOptions;
import pl.baczkowicz.spy.ui.search.SimplePayloadMatcher;
import pl.baczkowicz.spy.ui.search.UniqueContentOnlyFilter;
import pl.baczkowicz.spy.ui.storage.FilteredMessageStore;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;

public class SearchPaneController
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(SearchPaneController.class);
    private static final int MAX_SEARCH_VALUE_CHARACTERS = 15;
    @FXML
    private TextField searchField;
    @FXML
    private MqttMessageController messagePaneController;
    @FXML
    private MessageListTableController messageListTablePaneController;
    @FXML
    private MessageNavigationController messageNavigationPaneController;
    @FXML
    private CheckBox autoRefreshCheckBox;
    @FXML
    private CheckBox caseSensitiveCheckBox;
    @FXML
    private ToggleGroup searchMethod;
    @FXML
    private Menu searchWithScriptsMenu;
    @FXML
    private RadioMenuItem defaultSearch;
    @FXML
    private RadioMenuItem inlineScriptSearch;
    @FXML
    private CheckMenuItem uniqueOnlyMenu;
    @FXML
    private Label textLabel;
    @FXML
    private AnchorPane messagePane;
    @FXML
    private SplitPane splitPane;
    private IKBus eventBus;
    private ManagedMessageStoreWithFiltering<FormattedMqttMessage> store;
    private FilteredMessageStore<FormattedMqttMessage> foundMessageStore;
    private Tab tab;
    private final ObservableList<MessageContentProperties<FormattedMqttMessage>> foundMessages = FXCollections.observableArrayList();
    private int seachedCount;
    private MqttAsyncConnection connection;
    private MqttScriptManager scriptManager;
    private UniqueContentOnlyFilter<FormattedMqttMessage> uniqueContentOnlyFilter;
    private IConfigurationManager configurationManager;
    private FormattingManager formattingManager;

    public void initialize(URL location, ResourceBundle resources) {
        this.searchField.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                switch (keyEvent.getCode()) {
                    case ENTER: {
                        SearchPaneController.this.search();
                        break;
                    }
                }
            }
        });
    }

    public void init() {
        this.foundMessageStore = new FilteredMessageStore(this.store.getMessageList(), this.store.getMessageList().getPreferredSize(), this.store.getMessageList().getMaxSize(), "search-" + this.store.getName(), this.store.getFormatter(), this.formattingManager, UiProperties.getSummaryMaxPayloadLength(this.configurationManager.getUiPropertyFile()));
        this.uniqueContentOnlyFilter = new UniqueContentOnlyFilter<FormattedMqttMessage>(this.store, this.store.getUiEventQueue());
        this.uniqueContentOnlyFilter.setUniqueContentOnly(this.uniqueOnlyMenu.isSelected());
        this.foundMessageStore.addMessageFilter(this.uniqueContentOnlyFilter);
        this.uniqueOnlyMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SearchPaneController.this.uniqueContentOnlyFilter.setUniqueContentOnly(SearchPaneController.this.uniqueOnlyMenu.isSelected());
                SearchPaneController.this.search();
                SearchPaneController.this.eventBus.publish(new MessageIndexToFirstEvent(SearchPaneController.this.foundMessageStore));
            }
        });
        this.messageListTablePaneController.setItems(this.foundMessages);
        this.messageListTablePaneController.setStore(this.foundMessageStore);
        this.messageListTablePaneController.setConnection(this.connection);
        this.messageListTablePaneController.setEventBus(this.eventBus);
        this.messageListTablePaneController.init();
        this.eventBus.subscribe(this.messageListTablePaneController, this.messageListTablePaneController::onMessageIndexChange, MessageIndexChangeEvent.class, new SimpleRunLaterExecutor(), this.foundMessageStore);
        this.messagePaneController.setStore(this.foundMessageStore);
        this.messagePaneController.setConfingurationManager(this.configurationManager);
        this.messagePaneController.setFormattingManager(this.formattingManager);
        this.messagePaneController.setStyled(true);
        this.messagePaneController.init();
        this.eventBus.subscribe(this.messagePaneController, this.messagePaneController::onMessageIndexChange, MessageIndexChangeEvent.class, new SimpleRunLaterExecutor(), this.foundMessageStore);
        this.eventBus.subscribe(this.messagePaneController, this.messagePaneController::onFormatChange, MessageFormatChangeEvent.class, new SimpleRunLaterExecutor(), this.foundMessageStore);
        this.messageNavigationPaneController.setMessageAuditUtils(new MqttMessageAuditUtils());
        this.messageNavigationPaneController.setStore(this.foundMessageStore);
        this.messageNavigationPaneController.setEventBus(this.eventBus);
        this.messageNavigationPaneController.init();
        this.eventBus.subscribe(this.messageNavigationPaneController, this.messageNavigationPaneController::onMessageIndexChange, MessageIndexChangeEvent.class, new SimpleRunLaterExecutor(), this.foundMessageStore);
        this.eventBus.subscribe(this.messageNavigationPaneController, this.messageNavigationPaneController::onNavigateToFirst, MessageIndexToFirstEvent.class, new SimpleRunLaterExecutor(), this.foundMessageStore);
        this.eventBus.subscribe(this.messageNavigationPaneController, this.messageNavigationPaneController::onMessageIndexIncrement, MessageIndexIncrementEvent.class, new SimpleRunLaterExecutor(), this.foundMessageStore);
        this.scriptManager = new MqttScriptManager(null, null, this.connection);
        this.refreshList();
        this.eventBus.subscribeWithFilterOnly(this, this::onMessageAdded, MessageAddedEvent.class, this.store.getMessageList());
        this.eventBus.subscribe(this, this::onFormatChange, MessageFormatChangeEvent.class, new SimpleRunLaterExecutor(), this.store);
    }

    public void setFormattingManager(FormattingManager formattingManager) {
        this.formattingManager = formattingManager;
    }

    public void toggleMessagePayloadSize(boolean resize) {
        if (resize) {
            this.messagePane.setMaxHeight(Double.MAX_VALUE);
        } else {
            this.messagePane.setMaxHeight(50.0);
        }
    }

    private void refreshList() {
        if (this.connection == null) {
            this.searchWithScriptsMenu.setDisable(true);
        } else if (this.connection.getProperties() == null) {
            logger.warn("Connection's properties are null");
        } else if (this.connection.getProperties().getConfiguredProperties() == null) {
            logger.warn("Connection's configured properties are null");
        } else {
            String directory = this.connection.getProperties().getConfiguredProperties().getSearchScripts();
            if (directory != null && !directory.isEmpty()) {
                this.scriptManager.addScripts(directory);
                this.onScriptListChange();
            }
        }
    }

    public void onScriptListChange() {
        Collection<Script> scripts = this.scriptManager.getScripts();
        ArrayList<Script> pubScripts = new ArrayList<Script>();
        for (Script script : scripts) {
            pubScripts.add(script);
        }
        NewPublicationController.updateScriptList(pubScripts, this.searchWithScriptsMenu, this.searchMethod, "Search with '%s' script", new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SearchPaneController.this.onScriptSearch(((Script)SearchPaneController.this.searchMethod.getSelectedToggle().getUserData()).getName());
            }
        });
    }

    @FXML
    private void toggleAutoRefresh() {
        this.updateTabTitle();
    }

    @FXML
    private void onMessagePayloadSearch() {
        this.textLabel.setText("Text to find");
        this.searchField.setText("");
        this.searchField.setPromptText("type some text and press Enter to search");
        this.searchField.setDisable(false);
        this.caseSensitiveCheckBox.setVisible(true);
    }

    private void onScriptSearch(String scriptName) {
        this.textLabel.setText("Search with script");
        this.searchField.setText(scriptName);
        this.searchField.setDisable(true);
        this.caseSensitiveCheckBox.setVisible(false);
    }

    @FXML
    private void onInlineScriptSearch() {
        this.textLabel.setText("Inline script");
        this.searchField.setText("");
        this.searchField.setPromptText("type inline JavaScript and press Enter to search");
        this.searchField.setDisable(false);
        this.caseSensitiveCheckBox.setVisible(false);
    }

    public void requestSearchFocus() {
        this.searchField.requestFocus();
    }

    private void processMessages(List<FormattedMqttMessage> messages) {
        int firstIndex;
        SearchMatcher matcher = this.getSearchMatcher();
        for (int i = firstIndex = this.store.getMessages().size() - 1; i >= 0; --i) {
            this.processMessage(this.store.getMessages().get(i), matcher);
            if (firstIndex == i && !matcher.isValid()) break;
        }
    }

    private SearchMatcher getSearchMatcher() {
        if (this.defaultSearch.isSelected()) {
            return new SimplePayloadMatcher(this.searchField.getText(), this.caseSensitiveCheckBox.isSelected());
        }
        if (this.inlineScriptSearch.isSelected()) {
            return new InlineScriptMatcher((BaseScriptManagerInterface)this.scriptManager, this.searchField.getText());
        }
        Script script = (Script)this.searchMethod.getSelectedToggle().getUserData();
        return new ScriptMatcher(this.scriptManager, script);
    }

    private boolean processMessage(FormattedMqttMessage message, SearchMatcher matcher) {
        ++this.seachedCount;
        boolean found = matcher.matches(message);
        if (found) {
            this.messageFound(message);
            return true;
        }
        return false;
    }

    private void messageFound(FormattedMqttMessage message) {
        this.foundMessages.add(0, new MessageContentProperties<FormattedMqttMessage>(message, UiProperties.getSummaryMaxPayloadLength(this.configurationManager.getUiPropertyFile())));
        if (!this.uniqueContentOnlyFilter.filter(message, this.foundMessageStore.getMessageList(), true) && this.foundMessageStore.storeMessage(message) != null) {
            this.foundMessages.remove(this.foundMessages.size() - 1);
        }
    }

    private void clearMessages() {
        this.seachedCount = 0;
        this.foundMessages.clear();
        this.foundMessageStore.clear();
        this.uniqueContentOnlyFilter.reset();
    }

    @FXML
    private void search() {
        this.clearMessages();
        this.processMessages(this.store.getMessages());
        this.updateTabTitle();
        this.messagePaneController.setSearchOptions(new SearchOptions(this.searchField.getText(), this.caseSensitiveCheckBox.isSelected()));
        this.eventBus.publish(new MessageIndexToFirstEvent(this.foundMessageStore));
    }

    private void updateTabTitle() {
        HBox title = new HBox();
        title.setAlignment(Pos.CENTER);
        if (this.isAutoRefresh()) {
            ProgressIndicator progressIndicator = new ProgressIndicator();
            progressIndicator.setMaxSize(15.0, 15.0);
            title.getChildren().add((Object)progressIndicator);
            title.getChildren().add((Object)new Label(" "));
        }
        String searchValue = this.searchField.getText().length() > 15 ? this.searchField.getText().substring(0, 15) + "..." : this.searchField.getText();
        title.getChildren().add((Object)new Label("Search: \"" + searchValue + "\" [" + this.foundMessages.size() + " found / " + this.seachedCount + " searched]"));
        this.tab.setText(null);
        this.tab.setGraphic((Node)title);
    }

    public void onFormatChange(MessageFormatChangeEvent event) {
        this.foundMessageStore.setFormatter(this.store.getFormatter());
        this.eventBus.publish(new MessageFormatChangeEvent(this.foundMessageStore));
    }

    public void onMessageAdded(MessageAddedEvent<FormattedMessage> event) {
        for (BrowseReceivedMessageEvent<FormattedMessage> message : event.getMessages()) {
            this.onMessageAdded((FormattedMqttMessage)message.getMessage());
        }
    }

    public void onMessageAdded(FormattedMqttMessage message) {
        if (this.autoRefreshCheckBox.isSelected()) {
            boolean matchingSearch = this.processMessage(message, this.getSearchMatcher());
            if (matchingSearch) {
                if (this.messageNavigationPaneController.showLatest()) {
                    this.eventBus.publish(new MessageIndexToFirstEvent(this.foundMessageStore));
                } else {
                    this.eventBus.publish(new MessageIndexIncrementEvent(1, this.foundMessageStore));
                }
            }
            this.updateTabTitle();
        }
    }

    public void cleanup() {
        this.disableAutoSearch();
        this.eventBus.unsubscribeConsumer((Object)this, MessageFormatChangeEvent.class);
        this.eventBus.unsubscribeConsumer((Object)this, MessageAddedEvent.class);
    }

    public void disableAutoSearch() {
        this.autoRefreshCheckBox.setSelected(false);
        this.updateTabTitle();
    }

    @FXML
    private void copyMessageToClipboard() {
        this.messageNavigationPaneController.copyMessageToClipboard();
    }

    @FXML
    private void copyMessagesToClipboard() {
        this.messageNavigationPaneController.copyMessagesToClipboard();
    }

    @FXML
    private void copyMessageToFile() {
        this.messageNavigationPaneController.copyMessageToFile();
    }

    @FXML
    private void copyMessagesToFile() {
        this.messageNavigationPaneController.copyMessagesToFile();
    }

    public void setTab(Tab tab) {
        this.tab = tab;
    }

    public boolean isAutoRefresh() {
        return this.autoRefreshCheckBox.isSelected();
    }

    public void setStore(ManagedMessageStoreWithFiltering<FormattedMqttMessage> store) {
        this.store = store;
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    public void setConfingurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

