/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttSubscriptionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.events.ShowNewMqttSubscriptionWindowEvent;
import pl.baczkowicz.mqttspy.utils.MqttUtils;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.ui.keyboard.TimeBasedKeyEventFilter;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TitledPaneController;
import pl.baczkowicz.spy.ui.utils.DialogFactory;

public class NewSubscriptionController
implements Initializable,
TitledPaneController {
    static final Logger logger = LoggerFactory.getLogger(NewSubscriptionController.class);
    @FXML
    private Button subscribeButton;
    @FXML
    private ComboBox<String> subscriptionTopicText;
    @FXML
    private ChoiceBox<String> subscriptionQosChoice;
    @FXML
    private Label subscriptionQosLabel;
    @FXML
    private ColorPicker subscriptionColorPicker;
    private ObservableList<String> subscriptionTopics = FXCollections.observableArrayList();
    private MqttAsyncConnection connection;
    private List<Color> colors = new ArrayList<Color>();
    private MqttConnectionController connectionController;
    private boolean connected;
    private MqttConnectionViewManager connectionManager;
    private boolean detailedView;
    private TimeBasedKeyEventFilter timeBasedFilter;
    private TitledPane pane;
    private AnchorPane paneTitle;
    private MenuButton settingsButton;
    private PaneVisibilityStatus status;
    private PaneVisibilityStatus previousStatus;
    private IKBus eventBus;
    private Label titleLabel;

    public NewSubscriptionController() {
        this.colors.add(Color.valueOf((String)"f9d900"));
        this.colors.add(Color.valueOf((String)"a9e200"));
        this.colors.add(Color.valueOf((String)"22bad9"));
        this.colors.add(Color.valueOf((String)"0181e2"));
        this.colors.add(Color.valueOf((String)"2f357f"));
        this.colors.add(Color.valueOf((String)"860061"));
        this.colors.add(Color.valueOf((String)"c62b00"));
        this.colors.add(Color.valueOf((String)"ff5700"));
        this.colors.add(Color.valueOf((String)"f9d950"));
        this.colors.add(Color.valueOf((String)"a9e250"));
        this.colors.add(Color.valueOf((String)"22baa9"));
        this.colors.add(Color.valueOf((String)"018122"));
        this.colors.add(Color.valueOf((String)"2f351f"));
        this.colors.add(Color.valueOf((String)"8600F1"));
        this.colors.add(Color.valueOf((String)"c62b60"));
        this.colors.add(Color.valueOf((String)"ff5760"));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.timeBasedFilter = new TimeBasedKeyEventFilter(100L);
        this.subscriptionColorPicker.setValue((Object)this.colors.get(0));
        this.subscriptionTopicText.setItems(this.subscriptionTopics);
        this.subscriptionTopicText.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case ENTER: {
                        if (!NewSubscriptionController.this.connected || !NewSubscriptionController.this.timeBasedFilter.processEvent(event)) break;
                        NewSubscriptionController.this.onSubscribe(event.isControlDown());
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    @FXML
    private void onSubscribe() {
        this.onSubscribe(false);
    }

    private void onSubscribe(boolean controlDown) {
        logger.debug("onSubscribe() {} {}", (Object)controlDown, (Object)this.status);
        if (PaneVisibilityStatus.DETACHED.equals((Object)this.status)) {
            this.subscribe();
            if (!controlDown) {
                this.eventBus.publish(new ShowNewMqttSubscriptionWindowEvent(this.connectionController, this.previousStatus, PaneVisibilityStatus.DETACHED));
            }
        } else {
            this.subscribe();
        }
    }

    public void init() {
        this.titleLabel = new Label(this.pane.getText());
        this.paneTitle = new AnchorPane();
        this.settingsButton = MqttViewManager.createTitleButtons(this, this.paneTitle, this.connectionController);
    }

    private void updateVisibility() {
        if (this.detailedView) {
            AnchorPane.setRightAnchor(this.subscriptionTopicText, (Double)262.0);
            this.subscriptionQosChoice.setVisible(true);
            this.subscriptionQosLabel.setVisible(true);
        } else {
            AnchorPane.setRightAnchor(this.subscriptionTopicText, (Double)179.0);
            this.subscriptionQosChoice.setVisible(false);
            this.subscriptionQosLabel.setVisible(false);
        }
    }

    public void setViewVisibility(boolean detailedView) {
        this.detailedView = detailedView;
        this.updateVisibility();
    }

    public void toggleDetailedViewVisibility() {
        this.detailedView = !this.detailedView;
        this.updateVisibility();
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
        this.subscribeButton.setDisable(!connected);
        this.subscriptionTopicText.setDisable(!connected);
    }

    public boolean recordSubscriptionTopic(String subscriptionTopic) {
        return MqttUtils.recordTopic(subscriptionTopic, this.subscriptionTopics);
    }

    @FXML
    public void subscribe() {
        String subscriptionTopic = this.subscriptionTopicText.getEditor().getText();
        logger.debug("subscribe() to {}", (Object)subscriptionTopic);
        if (subscriptionTopic != null) {
            try {
                MqttUtils.validateTopic(subscriptionTopic);
                TabbedSubscriptionDetails subscriptionDetails = new TabbedSubscriptionDetails();
                subscriptionDetails.setTopic(subscriptionTopic);
                subscriptionDetails.setQos(this.subscriptionQosChoice.getSelectionModel().getSelectedIndex());
                this.subscribe(subscriptionDetails, true);
            }
            catch (SpyException e) {
                DialogFactory.createErrorDialog("Invalid topic", "Provided topic is not valid. " + e.getMessage());
            }
        } else {
            DialogFactory.createErrorDialog("Invalid topic", "Cannot subscribe to an empty topic.");
        }
    }

    public void subscribe(TabbedSubscriptionDetails subscriptionDetails, boolean subscribe) {
        logger.info("Subscribing to " + subscriptionDetails.getTopic());
        MqttSubscriptionViewManager subscriptionManager = this.connectionManager.getSubscriptionManager(this.connectionController);
        if (!subscriptionManager.getSubscriptionControllersMap().keySet().contains(subscriptionDetails.getTopic())) {
            this.recordSubscriptionTopic(subscriptionDetails.getTopic());
            this.connectionManager.getSubscriptionManager(this.connectionController).createSubscription((Color)this.subscriptionColorPicker.getValue(), subscribe, subscriptionDetails, this.connection, this.connectionController, this);
            this.subscriptionColorPicker.setValue((Object)this.colors.get(this.connection.getLastUsedSubscriptionId() % 16));
        } else {
            DialogFactory.createErrorDialog("Duplicate topic", "You already have a subscription tab with " + subscriptionDetails.getTopic() + " topic.");
        }
    }

    @Override
    public void updatePane(PaneVisibilityStatus status) {
        this.status = status;
        if (PaneVisibilityStatus.ATTACHED.equals((Object)status)) {
            this.settingsButton.setVisible(true);
            this.titleLabel.setText("Define new subscription");
        } else {
            this.settingsButton.setVisible(false);
            this.titleLabel.setText("After typing the value, hit Enter or click Subscribe; hold Control to keep the window");
        }
    }

    public void requestFocus() {
        if (this.status.equals((Object)PaneVisibilityStatus.DETACHED)) {
            this.connectionController.getPaneToStatusMapping().get(this.pane).getParentWhenDetached().toFront();
        }
        this.pane.requestFocus();
        this.subscriptionTopicText.requestFocus();
        this.subscriptionTopicText.fireEvent((Event)new KeyEvent((Object)this, this.subscriptionTopicText, KeyEvent.KEY_PRESSED, "", "", KeyCode.A, false, true, false, false));
    }

    public void setConnectionManager(MqttConnectionViewManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setConnectionController(MqttConnectionController connectionController) {
        this.connectionController = connectionController;
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    @Override
    public TitledPane getTitledPane() {
        return this.pane;
    }

    @Override
    public void setTitledPane(TitledPane pane) {
        this.pane = pane;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public void setPreviousStatus(PaneVisibilityStatus previousStatus) {
        this.previousStatus = previousStatus;
    }
}

