/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.SimpleMqttMessage;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.MqttMessageController;
import pl.baczkowicz.mqttspy.ui.scripts.InteractiveMqttScriptManager;
import pl.baczkowicz.mqttspy.utils.MqttUtils;
import pl.baczkowicz.spy.common.generated.ConversionMethod;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.ConversionException;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.ui.keyboard.TimeBasedKeyEventFilter;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TitledPaneController;
import pl.baczkowicz.spy.ui.properties.PublicationScriptProperties;
import pl.baczkowicz.spy.ui.scripts.ScriptTypeEnum;
import pl.baczkowicz.spy.ui.scripts.events.ScriptListChangeEvent;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.utils.ConversionUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class NewPublicationController
implements Initializable,
TitledPaneController {
    private static final Logger logger = LoggerFactory.getLogger(NewPublicationController.class);
    private static final int MAX_RECENT_MESSAGES = 10;
    private MenuButton settingsButton;
    @FXML
    private SplitMenuButton publishButton;
    @FXML
    private ToggleGroup publishScript;
    @FXML
    private ComboBox<String> publicationTopicText;
    @FXML
    private ChoiceBox<String> publicationQosChoice;
    @FXML
    private StyleClassedTextArea publicationData;
    @FXML
    private ToggleGroup formatGroup;
    @FXML
    private CheckBox retainedBox;
    @FXML
    private Label retainedLabel;
    @FXML
    private Label dataLabel;
    @FXML
    private Label publicationQosLabel;
    @FXML
    private Label lengthLabel;
    @FXML
    private MenuButton formatMenu;
    @FXML
    private Menu publishWithScriptsMenu;
    @FXML
    private Menu recentMessagesMenu;
    @FXML
    private Menu saveRecentMessagesMenu;
    private ObservableList<String> publicationTopics = FXCollections.observableArrayList();
    private MqttAsyncConnection connection;
    private ConversionMethod formatSelected = ConversionMethod.PLAIN;
    private boolean connected;
    private boolean detailedView;
    private InteractiveMqttScriptManager scriptManager;
    private Label titleLabel;
    private IKBus eventBus;
    private List<BaseMqttMessage> recentMessages = new ArrayList<BaseMqttMessage>();
    private TimeBasedKeyEventFilter timeBasedFilter;
    private TitledPane pane;
    private AnchorPane paneTitle;
    protected MqttConnectionController connectionController;

    public void initialize(URL location, ResourceBundle resources) {
        this.timeBasedFilter = new TimeBasedKeyEventFilter(500L);
        this.publicationTopicText.setItems(this.publicationTopics);
        ((Toggle)this.formatGroup.getToggles().get(0)).setUserData((Object)ConversionMethod.PLAIN);
        ((Toggle)this.formatGroup.getToggles().get(1)).setUserData((Object)ConversionMethod.HEX_DECODE);
        ((Toggle)this.formatGroup.getToggles().get(2)).setUserData((Object)ConversionMethod.BASE_64_DECODE);
        this.formatGroup.selectToggle((Toggle)this.formatGroup.getToggles().get(0));
        this.formatGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    switch ((ConversionMethod)((Object)NewPublicationController.this.formatGroup.getSelectedToggle().getUserData())) {
                        case BASE_64_DECODE: {
                            NewPublicationController.this.showAsBase64();
                            break;
                        }
                        case HEX_DECODE: {
                            NewPublicationController.this.showAsHex();
                            break;
                        }
                        case PLAIN: {
                            NewPublicationController.this.showAsPlain();
                            break;
                        }
                    }
                }
            }
        });
        this.publicationTopicText.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                switch (keyEvent.getCode()) {
                    case ENTER: {
                        if (!NewPublicationController.this.connected || !NewPublicationController.this.timeBasedFilter.processEvent(keyEvent)) break;
                        NewPublicationController.this.publish();
                        keyEvent.consume();
                        break;
                    }
                    case DIGIT0: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 0);
                        break;
                    }
                    case DIGIT1: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 1);
                        break;
                    }
                    case DIGIT2: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 2);
                        break;
                    }
                    case DIGIT3: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 3);
                        break;
                    }
                    case DIGIT4: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 4);
                        break;
                    }
                    case DIGIT5: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 5);
                        break;
                    }
                    case DIGIT6: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 6);
                        break;
                    }
                    case DIGIT7: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 7);
                        break;
                    }
                    case DIGIT8: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 8);
                        break;
                    }
                    case DIGIT9: {
                        NewPublicationController.this.restoreFromKeypress(keyEvent, 9);
                        break;
                    }
                }
            }
        });
        this.publicationData.setWrapText(true);
        this.publicationData.setOnKeyReleased((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                BaseMqttMessage values = NewPublicationController.this.readMessage(false, true);
                String payload = "";
                if (values != null) {
                    payload = values.getPayload();
                }
                MqttMessageController.populatePayloadLength(NewPublicationController.this.lengthLabel, null, payload.length());
                NewPublicationController.this.lengthLabel.getStyleClass().removeAll((Object[])new String[]{"newLinesPresent", "noNewLines"});
                if (payload.contains("\n") || payload.contains("\r\n") || payload.contains("\r")) {
                    NewPublicationController.this.lengthLabel.getStyleClass().add((Object)"newLinesPresent");
                } else {
                    NewPublicationController.this.lengthLabel.getStyleClass().add((Object)"noNewLines");
                }
            }
        });
        ((Toggle)this.publishScript.getToggles().get(0)).setUserData(null);
        this.publishScript.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue.getUserData() == null) {
                    NewPublicationController.this.publishButton.setText("Publish");
                } else {
                    NewPublicationController.this.publishButton.setText("Publish" + System.lineSeparator() + "with" + System.lineSeparator() + "script");
                }
            }
        });
        this.publishButton.setTooltip(new Tooltip("Publish message [" + MqttViewManager.newPublication.getDisplayText() + "]"));
    }

    public void init() {
        this.titleLabel = new Label(this.pane.getText());
        this.eventBus.subscribe(this, this::onScriptListChange, ScriptListChangeEvent.class, new SimpleRunLaterExecutor(), this.connection);
        this.paneTitle = new AnchorPane();
        this.settingsButton = MqttViewManager.createTitleButtons(this, this.paneTitle, this.connectionController);
    }

    public void onScriptListChange(ScriptListChangeEvent event) {
        ObservableList<PublicationScriptProperties> scripts = this.scriptManager.getObservableScriptList();
        ArrayList<Script> pubScripts = new ArrayList<Script>();
        for (PublicationScriptProperties properties : scripts) {
            if (!ScriptTypeEnum.PUBLICATION.equals(properties.typeProperty().getValue())) continue;
            pubScripts.add(properties.getScript());
        }
        NewPublicationController.updateScriptList(pubScripts, this.publishWithScriptsMenu, this.publishScript, "Publish with '%s' script", null);
    }

    public static void updateScriptList(List<Script> scripts, Menu scriptsMenu, ToggleGroup toggleGroup, String format, EventHandler<ActionEvent> eventHandler) {
        while (scriptsMenu.getItems().size() > 0) {
            scriptsMenu.getItems().remove(0);
        }
        if (scripts.size() > 0) {
            for (Script script : scripts) {
                RadioMenuItem item = new RadioMenuItem(String.format(format, script.getName()));
                item.setOnAction(eventHandler);
                item.setToggleGroup(toggleGroup);
                item.setUserData((Object)script);
                scriptsMenu.getItems().add((Object)item);
            }
        }
    }

    public void setConnectionController(MqttConnectionController connectionController) {
        this.connectionController = connectionController;
    }

    public void recordPublicationTopic(String publicationTopic) {
        MqttUtils.recordTopic(publicationTopic, this.publicationTopics);
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
        this.publishButton.setDisable(!connected);
        this.publicationTopicText.setDisable(!connected);
    }

    private void decodeToPlain() {
        if (this.formatSelected.equals((Object)ConversionMethod.HEX_DECODE)) {
            try {
                String convertedText = ConversionUtils.hexToString(this.publicationData.getText());
                logger.info("Converted {} to {}", (Object)this.publicationData.getText(), (Object)convertedText);
                this.publicationData.clear();
                this.publicationData.appendText(convertedText);
                this.formatMenu.setText("Input format: Plain");
            }
            catch (ConversionException e) {
                this.showAndLogHexError();
                this.formatGroup.selectToggle((Toggle)this.formatGroup.getToggles().get(1));
                this.formatMenu.setText("Input format: Hex");
            }
        } else if (this.formatSelected.equals((Object)ConversionMethod.BASE_64_DECODE)) {
            String convertedText = ConversionUtils.base64ToString(this.publicationData.getText());
            logger.info("Converted {} to {}", (Object)this.publicationData.getText(), (Object)convertedText);
            this.publicationData.clear();
            this.publicationData.appendText(convertedText);
            this.formatMenu.setText("Input format: Plain");
        }
    }

    @FXML
    public void showAsPlain() {
        if (!ConversionMethod.PLAIN.equals((Object)this.formatSelected)) {
            this.decodeToPlain();
            this.formatSelected = ConversionMethod.PLAIN;
        }
    }

    @FXML
    public void showAsHex() {
        if (!ConversionMethod.HEX_DECODE.equals((Object)this.formatSelected)) {
            BaseMqttMessage message = this.readMessage(false, false);
            String convertedText = ConversionUtils.arrayToHex(message.getRawMessage().getPayload());
            logger.info("Converted {} to {}", (Object)this.publicationData.getText(), (Object)convertedText);
            this.publicationData.clear();
            this.publicationData.appendText(convertedText);
            this.formatMenu.setText("Input format: Hex");
            this.formatSelected = ConversionMethod.HEX_DECODE;
        }
    }

    @FXML
    public void showAsBase64() {
        if (!ConversionMethod.BASE_64_DECODE.equals((Object)this.formatSelected)) {
            BaseMqttMessage message = this.readMessage(false, false);
            String convertedText = ConversionUtils.arrayToBase64(message.getRawMessage().getPayload());
            logger.info("Converted {} to {}", (Object)this.publicationData.getText(), (Object)convertedText);
            this.publicationData.clear();
            this.publicationData.appendText(convertedText);
            this.formatMenu.setText("Input format: Base64");
            this.formatSelected = ConversionMethod.BASE_64_DECODE;
        }
    }

    private void updateVisibility() {
        if (this.detailedView) {
            AnchorPane.setRightAnchor(this.publicationTopicText, (Double)327.0);
            AnchorPane.setRightAnchor((Node)this.publicationData, (Double)326.0);
            AnchorPane.setTopAnchor((Node)this.dataLabel, (Double)31.0);
        } else {
            AnchorPane.setRightAnchor(this.publicationTopicText, (Double)128.0);
            AnchorPane.setRightAnchor((Node)this.publicationData, (Double)127.0);
            AnchorPane.setTopAnchor((Node)this.dataLabel, (Double)37.0);
        }
        this.formatMenu.setVisible(this.detailedView);
        this.publicationQosChoice.setVisible(this.detailedView);
        this.publicationQosLabel.setVisible(this.detailedView);
        this.retainedBox.setVisible(this.detailedView);
        this.retainedLabel.setVisible(this.detailedView);
        this.lengthLabel.setVisible(this.detailedView);
    }

    public void setViewVisibility(boolean detailedView) {
        this.detailedView = detailedView;
        this.updateVisibility();
    }

    public void toggleDetailedViewVisibility() {
        this.detailedView = !this.detailedView;
        this.updateVisibility();
    }

    private void displayMessage(BaseMqttMessage message) {
        this.displayMessage(new SimpleMqttMessage(message.getPayload(), message.getTopic(), message.getQoS(), message.isRetained()));
    }

    public void displayMessage(SimpleMqttMessage message) {
        if (message == null) {
            this.publicationTopicText.setValue((Object)"");
            this.publicationTopicText.setPromptText("(cannot be empty)");
            this.publicationQosChoice.getSelectionModel().select(0);
            this.publicationData.clear();
            this.retainedBox.setSelected(false);
        } else {
            this.publicationTopicText.setValue((Object)message.getTopic());
            this.publicationQosChoice.getSelectionModel().select(message.getQos().intValue());
            this.publicationData.clear();
            this.publicationData.appendText(message.getValue());
            this.retainedBox.setSelected(message.isRetained().booleanValue());
        }
    }

    public BaseMqttMessage readMessage(boolean verify, boolean ignoreConversionErrors) {
        String topic = this.publicationTopicText.getEditor().getText();
        if (verify && (topic == null || topic.isEmpty())) {
            logger.error("Cannot publish to an empty topic");
            DialogFactory.createErrorDialog("Invalid topic", "Cannot publish to an empty topic.");
            return null;
        }
        BaseMqttMessage message = new BaseMqttMessage(0L, topic, new MqttMessage());
        try {
            if (this.formatSelected.equals((Object)ConversionMethod.PLAIN)) {
                byte[] data = ConversionUtils.stringToArray(this.publicationData.getText());
                message.getRawMessage().setPayload(data);
            } else if (this.formatSelected.equals((Object)ConversionMethod.HEX_DECODE)) {
                byte[] data = ConversionUtils.hexToArray(this.publicationData.getText());
                message.getRawMessage().setPayload(data);
            } else if (this.formatSelected.equals((Object)ConversionMethod.BASE_64_DECODE)) {
                byte[] data = ConversionUtils.base64ToArray(this.publicationData.getText());
                message.getRawMessage().setPayload(data);
            }
            message.getRawMessage().setQos(this.publicationQosChoice.getSelectionModel().getSelectedIndex());
            message.getRawMessage().setRetained(this.retainedBox.isSelected());
            return message;
        }
        catch (ConversionException e) {
            if (!ignoreConversionErrors) {
                this.showAndLogHexError();
            }
            return null;
        }
    }

    @FXML
    public void publish() {
        Script script = (Script)this.publishScript.getSelectedToggle().getUserData();
        boolean defaultPublication = script == null;
        BaseMqttMessage message = this.readMessage(defaultPublication, false);
        if (message != null) {
            this.recordMessage(message);
            if (defaultPublication) {
                logger.debug("Publishing (no script)");
                this.connection.publish(message.getTopic(), message.getRawMessage().getPayload(), message.getQoS(), message.isRetained());
                this.recordPublicationTopic(message.getTopic());
            } else {
                logger.debug("Publishing with '{}' script", (Object)script.getName());
                this.scriptManager.runScriptFileWithMessage(script, message);
            }
        }
    }

    private void recordMessage(BaseMqttMessage message) {
        if (this.recentMessages.size() > 0 && message.getTopic().equals(this.recentMessages.get(0).getTopic()) && message.getPayload().equals(this.recentMessages.get(0).getPayload())) {
            this.recentMessages.remove(0);
        }
        this.recentMessages.add(0, message);
        while (this.recentMessages.size() > 10) {
            this.recentMessages.remove(10);
        }
        this.refreshRecentMessages();
    }

    private void refreshRecentMessages() {
        while (this.recentMessagesMenu.getItems().size() > 0) {
            this.recentMessagesMenu.getItems().remove(0);
        }
        while (this.saveRecentMessagesMenu.getItems().size() > 0) {
            this.saveRecentMessagesMenu.getItems().remove(0);
        }
        for (final BaseMqttMessage message : this.recentMessages) {
            String topic = message.getTopic();
            String payload = message.getPayload().length() > 10 ? message.getPayload().substring(0, 10) + "..." : message.getPayload();
            String time = TimeUtils.DATE_WITH_SECONDS_SDF.format(message.getDate());
            String messageText = "Topic = '" + topic + "', payload = '" + payload + "', published at " + time;
            MenuItem recentMessageItem = new MenuItem(messageText);
            recentMessageItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NewPublicationController.this.displayMessage(message);
                }
            });
            this.recentMessagesMenu.getItems().add((Object)recentMessageItem);
            MenuItem saveMessageItem = new MenuItem(messageText);
            saveMessageItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NewPublicationController.this.saveAsScript(message);
                }
            });
            this.saveRecentMessagesMenu.getItems().add((Object)saveMessageItem);
        }
        this.recentMessagesMenu.setDisable(this.recentMessagesMenu.getItems().size() == 0);
        this.saveRecentMessagesMenu.setDisable(this.saveRecentMessagesMenu.getItems().size() == 0);
    }

    @FXML
    private void saveCurrentAsScript() {
        BaseMqttMessage message = this.readMessage(true, false);
        if (message != null) {
            this.saveAsScript(message);
        }
    }

    private void saveAsScript(BaseMqttMessage message) {
        boolean valid = false;
        while (!valid) {
            Optional<String> response = DialogFactory.createInputDialog(this.pane.getScene().getWindow(), "Enter a name for your message-based script", "Script name (without .js)");
            logger.info("Script name response = " + response);
            if (!response.isPresent()) break;
            String scriptName = response.get();
            String configuredDirectory = this.connection.getProperties().getConfiguredProperties().getPublicationScripts();
            String directory = InteractiveMqttScriptManager.getScriptDirectoryForConnection(configuredDirectory);
            File scriptFile = new File(directory + scriptName + ".js");
            Script script = this.scriptManager.getScriptObjectFromName(Script.getScriptIdFromFile(scriptFile));
            if (script != null) {
                Optional<ButtonType> duplicateNameResponse = DialogFactory.createQuestionDialog("Script name already exists", "Script with name \"" + scriptName + "\" already exists in your script folder (" + directory + "). Do you want to override it?");
                if (duplicateNameResponse.get() == ButtonType.NO) continue;
                if (duplicateNameResponse.get() == ButtonType.CANCEL) break;
            }
            this.createScriptFromMessage(scriptFile, configuredDirectory, message);
            break;
        }
    }

    private void createScriptFromMessage(File scriptFile, String configuredDirectory, BaseMqttMessage message) {
        StringBuffer scriptText = new StringBuffer();
        scriptText.append("mqttspy.publish(\"");
        scriptText.append(message.getTopic());
        scriptText.append("\", \"");
        scriptText.append(StringEscapeUtils.escapeEcmaScript(message.getPayload()));
        scriptText.append("\", ");
        scriptText.append(message.getQoS());
        scriptText.append(", ");
        scriptText.append(message.isRetained());
        scriptText.append(");");
        try {
            String templateFilename = "/samples/template-script.js";
            String template = FileUtils.loadFileByNameAsString("/samples/template-script.js");
            String script = template.replace("mqttspy.publish(\"topic\", \"payload\");", scriptText.toString());
            logger.info("Writing file to " + scriptFile.getAbsolutePath());
            FileUtils.writeToFile(scriptFile, script);
            this.scriptManager.addScripts(configuredDirectory, ScriptTypeEnum.PUBLICATION);
            this.eventBus.publish(new ScriptListChangeEvent(this.connection));
        }
        catch (IOException e) {
            logger.error("Cannot create the script file at " + scriptFile.getAbsolutePath(), e);
        }
    }

    private void restoreFromKeypress(KeyEvent keyEvent, int keyNumber) {
        if (keyEvent.isAltDown()) {
            int arrayIndex = (keyNumber > 0 ? keyNumber : 10) - 1;
            if (arrayIndex < this.recentMessages.size()) {
                this.displayMessage(this.recentMessages.get(arrayIndex));
            }
            keyEvent.consume();
        }
    }

    private void showAndLogHexError() {
        logger.error("Cannot convert " + this.publicationData.getText() + " to plain text");
        DialogFactory.createErrorDialog("Invalid hex format", "Provided text is not a valid hex string.");
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    public void clearTopics() {
        this.publicationTopics.clear();
    }

    public ComboBox<String> getPublicationTopicText() {
        return this.publicationTopicText;
    }

    public ChoiceBox<String> getPublicationQosChoice() {
        return this.publicationQosChoice;
    }

    public StyleClassedTextArea getPublicationData() {
        return this.publicationData;
    }

    public CheckBox getRetainedBox() {
        return this.retainedBox;
    }

    public void setScriptManager(InteractiveMqttScriptManager scriptManager) {
        this.scriptManager = scriptManager;
    }

    public void hidePublishButton() {
        this.publishButton.setVisible(false);
    }

    @Override
    public TitledPane getTitledPane() {
        return this.pane;
    }

    @Override
    public void setTitledPane(TitledPane pane) {
        this.pane = pane;
    }

    @Override
    public void updatePane(PaneVisibilityStatus status) {
        if (PaneVisibilityStatus.ATTACHED.equals((Object)status)) {
            this.settingsButton.setVisible(true);
        } else {
            this.settingsButton.setVisible(false);
        }
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public Label getTitleLabel() {
        return this.titleLabel;
    }
}

