/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.spy.ui.controllers.BaseMessageController;

public class MqttMessageController
extends BaseMessageController<FormattedMqttMessage>
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(MqttMessageController.class);
    @FXML
    private CheckBox retainedField;
    @FXML
    private TextField qosField;
    @FXML
    private Label retainedFieldLabel;
    @FXML
    private Label qosFieldLabel;

    public void initialize(URL location, ResourceBundle resources) {
    }

    @Override
    protected void updateVisibility() {
        super.updateVisibility();
        this.qosField.setVisible(this.detailedView);
        this.qosFieldLabel.setVisible(this.detailedView);
        this.retainedField.setVisible(this.detailedView);
        this.retainedFieldLabel.setVisible(this.detailedView);
    }

    @Override
    public void populate(FormattedMqttMessage message) {
        if (message != null && !message.equals(this.message)) {
            super.populate(message);
            this.qosField.setText(String.valueOf(message.getQoS()));
            this.retainedField.setSelected(message.isRetained());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.qosField.setText("");
        this.retainedField.setSelected(false);
    }
}

