/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttPublicationScriptsController;
import pl.baczkowicz.mqttspy.ui.controllers.NewPublicationController;
import pl.baczkowicz.mqttspy.ui.controllers.NewSubscriptionController;
import pl.baczkowicz.mqttspy.ui.controllers.SubscriptionController;
import pl.baczkowicz.mqttspy.ui.controllers.SubscriptionsController;
import pl.baczkowicz.mqttspy.ui.events.ShowNewMqttSubscriptionWindowEvent;
import pl.baczkowicz.mqttspy.ui.scripts.InteractiveMqttScriptManager;
import pl.baczkowicz.mqttspy.ui.utils.DialogUtils;
import pl.baczkowicz.mqttspy.ui.utils.MqttStylingUtils;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.controllers.IConnectionController;
import pl.baczkowicz.spy.ui.controllers.TestCasesExecutionController;
import pl.baczkowicz.spy.ui.events.ConnectionStatusChangeEvent;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityManager;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TabController;
import pl.baczkowicz.spy.ui.panes.TabStatus;
import pl.baczkowicz.spy.ui.panes.TitledPaneStatus;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public class MqttConnectionController
implements Initializable,
TabController,
PaneVisibilityManager,
IConnectionController {
    private static final int MIN_COLLAPSED_PANE_HEIGHT = 26;
    private static final int SUBSCRIPTION_PANE_MIN_EXPANDED_HEIGHT = 66;
    private static final int TEST_CASES_PANE_MIN_EXPANDED_HEIGHT = 190;
    private static final int PUBLICATION_PANE_MIN_EXPANDED_HEIGHT = 96;
    private static final int SCRIPTED_PUBLICATION_PANE_MIN_EXPANDED_HEIGHT = 136;
    private static final double MIN_WINDOW_HIGHT = 66.0;
    private static final double MIN_WINDOW_WIDTH = 300.0;
    private static final Logger logger = LoggerFactory.getLogger(MqttConnectionController.class);
    @FXML
    private AnchorPane connectionPane;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane newPublicationPane;
    @FXML
    private AnchorPane newSubscriptionPane;
    @FXML
    private NewPublicationController newPublicationPaneController;
    @FXML
    private MqttPublicationScriptsController publicationScriptsPaneController;
    @FXML
    private NewSubscriptionController newSubscriptionPaneController;
    @FXML
    private TestCasesExecutionController testCasesPaneController;
    private SubscriptionsController subscriptionsController = new SubscriptionsController();
    @FXML
    private Button newSubButton;
    @FXML
    private TitledPane publishMessageTitledPane;
    @FXML
    private TitledPane newSubscriptionTitledPane;
    @FXML
    private TitledPane scriptedPublicationsTitledPane;
    @FXML
    private TitledPane subscriptionsTitledPane;
    @FXML
    private TitledPane testCasesTitledPane;
    private TitledPaneStatus publishMessageTitledStatus = new TitledPaneStatus(0);
    private TitledPaneStatus newSubscriptionTitledStatus = new TitledPaneStatus(3);
    private TitledPaneStatus scriptedPublicationsTitledStatus = new TitledPaneStatus(1);
    private TitledPaneStatus subscriptionsTitledStatus = new TitledPaneStatus(4);
    private TitledPaneStatus testCasesTitledStatus = new TitledPaneStatus(2);
    @FXML
    private TabPane subscriptionTabs;
    private MqttAsyncConnection connection;
    private Tab connectionTab;
    private Tooltip tooltip;
    private StatisticsManager statisticsManager;
    private MqttConnectionViewManager connectionManager;
    private IKBus eventBus;
    private Map<TitledPane, TitledPaneStatus> paneToStatus = new HashMap<TitledPane, TitledPaneStatus>();
    private boolean detailedView;
    private boolean replayMode;
    private TabStatus tabStatus;
    private CheckMenuItem resizeMessageContentMenu = new CheckMenuItem();

    private ChangeListener<Boolean> createChangeListener() {
        return new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                MqttConnectionController.this.updateMinHeights();
            }
        };
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.newSubButton.setTooltip(new Tooltip("Create new subscription [" + MqttViewManager.newSubscription.getDisplayText() + "]"));
        MenuItem attach = new MenuItem("Show attached");
        final MqttConnectionController controller = this;
        attach.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MqttConnectionController.this.showNewSubscription(PaneVisibilityStatus.ATTACHED, controller);
            }
        });
        this.newSubButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (MouseButton.PRIMARY.equals((Object)event.getButton())) {
                    MqttConnectionController.this.showNewSubscription(PaneVisibilityStatus.DETACHED, controller);
                } else {
                    MqttConnectionController.this.newSubButton.getContextMenu().show(MqttConnectionController.this.newSubButton.getScene().getWindow());
                }
            }
        });
        this.newSubButton.setContextMenu(new ContextMenu(new MenuItem[]{attach}));
        this.newSubButton.setDisable(false);
    }

    private void showNewSubscription(PaneVisibilityStatus status, MqttConnectionController connectionController) {
        this.eventBus.publish(new ShowNewMqttSubscriptionWindowEvent(connectionController, status, connectionController.getNewSubscriptionPaneStatus().getVisibility()));
    }

    @FXML
    public void newSubscription() {
        Tab selectedTab = this.connectionTab;
        MqttConnectionController controller = (MqttConnectionController)this.connectionManager.getControllerForTab(selectedTab);
        if (controller != null) {
            this.eventBus.publish(new ShowNewMqttSubscriptionWindowEvent(controller, PaneVisibilityStatus.DETACHED, controller.getNewSubscriptionPaneStatus().getVisibility()));
        }
    }

    public void init() {
        this.publishMessageTitledStatus.setController(this.newPublicationPaneController);
        this.newSubscriptionTitledStatus.setController(this.newSubscriptionPaneController);
        this.scriptedPublicationsTitledStatus.setController(this.publicationScriptsPaneController);
        this.subscriptionsTitledStatus.setController(this.subscriptionsController);
        this.testCasesTitledStatus.setController(this.testCasesPaneController);
        this.subscriptionsTitledPane.expandedProperty().addListener(this.createChangeListener());
        this.subscriptionsTitledStatus.setVisibility(PaneVisibilityStatus.ATTACHED);
        this.paneToStatus.put(this.subscriptionsTitledPane, this.subscriptionsTitledStatus);
        this.subscriptionsController.setTitledPane(this.subscriptionsTitledPane);
        this.subscriptionsController.setConnectionController(this);
        this.subscriptionsController.init();
        if (!this.replayMode) {
            this.publishMessageTitledPane.expandedProperty().addListener(this.createChangeListener());
            this.scriptedPublicationsTitledPane.expandedProperty().addListener(this.createChangeListener());
            this.newSubscriptionTitledPane.expandedProperty().addListener(this.createChangeListener());
            this.scriptedPublicationsTitledPane.setExpanded(false);
            this.publishMessageTitledStatus.setVisibility(PaneVisibilityStatus.ATTACHED);
            this.scriptedPublicationsTitledStatus.setVisibility(PaneVisibilityStatus.ATTACHED);
            this.newSubscriptionTitledStatus.setVisibility(PaneVisibilityStatus.ATTACHED);
            this.testCasesTitledStatus.setVisibility(PaneVisibilityStatus.NOT_VISIBLE);
            this.paneToStatus.put(this.publishMessageTitledPane, this.publishMessageTitledStatus);
            this.paneToStatus.put(this.scriptedPublicationsTitledPane, this.scriptedPublicationsTitledStatus);
            this.paneToStatus.put(this.newSubscriptionTitledPane, this.newSubscriptionTitledStatus);
            this.newPublicationPaneController.setConnection(this.connection);
            this.newPublicationPaneController.setScriptManager(this.connection.getScriptManager());
            this.newPublicationPaneController.setEventBus(this.eventBus);
            this.newPublicationPaneController.setConnectionController(this);
            this.newPublicationPaneController.setTitledPane(this.publishMessageTitledPane);
            this.newPublicationPaneController.init();
            this.newSubscriptionPaneController.setConnection(this.connection);
            this.newSubscriptionPaneController.setConnectionController(this);
            this.newSubscriptionPaneController.setEventBus(this.eventBus);
            this.newSubscriptionPaneController.setConnectionManager(this.connectionManager);
            this.newSubscriptionPaneController.setTitledPane(this.newSubscriptionTitledPane);
            this.newSubscriptionPaneController.init();
            this.publicationScriptsPaneController.setConnection(this.connection);
            this.publicationScriptsPaneController.setEventBus(this.eventBus);
            this.publicationScriptsPaneController.setPaneVisibilityManager(this);
            this.publicationScriptsPaneController.setTitledPane(this.scriptedPublicationsTitledPane);
            this.publicationScriptsPaneController.init();
            this.tooltip = new Tooltip();
            this.connectionTab.setTooltip(this.tooltip);
        } else {
            this.splitPane.getItems().remove((Object)this.publishMessageTitledPane);
            this.splitPane.getItems().remove((Object)this.scriptedPublicationsTitledPane);
            this.splitPane.getItems().remove((Object)this.newSubscriptionTitledPane);
            this.splitPane.getItems().remove((Object)this.testCasesTitledPane);
        }
        this.updateVisiblePanes();
        this.updateMinHeights();
    }

    private void initialiseTestCasesPane() {
        if (this.testCasesPaneController == null) {
            FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("TestCasesExecutionPane.fxml");
            AnchorPane testCasesPane = FxmlUtils.loadAnchorPane(loader);
            this.testCasesTitledPane = new TitledPane();
            this.testCasesTitledPane.setText("Test cases");
            this.testCasesTitledPane.setContent((Node)testCasesPane);
            this.testCasesTitledPane.expandedProperty().addListener(this.createChangeListener());
            this.testCasesTitledPane.setExpanded(false);
            this.testCasesPaneController = (TestCasesExecutionController)loader.getController();
            this.testCasesPaneController.setScriptManager(new InteractiveMqttScriptManager(this.eventBus, this.connection));
            this.testCasesPaneController.setTitledPane(this.testCasesTitledPane);
            this.testCasesPaneController.init();
            this.testCasesPaneController.setSettingsButton(MqttViewManager.createTitleButtons(this.testCasesPaneController, new AnchorPane(), this));
            this.testCasesTitledStatus.setController(this.testCasesPaneController);
            this.paneToStatus.put(this.testCasesTitledPane, this.testCasesTitledStatus);
            logger.debug("Test cases pane initialised!");
        }
    }

    @Override
    public Map<TitledPane, TitledPaneStatus> getPaneToStatusMapping() {
        return this.paneToStatus;
    }

    public void setConnectionManager(MqttConnectionViewManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void updateMinHeights() {
        if (this.publishMessageTitledPane.isExpanded()) {
            this.publishMessageTitledPane.setMinHeight(96.0);
        } else {
            this.publishMessageTitledPane.setMinHeight(26.0);
        }
        if (this.scriptedPublicationsTitledPane.isExpanded()) {
            this.scriptedPublicationsTitledPane.setMinHeight(136.0);
        } else {
            this.scriptedPublicationsTitledPane.setMinHeight(26.0);
        }
        if (this.newSubscriptionTitledPane.isExpanded()) {
            this.newSubscriptionTitledPane.setMinHeight(66.0);
            this.newSubscriptionTitledPane.setMaxHeight(66.0);
        } else {
            this.newSubscriptionTitledPane.setMinHeight(26.0);
            this.newSubscriptionTitledPane.setMaxHeight(26.0);
        }
        if (this.testCasesTitledPane != null) {
            if (this.testCasesTitledPane.isExpanded()) {
                this.testCasesTitledPane.setMinHeight(190.0);
            } else {
                this.testCasesTitledPane.setMinHeight(26.0);
            }
        }
    }

    public MqttAsyncConnection getConnection() {
        return this.connection;
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    @Override
    public Tab getTab() {
        return this.connectionTab;
    }

    @Override
    public void setTab(Tab tab) {
        this.connectionTab = tab;
    }

    public TabPane getSubscriptionTabs() {
        return this.subscriptionTabs;
    }

    public void showTabTile(boolean pending) {
        if (pending) {
            HBox title = new HBox();
            title.setAlignment(Pos.CENTER);
            ProgressIndicator progressIndicator = new ProgressIndicator();
            progressIndicator.setMaxSize(15.0, 15.0);
            title.getChildren().add((Object)progressIndicator);
            title.getChildren().add((Object)new Label(" " + this.connection.getName()));
            this.connectionTab.setGraphic((Node)title);
            this.connectionTab.setText(null);
        } else if (this.connection.getConnectionStatus().equals((Object)ConnectionStatus.CONNECTED)) {
            this.connectionTab.setGraphic((Node)UiUtils.createSecurityIcons(this.connection.getProperties().getSSL() != null, this.connection.getProperties().getUserCredentials() != null, false));
            this.connectionTab.setText(this.connection.getName());
        } else {
            this.connectionTab.setGraphic(null);
            this.connectionTab.setText(this.connection.getName());
        }
    }

    public void onConnectionStatusChanged(ConnectionStatusChangeEvent event) {
        ConnectionStatus connectionStatus = event.getConnectionStatus();
        logger.debug("Updating {} connection status to {}", (Object)event.getName(), (Object)connectionStatus);
        this.newSubscriptionPaneController.setConnected(false);
        this.getNewPublicationPaneController().setConnected(false);
        for (BaseMqttSubscription sub : this.connection.getSubscriptions().values()) {
            if (!(sub instanceof MqttSubscription)) continue;
            ((MqttSubscription)sub).getSubscriptionController().updateContextMenu();
        }
        if (this.connectionTab.getContextMenu() != null && this.connectionTab.getContextMenu().getItems().size() > 0) {
            switch (connectionStatus) {
                case NOT_CONNECTED: {
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(0)).setDisable(false);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(2)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(3)).setDisable(false);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(5)).setDisable(true);
                    this.showTabTile(false);
                    break;
                }
                case CONNECTED: {
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(0)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(2)).setDisable(false);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(3)).setDisable(false);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(5)).setDisable(false);
                    this.newSubscriptionPaneController.setConnected(true);
                    this.getNewPublicationPaneController().setConnected(true);
                    this.showTabTile(false);
                    break;
                }
                case CONNECTING: {
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(2)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(0)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(3)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(5)).setDisable(true);
                    this.showTabTile(true);
                    break;
                }
                case DISCONNECTED: {
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(0)).setDisable(false);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(2)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(3)).setDisable(false);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(5)).setDisable(true);
                    this.showTabTile(false);
                    break;
                }
                case DISCONNECTING: {
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(0)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(2)).setDisable(true);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(3)).setDisable(false);
                    ((MenuItem)this.connectionTab.getContextMenu().getItems().get(5)).setDisable(true);
                    this.showTabTile(false);
                    break;
                }
            }
        }
        if (this.connectionTab.getStyleClass().size() > 1) {
            this.connectionTab.getStyleClass().remove(1);
        }
        this.connectionTab.getStyleClass().add((Object)MqttStylingUtils.getStyleForMqttConnectionStatus(connectionStatus));
        DialogUtils.updateConnectionTooltip(this.connection, this.tooltip);
    }

    @Override
    public void updateConnectionStats() {
        for (SubscriptionController subscriptionController : this.connectionManager.getSubscriptionManager(this).getSubscriptionControllers()) {
            subscriptionController.updateSubscriptionStats();
        }
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public NewSubscriptionController getNewSubscriptionPaneController() {
        return this.newSubscriptionPaneController;
    }

    @Override
    public void setPaneVisiblity(TitledPaneStatus paneStatus, PaneVisibilityStatus visibility) {
        if (paneStatus == this.testCasesTitledStatus && this.testCasesPaneController == null && (PaneVisibilityStatus.ATTACHED.equals((Object)visibility) || PaneVisibilityStatus.DETACHED.equals((Object)visibility))) {
            this.initialiseTestCasesPane();
        }
        if (!this.replayMode) {
            paneStatus.setRequestedVisibility(visibility);
            this.updateVisiblePanes();
            this.updateMenus();
        }
    }

    public boolean getDetailedViewVisibility() {
        return this.detailedView;
    }

    public void setViewVisibility(boolean detailedView, boolean basicView) {
        this.detailedView = detailedView;
        this.newSubscriptionPaneController.setViewVisibility(detailedView);
        this.getNewPublicationPaneController().setViewVisibility(detailedView);
        for (SubscriptionController subscriptionController : this.connectionManager.getSubscriptionManager(this).getSubscriptionControllers()) {
            subscriptionController.setViewVisibility(detailedView, basicView);
        }
    }

    public void toggleMessagePayloadSize(boolean resize) {
        for (SubscriptionController subscriptionController : this.connectionManager.getSubscriptionManager(this).getSubscriptionControllers()) {
            subscriptionController.toggleMessagePayloadSize(resize);
        }
    }

    public void toggleDetailedViewVisibility() {
        this.newSubscriptionPaneController.toggleDetailedViewVisibility();
        this.getNewPublicationPaneController().toggleDetailedViewVisibility();
        for (SubscriptionController subscriptionController : this.connectionManager.getSubscriptionManager(this).getSubscriptionControllers()) {
            subscriptionController.toggleDetailedViewVisibility();
        }
    }

    public void showPanes(PaneVisibilityStatus showManualPublications, PaneVisibilityStatus showScriptedPublications, PaneVisibilityStatus showNewSubscription, PaneVisibilityStatus showReceivedMessagesSummary) {
        if (!this.replayMode) {
            this.subscriptionsTitledStatus.setRequestedVisibility(showReceivedMessagesSummary);
            this.publishMessageTitledStatus.setRequestedVisibility(showManualPublications);
            this.scriptedPublicationsTitledStatus.setRequestedVisibility(showScriptedPublications);
            this.newSubscriptionTitledStatus.setRequestedVisibility(showNewSubscription);
            this.updateVisiblePanes();
            this.updateMenus();
        }
    }

    public void setReplayMode(boolean value) {
        this.replayMode = value;
    }

    public void showReplayMode() {
        this.connectionTab.getStyleClass().add((Object)"connection-replay");
        this.subscriptionsTitledStatus.setRequestedVisibility(PaneVisibilityStatus.ATTACHED);
        this.publishMessageTitledStatus.setRequestedVisibility(PaneVisibilityStatus.NOT_VISIBLE);
        this.scriptedPublicationsTitledStatus.setRequestedVisibility(PaneVisibilityStatus.NOT_VISIBLE);
        this.newSubscriptionTitledStatus.setRequestedVisibility(PaneVisibilityStatus.NOT_VISIBLE);
        this.testCasesTitledStatus.setRequestedVisibility(PaneVisibilityStatus.NOT_VISIBLE);
        this.updateVisiblePanes();
        this.subscriptionsTitledPane.setText("Logged messages");
        this.subscriptionsController.init();
    }

    private void updateMenus() {
        for (TitledPaneStatus status : this.paneToStatus.values()) {
            status.updateMenu();
        }
    }

    private void insertPane(TitledPaneStatus status) {
        int insertIndex = this.splitPane.getItems().size();
        for (int i = 0; i < this.splitPane.getItems().size(); ++i) {
            Node pane = (Node)this.splitPane.getItems().get(i);
            if (this.paneToStatus.get(pane).getDisplayIndex() <= status.getDisplayIndex()) continue;
            insertIndex = i;
            break;
        }
        this.splitPane.getItems().add(insertIndex, (Object)status.getController().getTitledPane());
    }

    private void updateVisiblePanes() {
        for (final TitledPaneStatus status : this.paneToStatus.values()) {
            if (status.getVisibility().equals((Object)status.getRequestedVisibility())) continue;
            status.setVisibility(status.getRequestedVisibility());
            status.getController().updatePane(status.getRequestedVisibility());
            if (status.getPreviousVisibility().equals((Object)PaneVisibilityStatus.DETACHED)) {
                status.getController().getTitledPane().setCollapsible(true);
                status.getController().getTitledPane().setExpanded(status.isLastExpanded());
                if (status.getParentWhenDetached().isShowing()) {
                    status.getParentWhenDetached().close();
                }
            } else if (status.getPreviousVisibility().equals((Object)PaneVisibilityStatus.ATTACHED) && this.splitPane.getItems().contains((Object)status.getController().getTitledPane())) {
                this.splitPane.getItems().remove((Object)status.getController().getTitledPane());
            }
            if (status.getVisibility().equals((Object)PaneVisibilityStatus.DETACHED)) {
                Stage stage = DialogFactory.createWindowWithPane((Node)status.getController().getTitledPane(), this.splitPane.getScene(), this.connection.getName(), 0.0);
                status.setParentWhenDetached(stage);
                status.setLastExpanded(status.getController().getTitledPane().isExpanded());
                stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        status.setRequestedVisibility(status.getPreviousVisibility());
                        MqttConnectionController.this.updateVisiblePanes();
                        MqttConnectionController.this.updateMenus();
                        MqttConnectionController.this.updateMinHeights();
                    }
                });
                status.getController().getTitledPane().setExpanded(true);
                status.getController().getTitledPane().setCollapsible(false);
                this.updateMinHeights();
                double paneMinHeight = status.getController().getTitledPane().getMinHeight();
                stage.setMinHeight(paneMinHeight > 66.0 ? paneMinHeight : 66.0);
                stage.setMinWidth(300.0);
                stage.show();
                continue;
            }
            if (!status.getVisibility().equals((Object)PaneVisibilityStatus.ATTACHED) || this.splitPane.getItems().contains((Object)status.getController().getTitledPane())) continue;
            this.insertPane(status);
        }
    }

    @Override
    public TabStatus getTabStatus() {
        return this.tabStatus;
    }

    @Override
    public void setTabStatus(TabStatus paneStatus) {
        this.tabStatus = paneStatus;
    }

    @Override
    public void refreshStatus() {
        if (this.connection != null) {
            this.onConnectionStatusChanged(new ConnectionStatusChangeEvent(this.connection, this.connection.getName(), this.connection.getConnectionStatus()));
        }
    }

    public NewPublicationController getNewPublicationPaneController() {
        return this.newPublicationPaneController;
    }

    public SubscriptionsController getSubscriptionsController() {
        return this.subscriptionsController;
    }

    public MqttPublicationScriptsController getPublicationScriptsPaneController() {
        return this.publicationScriptsPaneController;
    }

    public CheckMenuItem getResizeMessageContentMenu() {
        return this.resizeMessageContentMenu;
    }

    public TestCasesExecutionController getTestCasesPaneController() {
        return this.testCasesPaneController;
    }

    public TitledPaneStatus getNewPublicationPaneStatus() {
        return this.publishMessageTitledStatus;
    }

    public TitledPaneStatus getPublicationScriptsPaneStatus() {
        return this.scriptedPublicationsTitledStatus;
    }

    public TitledPaneStatus getNewSubscriptionPaneStatus() {
        return this.newSubscriptionTitledStatus;
    }

    public TitledPaneStatus getSubscriptionsStatus() {
        return this.subscriptionsTitledStatus;
    }

    public TitledPaneStatus getTestCasesPaneStatus() {
        return this.testCasesTitledStatus;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

