/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.events.MessageIndexChangeEvent;
import pl.baczkowicz.spy.ui.properties.MessageContentProperties;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.utils.StylingUtils;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public class MessageListTableController
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(MessageListTableController.class);
    private ObservableList<MessageContentProperties<FormattedMqttMessage>> items;
    @FXML
    private TableView<MessageContentProperties<FormattedMqttMessage>> messageTable;
    @FXML
    private TableColumn<MessageContentProperties<FormattedMqttMessage>, String> messageTopicColumn;
    @FXML
    private TableColumn<MessageContentProperties<FormattedMqttMessage>, String> messageContentColumn;
    @FXML
    private TableColumn<MessageContentProperties<FormattedMqttMessage>, String> messageReceivedAtColumn;
    private BasicMessageStoreWithSummary<FormattedMqttMessage> store;
    private MqttAsyncConnection connection;
    private IKBus eventBus;

    public void initialize(URL location, ResourceBundle resources) {
        this.messageTopicColumn.setCellValueFactory((Callback)new PropertyValueFactory("topic"));
        this.messageContentColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastReceivedPayload"));
        this.messageReceivedAtColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastReceivedTimestamp"));
        this.messageReceivedAtColumn.setCellFactory((Callback)new Callback<TableColumn<MessageContentProperties<FormattedMqttMessage>, String>, TableCell<MessageContentProperties<FormattedMqttMessage>, String>>(){

            public TableCell<MessageContentProperties<FormattedMqttMessage>, String> call(TableColumn<MessageContentProperties<FormattedMqttMessage>, String> param) {
                TableCell<MessageContentProperties<FormattedMqttMessage>, String> cell = new TableCell<MessageContentProperties<FormattedMqttMessage>, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.messageTable.setOnMouseClicked((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                MessageListTableController.this.selectItem();
            }
        });
        this.messageTable.setRowFactory((Callback)new Callback<TableView<MessageContentProperties<FormattedMqttMessage>>, TableRow<MessageContentProperties<FormattedMqttMessage>>>(){

            public TableRow<MessageContentProperties<FormattedMqttMessage>> call(TableView<MessageContentProperties<FormattedMqttMessage>> tableView) {
                TableRow<MessageContentProperties<FormattedMqttMessage>> row = new TableRow<MessageContentProperties<FormattedMqttMessage>>(){

                    protected void updateItem(MessageContentProperties<FormattedMqttMessage> item, boolean empty) {
                        super.updateItem(item, empty);
                        if (!this.isEmpty() && item.getSubscription() != null) {
                            BaseMqttSubscription subscription = MessageListTableController.this.connection.getMqttSubscriptionForTopic(item.getSubscription());
                            if (subscription instanceof MqttSubscription) {
                                this.setStyle(StylingUtils.createBgRGBString(((MqttSubscription)subscription).getColor(), this.getIndex() % 2 == 0 ? 0.8 : 0.6) + " -fx-background-radius: 6; ");
                            } else {
                                this.setStyle(null);
                            }
                        } else {
                            this.setStyle(null);
                        }
                    }
                };
                return row;
            }
        });
    }

    private void selectItem() {
        MessageContentProperties item = (MessageContentProperties)this.messageTable.getSelectionModel().getSelectedItem();
        if (item != null) {
            List list = this.store.getMessages();
            for (int i = 0; i < this.store.getMessages().size(); ++i) {
                if (((FormattedMqttMessage)list.get(i)).getId() != item.getId()) continue;
                this.eventBus.publish(new MessageIndexChangeEvent(i + 1, this.store, this));
            }
        }
    }

    public void onMessageIndexChange(MessageIndexChangeEvent event) {
        if (event.getDispatcher() == this) {
            return;
        }
        if (this.store.getMessages().size() > 0) {
            long id = ((FormattedMqttMessage)this.store.getMessages().get(event.getIndex() - 1)).getId();
            for (MessageContentProperties item : this.items) {
                if (item.getId() != id || item.equals(this.messageTable.getSelectionModel().getSelectedItem())) continue;
                this.messageTable.getSelectionModel().select((Object)item);
                break;
            }
        }
    }

    public void init() {
        this.messageTable.setContextMenu(MessageListTableController.createMessageListTableContextMenu(this.messageTable));
        this.messageTable.setItems(this.items);
    }

    public void setItems(ObservableList<MessageContentProperties<FormattedMqttMessage>> items) {
        this.items = items;
    }

    public void setStore(BasicMessageStoreWithSummary<FormattedMqttMessage> store) {
        this.store = store;
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    public static ContextMenu createMessageListTableContextMenu(final TableView<MessageContentProperties<FormattedMqttMessage>> messageTable) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem copyTopicItem = new MenuItem("[Topic] Copy to clipboard");
        copyTopicItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                MessageContentProperties item = (MessageContentProperties)messageTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    UiUtils.copyToClipboard(item.topicProperty().getValue());
                }
            }
        });
        contextMenu.getItems().add((Object)copyTopicItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem copyContentItem = new MenuItem("[Content] Copy to clipboard");
        copyContentItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                MessageContentProperties item = (MessageContentProperties)messageTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    UiUtils.copyToClipboard(item.lastReceivedPayloadProperty().getValue());
                }
            }
        });
        contextMenu.getItems().add((Object)copyContentItem);
        return contextMenu;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

