/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.Main;
import pl.baczkowicz.mqttspy.common.generated.PublicationDetails;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttRuntimeConnectionProperties;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.scripts.MqttScriptManager;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttSubscriptionViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.MqttSpyMainController;
import pl.baczkowicz.mqttspy.ui.controllers.SubscriptionController;
import pl.baczkowicz.mqttspy.ui.events.ShowNewMqttSubscriptionWindowEvent;
import pl.baczkowicz.mqttspy.ui.messagelog.LogReaderTask;
import pl.baczkowicz.mqttspy.ui.utils.ContextMenuUtils;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.ui.BaseViewManager;
import pl.baczkowicz.spy.ui.configuration.BaseConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.UiProperties;
import pl.baczkowicz.spy.ui.controllers.EditConnectionsController;
import pl.baczkowicz.spy.ui.events.AddConnectionTabEvent;
import pl.baczkowicz.spy.ui.events.ConfigurationLoadedEvent;
import pl.baczkowicz.spy.ui.events.ConnectionStatusChangeEvent;
import pl.baczkowicz.spy.ui.events.ConnectionsChangedEvent;
import pl.baczkowicz.spy.ui.events.LoadConfigurationFileEvent;
import pl.baczkowicz.spy.ui.events.NewPerspectiveSelectedEvent;
import pl.baczkowicz.spy.ui.events.ShowMessageLogEvent;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TabStatus;
import pl.baczkowicz.spy.ui.panes.TitledPaneStatus;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class MqttViewManager
extends BaseViewManager {
    private static final Logger logger = LoggerFactory.getLogger(MqttViewManager.class);
    private MqttConnectionViewManager mqttConnectionViewManager;
    private EditConnectionsController editConnectionsController;
    private MqttSpyMainController mqttSpyMainController;

    @Override
    public void init() {
        super.init();
        this.eventBus.subscribe(this, this::loadConfigurationFile, LoadConfigurationFileEvent.class, new SimpleRunLaterExecutor());
        this.eventBus.subscribe(this, this::onNewSelectedPerspective, NewPerspectiveSelectedEvent.class);
        this.eventBus.subscribe(this, this::openMessageLog, ShowMessageLogEvent.class);
        this.eventBus.subscribe(this, MqttViewManager::showNewSubscriptionWindow, ShowNewMqttSubscriptionWindowEvent.class);
    }

    public Scene createMainWindow(Stage primaryStage) throws IOException {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("MqttSpyMainWindow.fxml");
        AnchorPane pane = (AnchorPane)loader.load();
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        double height = Math.min(UiProperties.getApplicationHeight(this.configurationManager.getUiPropertyFile()), primaryScreenBounds.getHeight());
        double width = Math.min(UiProperties.getApplicationWidth(this.configurationManager.getUiPropertyFile()), primaryScreenBounds.getWidth());
        Scene scene = new Scene((Parent)pane, width, height);
        scene.getStylesheets().add((Object)Main.class.getResource("/ui/css/application.css").toExternalForm());
        this.stylesheets = scene.getStylesheets();
        this.mqttSpyMainController = (MqttSpyMainController)loader.getController();
        this.mqttSpyMainController.setEventBus(this.eventBus);
        this.mqttSpyMainController.setConnectionManager(this.mqttConnectionViewManager);
        this.mqttSpyMainController.setStatisticsManager(this.statisticsManager);
        this.mqttSpyMainController.setVersionManager(this.versionManager);
        this.mqttSpyMainController.setConnectionFactory(this.connectionFactory);
        this.mqttSpyMainController.setViewManager(this);
        this.mqttSpyMainController.setConfigurationManager(this.configurationManager);
        this.mqttSpyMainController.updateUiProperties(this.configurationManager.getUiPropertyFile());
        this.mqttConnectionViewManager.setParentStage(this.mqttSpyMainController.getStage());
        primaryStage.setScene(scene);
        primaryStage.setMaximized(UiProperties.getApplicationMaximized(this.configurationManager.getUiPropertyFile()));
        this.mqttSpyMainController.setStage(primaryStage);
        this.mqttSpyMainController.setLastHeight(height);
        this.mqttSpyMainController.setLastWidth(width);
        this.mqttSpyMainController.init();
        primaryStage.getIcons().add((Object)ImageUtils.createIcon(this.configurationManager.getDefaultPropertyFile().getApplicationLogo()).getImage());
        this.setUpKeyHandlers(scene);
        return scene;
    }

    public static void showNewSubscriptionWindow(ShowNewMqttSubscriptionWindowEvent event) {
        MqttConnectionController connectionController = event.getConnectionController();
        if (event.getPreviousStatus().equals((Object)PaneVisibilityStatus.ATTACHED)) {
            if (!connectionController.getNewSubscriptionPaneController().getTitledPane().isExpanded()) {
                connectionController.getNewSubscriptionPaneController().getTitledPane().setExpanded(true);
            }
            connectionController.getNewSubscriptionPaneController().requestFocus();
        } else {
            TitledPaneStatus paneStatus = connectionController.getNewSubscriptionPaneStatus();
            connectionController.setPaneVisiblity(paneStatus, event.getNewStatus());
            if (event.getNewStatus().equals((Object)PaneVisibilityStatus.DETACHED)) {
                connectionController.getNewSubscriptionPaneController().setPreviousStatus(event.getPreviousStatus());
                paneStatus.getParentWhenDetached().setWidth(600.0);
                connectionController.getNewSubscriptionPaneController().requestFocus();
            }
        }
    }

    public void onNewSelectedPerspective(NewPerspectiveSelectedEvent event) {
        this.selectedPerspective = event.getPerspective();
        for (MqttConnectionController connectionController : this.mqttConnectionViewManager.getConnectionControllers()) {
            this.showPerspective(connectionController);
        }
        logger.debug("Selected perspective = " + this.selectedPerspective.toString());
    }

    public void showPerspective(MqttConnectionController connectionController) {
        switch (this.selectedPerspective) {
            case BASIC: {
                connectionController.showPanes(PaneVisibilityStatus.ATTACHED, PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.ATTACHED, PaneVisibilityStatus.ATTACHED);
                break;
            }
            case DETAILED: {
                connectionController.showPanes(PaneVisibilityStatus.ATTACHED, PaneVisibilityStatus.ATTACHED, PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.ATTACHED);
                break;
            }
            case SPY: {
                connectionController.showPanes(PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.ATTACHED);
                break;
            }
            case SUPER_SPY: {
                connectionController.showPanes(PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.ATTACHED);
                break;
            }
            default: {
                connectionController.showPanes(PaneVisibilityStatus.ATTACHED, PaneVisibilityStatus.ATTACHED, PaneVisibilityStatus.NOT_VISIBLE, PaneVisibilityStatus.ATTACHED);
            }
        }
        connectionController.setViewVisibility(MqttViewManager.getDetailedViewStatus(this.selectedPerspective), MqttViewManager.getBasicViewStatus(this.selectedPerspective));
    }

    public void openMessageLog(ShowMessageLogEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select message audit log file to open");
        String extensions = "messages";
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Message audit log file", new String[]{extensions}));
        File selectedFile = fileChooser.showOpenDialog(event.getParent());
        if (selectedFile != null) {
            LogReaderTask readAndProcess = new LogReaderTask(selectedFile, this, this.mqttSpyMainController);
            DialogFactory.createWorkerDialog(readAndProcess);
            new Thread((Runnable)((Object)readAndProcess)).start();
        }
    }

    public void clear() {
        this.mqttConnectionViewManager.disconnectAndCloseAll();
        if (this.editConnectionsController != null) {
            this.initialiseEditConnectionsWindow(this.mqttSpyMainController.getStage().getScene().getWindow());
        }
    }

    public void loadConfigurationFile(LoadConfigurationFileEvent event) {
        logger.info("Loading configuration file from " + event.getFile().getAbsolutePath());
        if (this.configurationManager.loadConfiguration(event.getFile())) {
            this.clear();
            this.eventBus.publish(new ConnectionsChangedEvent());
            this.mqttConnectionViewManager.autoOpenConnections();
        }
        this.eventBus.publish(new ConfigurationLoadedEvent());
    }

    private Tab createConnectionTab(String name, Node content, MqttConnectionController connectionController) {
        Tab tab = new Tab();
        connectionController.setTab(tab);
        tab.setText(name);
        tab.setContent(content);
        return tab;
    }

    public void loadConnectionTab(final MqttRuntimeConnectionProperties connectionProperties) {
        final MqttAsyncConnection connection = this.mqttConnectionViewManager.createConnection(connectionProperties, this.mqttConnectionViewManager.getUiEventQueue());
        connection.setOpening(true);
        connection.setStatisticsManager(this.statisticsManager);
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("ConnectionTab.fxml");
        AnchorPane connectionPane = FxmlUtils.loadAnchorPane(loader);
        final MqttConnectionController connectionController = (MqttConnectionController)loader.getController();
        connectionController.setConnection(connection);
        connectionController.setConnectionManager(this.mqttConnectionViewManager);
        connectionController.setEventBus(this.eventBus);
        connectionController.setStatisticsManager(this.statisticsManager);
        connectionController.setTabStatus(new TabStatus());
        connectionController.getTabStatus().setVisibility(PaneVisibilityStatus.NOT_VISIBLE);
        connectionController.getResizeMessageContentMenu().setSelected(this.configurationManager.getUiPropertyFile().getBooleanProperty("application.panes.message.resize"));
        final Tab connectionTab = this.createConnectionTab(connection.getProperties().getName(), (Node)connectionPane, connectionController);
        final MqttSubscriptionViewManager subscriptionManager = new MqttSubscriptionViewManager(this.eventBus, this.configurationManager, this, this.mqttConnectionViewManager.getUiEventQueue());
        final SubscriptionController subscriptionController = subscriptionManager.createSubscriptionTab(true, connection.getStore(), null, connection, connectionController);
        subscriptionController.setConnectionController(connectionController);
        subscriptionController.setFormatters(this.configurationManager.getFormatters());
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                connectionController.init();
                subscriptionController.init();
                MqttViewManager.this.eventBus.publish(new AddConnectionTabEvent(connectionTab));
                connectionController.getTabStatus().setVisibility(PaneVisibilityStatus.ATTACHED);
                connectionController.getTabStatus().setParent(connectionTab.getTabPane());
                connectionTab.setContextMenu(ContextMenuUtils.createConnectionMenu(connection, MqttViewManager.this.eventBus, connectionController, MqttViewManager.this.mqttConnectionViewManager));
                subscriptionController.getTab().setContextMenu(ContextMenuUtils.createAllSubscriptionsTabContextMenu(connection, MqttViewManager.this.eventBus, subscriptionManager, MqttViewManager.this.configurationManager, subscriptionController));
                MqttViewManager.this.eventBus.subscribe(connectionController, connectionController::onConnectionStatusChanged, ConnectionStatusChangeEvent.class, new SimpleRunLaterExecutor(), connection);
                connection.setOpening(false);
                connection.setOpened(true);
                if (connection.getProperties().isAutoConnect()) {
                    MqttViewManager.this.mqttConnectionViewManager.connectToBroker(connection);
                } else {
                    connection.setConnectionStatus(ConnectionStatus.NOT_CONNECTED);
                }
                connectionController.getSubscriptionTabs().getTabs().add((Object)subscriptionController.getTab());
                subscriptionController.getTab().setDisable(true);
                MqttViewManager.this.mqttConnectionViewManager.getConnectionControllersMapping().put(connection, connectionController);
                MqttViewManager.this.mqttConnectionViewManager.getConnectionTabs().put(connection, connectionTab);
                MqttViewManager.this.mqttConnectionViewManager.getSubscriptionManagers().put(connectionController, subscriptionManager);
                MqttViewManager.populateConnectionPanes(connectionProperties.getConfiguredProperties(), connectionController);
                MqttViewManager.this.showPerspective(connectionController);
            }
        });
    }

    public static void populateConnectionPanes(UserInterfaceMqttConnectionDetails connectionDetails, MqttConnectionController connectionController) {
        for (PublicationDetails publicationDetails : connectionDetails.getPublication()) {
            connectionController.getNewPublicationPaneController().recordPublicationTopic(publicationDetails.getTopic());
        }
        for (TabbedSubscriptionDetails subscriptionDetails : connectionDetails.getSubscription()) {
            if (subscriptionDetails.isCreateTab()) {
                connectionController.getNewSubscriptionPaneController().subscribe(subscriptionDetails, connectionDetails.isAutoSubscribe());
            }
            connectionController.getNewSubscriptionPaneController().recordSubscriptionTopic(subscriptionDetails.getTopic());
        }
    }

    public void loadMessageLogTab(MqttSpyMainController mainController, String name, final List<BaseMqttMessage> list) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("ConnectionTab.fxml");
        AnchorPane connectionPane = FxmlUtils.loadAnchorPane(loader);
        final MqttConnectionController connectionController = (MqttConnectionController)loader.getController();
        connectionController.setConnectionManager(this.mqttConnectionViewManager);
        connectionController.setEventBus(this.eventBus);
        connectionController.setStatisticsManager(this.statisticsManager);
        connectionController.setReplayMode(true);
        connectionController.setTabStatus(new TabStatus());
        connectionController.getTabStatus().setVisibility(PaneVisibilityStatus.NOT_VISIBLE);
        connectionController.getResizeMessageContentMenu().setSelected(this.configurationManager.getUiPropertyFile().getBooleanProperty("application.panes.message.resize"));
        final Tab replayTab = this.createConnectionTab(name, (Node)connectionPane, connectionController);
        final MqttSubscriptionViewManager subscriptionManager = new MqttSubscriptionViewManager(this.eventBus, this.configurationManager, this, this.mqttConnectionViewManager.getUiEventQueue());
        final ManagedMessageStoreWithFiltering<FormattedMqttMessage> store = new ManagedMessageStoreWithFiltering<FormattedMqttMessage>(name, 0, list.size(), list.size(), this.mqttConnectionViewManager.getUiEventQueue(), new FormattingManager(new MqttScriptManager(null, null, null)), UiProperties.getSummaryMaxPayloadLength(this.configurationManager.getUiPropertyFile()));
        final SubscriptionController subscriptionController = subscriptionManager.createSubscriptionTab(true, store, null, null, connectionController);
        subscriptionController.setConnectionController(connectionController);
        subscriptionController.setFormatters(this.configurationManager.getFormatters());
        subscriptionController.setReplayMode(true);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                connectionController.init();
                subscriptionController.init();
                MqttViewManager.this.eventBus.publish(new AddConnectionTabEvent(replayTab));
                replayTab.setContextMenu(ContextMenuUtils.createMessageLogMenu(replayTab, connectionController, MqttViewManager.this.mqttConnectionViewManager));
                connectionController.getSubscriptionTabs().getTabs().clear();
                connectionController.getSubscriptionTabs().getTabs().add((Object)subscriptionController.getTab());
                connectionController.getTabStatus().setVisibility(PaneVisibilityStatus.ATTACHED);
                connectionController.getTabStatus().setParent(replayTab.getTabPane());
                MqttViewManager.this.mqttConnectionViewManager.getOfflineConnectionControllers().add(connectionController);
                MqttViewManager.this.mqttConnectionViewManager.getSubscriptionManagers().put(connectionController, subscriptionManager);
                connectionController.showReplayMode();
                for (BaseMqttMessage mqttMessage : list) {
                    store.messageReceived(new FormattedMqttMessage(mqttMessage, null));
                }
                replayTab.getTabPane().getSelectionModel().select((Object)replayTab);
            }
        });
    }

    @Override
    public void loadDefaultConfigurationFile() {
        File defaultConfigurationFile = BaseConfigurationManager.getDefaultConfigurationFileObject();
        logger.info("Default configuration file present (" + defaultConfigurationFile.getAbsolutePath() + ") = " + defaultConfigurationFile.exists());
        if (defaultConfigurationFile.exists()) {
            this.eventBus.publish(new LoadConfigurationFileEvent(defaultConfigurationFile));
        } else {
            this.configurationManager.initialiseConfiguration();
        }
    }

    public void setConnectionManager(MqttConnectionViewManager connectionManager) {
        this.mqttConnectionViewManager = connectionManager;
    }

    protected void setUpKeyHandlers(Scene scene) {
        KeyCodeCombination newConnection = new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
        KeyCodeCombination editConnections = new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
        scene.addEventHandler(KeyEvent.KEY_RELEASED, new EventHandler((KeyCombination)newConnection, (KeyCombination)editConnections){
            final /* synthetic */ KeyCombination val$newConnection;
            final /* synthetic */ KeyCombination val$editConnections;
            {
                this.val$newConnection = keyCombination;
                this.val$editConnections = keyCombination2;
            }

            public void handle(Event event) {
                if (this.val$newConnection.match((KeyEvent)event)) {
                    MqttViewManager.this.mqttSpyMainController.createNewConnection();
                } else if (this.val$editConnections.match((KeyEvent)event)) {
                    MqttViewManager.this.mqttSpyMainController.editConnections();
                } else if (BaseViewManager.newSubscription.match((KeyEvent)event)) {
                    Tab selectedTab = (Tab)MqttViewManager.this.mqttSpyMainController.getConnectionTabs().getSelectionModel().getSelectedItem();
                    MqttConnectionController controller = (MqttConnectionController)MqttViewManager.this.mqttConnectionViewManager.getControllerForTab(selectedTab);
                    if (controller != null) {
                        MqttViewManager.this.eventBus.publish(new ShowNewMqttSubscriptionWindowEvent(controller, PaneVisibilityStatus.DETACHED, controller.getNewSubscriptionPaneStatus().getVisibility()));
                    }
                } else if (BaseViewManager.newPublication.match((KeyEvent)event)) {
                    Tab selectedTab = (Tab)MqttViewManager.this.mqttSpyMainController.getConnectionTabs().getSelectionModel().getSelectedItem();
                    MqttConnectionController controller = (MqttConnectionController)MqttViewManager.this.mqttConnectionViewManager.getControllerForTab(selectedTab);
                    if (controller != null) {
                        controller.getNewPublicationPaneController().publish();
                    }
                }
            }
        });
        this.mqttSpyMainController.getNewConnectionMenu().setAccelerator((KeyCombination)newConnection);
        this.mqttSpyMainController.getEditConnectionsMenu().setAccelerator((KeyCombination)editConnections);
        this.mqttSpyMainController.getNewSubuscriptionMenu().setAccelerator(newSubscription);
    }
}

