/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.scripts;

import java.util.HashMap;
import java.util.concurrent.Executor;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.audit.MqttAuditReplay;
import pl.baczkowicz.mqttspy.connectivity.IMqttConnection;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogIO;
import pl.baczkowicz.mqttspy.scripts.MqttScriptIO;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.scripts.BaseScriptManager;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.scripts.ScriptRunner;

public class MqttScriptManager
extends BaseScriptManager {
    private IMqttConnection connection;

    public MqttScriptManager(IKBus eventBus, Executor executor, IMqttConnection connection) {
        super(eventBus, executor);
        this.setConnection(connection);
    }

    public static void populateEngineVariables(Script script, IMqttConnection connection, IKBus eventBus, Executor executor) throws SpyException {
        MqttScriptIO scriptIO = new MqttScriptIO(connection, eventBus, script, executor);
        HashMap<String, Object> scriptVariables = new HashMap<String, Object>();
        scriptVariables.put("mqttspy", scriptIO);
        scriptVariables.put("spy", scriptIO);
        scriptVariables.put("mqtt", scriptIO);
        scriptVariables.put("logger", LoggerFactory.getLogger(ScriptRunner.class));
        MqttMessageLogIO mqttMessageLog = new MqttMessageLogIO();
        scriptVariables.put("messageLog", mqttMessageLog);
        MqttAuditReplay mqttAuditReplay = new MqttAuditReplay();
        scriptVariables.put("auditReplay", mqttAuditReplay);
        script.addTask(mqttMessageLog);
        script.addTask(mqttAuditReplay);
        MqttScriptManager.putJavaVariablesIntoEngine(script.getScriptEngine(), scriptVariables);
    }

    @Override
    public void populateEngineVariables(Script script) throws SpyException {
        MqttScriptManager.populateEngineVariables(script, this.connection, this.eventBus, this.executor);
    }

    public IMqttConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IMqttConnection connection) {
        this.connection = connection;
    }
}

