/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.scripts;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.IMqttConnection;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.scripts.IMqttScriptIO;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.scripts.ScriptIO;

public class MqttScriptIO
extends ScriptIO
implements IMqttScriptIO {
    private static final Logger logger = LoggerFactory.getLogger(MqttScriptIO.class);
    private final IMqttConnection connection;

    public MqttScriptIO(IMqttConnection connection, IKBus eventBus, Script script, Executor executor) {
        super(script, executor);
        this.connection = connection;
    }

    @Override
    public void publish(String publicationTopic, String data) {
        this.publish(publicationTopic, data, 0, false);
    }

    @Override
    public void publish(String publicationTopic, byte[] data, int qos, boolean retained) {
        this.touch();
        logger.debug("[JS {}] Publishing message to {} with payload size = {}, qos = {}, retained = {}", this.scriptName, publicationTopic, data.length, qos, retained);
        boolean published = this.connection.publish(publicationTopic, data, qos, retained);
        if (published) {
            this.updatePublished();
        }
    }

    @Override
    public void publish(String publicationTopic, String data, int qos, boolean retained) {
        this.touch();
        logger.debug("[JS {}] Publishing message to {} with payload = {}, qos = {}, retained = {}", this.scriptName, publicationTopic, data, qos, retained);
        boolean published = this.connection.publish(publicationTopic, data, qos, retained);
        if (published) {
            this.updatePublished();
        }
    }

    @Override
    public boolean subscribe(String topic, int qos) {
        BaseMqttSubscription subscription = this.connection.getMqttSubscriptionForTopic(topic);
        if (subscription == null) {
            subscription = new BaseMqttSubscription(topic, qos, 1, 1000);
        }
        return this.connection.subscribe(subscription);
    }

    @Override
    public boolean unsubscribe(String topic) {
        BaseMqttSubscription subscription = this.connection.getMqttSubscriptionForTopic(topic);
        if (subscription != null) {
            this.connection.removeSubscription(subscription);
            return this.connection.unsubscribe(topic);
        }
        return false;
    }

    @Override
    public List<FormattedMqttMessage> getMessages(String subscriptionTopic) {
        BaseMqttSubscription subscription = this.connection.getMqttSubscriptionForTopic(subscriptionTopic);
        if (subscription != null) {
            return subscription.getStore().getMessages();
        }
        return new ArrayList<FormattedMqttMessage>();
    }
}

