/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.messages;

import java.util.Date;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttConnection;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class FormattedMqttMessage
extends BaseMqttMessage {
    private List<String> matchingSubscriptionTopics;
    private final BaseMqttConnection connection;

    public FormattedMqttMessage(long id, String topic, MqttMessage message, BaseMqttConnection connection) {
        super(id, topic, message);
        this.connection = connection;
        this.setFormattedPayload(ConversionUtils.arrayToString(message.getPayload()));
    }

    public FormattedMqttMessage(long id, String topic, MqttMessage message, Date date, BaseMqttConnection connection) {
        super(id, topic, message, date);
        this.connection = connection;
        this.setFormattedPayload(ConversionUtils.arrayToString(message.getPayload()));
    }

    public FormattedMqttMessage(FormattedMqttMessage message) {
        this(message.getId(), message.getTopic(), FormattedMqttMessage.copyMqttMessage(message.getRawMessage()), message.getConnection());
        this.setRawPayload((byte[])message.getRawPayload().clone());
        this.setFormattedPayload(message.getFormattedPayload());
        this.setLastUsedFormatter(message.getLastUsedFormatter());
        this.setSubscription(message.getSubscription());
        this.setMatchingSubscriptionTopics(message.getMatchingSubscriptionTopics());
    }

    public FormattedMqttMessage(BaseMqttMessage message, BaseMqttConnection connection) {
        this(message.getId(), message.getTopic(), message.getRawMessage(), message.getDate(), connection);
        this.setFormattedPayload(message.getPayload());
    }

    public List<String> getMatchingSubscriptionTopics() {
        return this.matchingSubscriptionTopics;
    }

    public void setMatchingSubscriptionTopics(List<String> subscriptions) {
        this.matchingSubscriptionTopics = subscriptions;
    }

    public BaseMqttConnection getConnection() {
        return this.connection;
    }
}

