/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.logger;

import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.MessageLog;
import pl.baczkowicz.mqttspy.common.generated.MessageLogEnum;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;

public class SimpleMqttMessageLogComposer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMqttMessageLogComposer.class);
    private static final Pattern XML_CHARS = Pattern.compile("[&<>]");

    public static String createReceivedMessageLog(FormattedMqttMessage message, MessageLog messageLogOptions) {
        StringBuffer logMessage = new StringBuffer();
        logMessage.append("<MqttMessage");
        SimpleMqttMessageLogComposer.appendAttribute(logMessage, "id", String.valueOf(message.getId()));
        SimpleMqttMessageLogComposer.appendAttribute(logMessage, "timestamp", String.valueOf(message.getDate().getTime()));
        SimpleMqttMessageLogComposer.appendAttribute(logMessage, "topic", message.getTopic());
        if (messageLogOptions.isLogQos().booleanValue()) {
            SimpleMqttMessageLogComposer.appendAttribute(logMessage, "qos", String.valueOf(message.getQoS()));
        }
        if (messageLogOptions.isLogRetained().booleanValue()) {
            SimpleMqttMessageLogComposer.appendAttribute(logMessage, "retained", String.valueOf(message.isRetained()));
        }
        if (messageLogOptions.isLogConnection().booleanValue()) {
            SimpleMqttMessageLogComposer.appendAttribute(logMessage, "connection", message.getConnection().getMqttConnectionDetails().getName());
        }
        if (messageLogOptions.isLogSubscription().booleanValue() && message.getMatchingSubscriptionTopics() != null && message.getMatchingSubscriptionTopics().size() > 0) {
            SimpleMqttMessageLogComposer.appendAttribute(logMessage, "subscription", message.getMatchingSubscriptionTopics().get(0));
        }
        SimpleMqttMessageLogComposer.populatePayload(logMessage, message, messageLogOptions);
        logMessage.append("</MqttMessage>");
        return logMessage.toString();
    }

    private static void populatePayload(StringBuffer logMessage, FormattedMqttMessage message, MessageLog messageLogOptions) {
        boolean encoded = MessageLogEnum.XML_WITH_ENCODED_PAYLOAD.equals((Object)messageLogOptions.getValue());
        String payload = new String(message.getPayload());
        if (!encoded && (payload.contains("\n") || payload.contains("\r") || payload.contains("\r\n"))) {
            logger.debug("Message on topic {} contains a new line separator, so it needs to be encoded", (Object)message.getTopic());
            encoded = true;
        }
        if (encoded) {
            SimpleMqttMessageLogComposer.appendAttribute(logMessage, "encoded", "true");
        }
        logMessage.append(">");
        if (encoded) {
            SimpleMqttMessageLogComposer.appendValue(logMessage, Base64.encodeBase64String(message.getRawMessage().getPayload()));
        } else {
            boolean useCData = XML_CHARS.matcher(payload).find();
            if (useCData) {
                SimpleMqttMessageLogComposer.appendValue(logMessage, "<![CDATA[" + payload + "]]>");
            } else {
                SimpleMqttMessageLogComposer.appendValue(logMessage, payload);
            }
        }
    }

    public static void appendAttribute(StringBuffer logMessage, String attributeName, String attributeValue) {
        logMessage.append(" " + attributeName + "=\"" + attributeValue + "\"");
    }

    public static void appendValue(StringBuffer logMessage, String value) {
        logMessage.append(value);
    }
}

