/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.logger;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.logger.IMqttMessageLogIO;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogParserUtils;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class MqttMessageLogIO
implements IMqttMessageLogIO,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessageLogIO.class);
    private List<BaseMqttMessage> messages;
    private long replayTime;
    private long lastUpdated;
    private boolean running = false;
    private double speed = 1.0;

    @Override
    public int readFromFile(String logLocation) {
        try {
            this.messages = MqttMessageLogParserUtils.readAndConvertMessageLog(new File(logLocation));
            return this.messages.size();
        }
        catch (Exception e) {
            logger.error("Cannot read message log at " + logLocation, e);
            return 0;
        }
    }

    @Override
    public void start() {
        if (this.messages != null) {
            this.replayTime = this.messages.get(0).getDate().getTime();
            this.lastUpdated = TimeUtils.getMonotonicTime();
            this.running = true;
            new Thread(this).start();
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void setSpeed(double newSpeed) {
        if (newSpeed > 1.0) {
            if (this.speed <= 1.0) {
                logger.info("Warp enabled. Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
            } else {
                logger.info("Warp still on. Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
            }
        } else if (newSpeed == 1.0) {
            logger.info("Back to normal. Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
        } else {
            logger.info("Tea time! Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
        }
        this.speed = newSpeed;
    }

    @Override
    public boolean isReadyToPublish(int messageIndex) {
        return this.messages != null && this.messages.size() > messageIndex && this.replayTime > this.messages.get(messageIndex).getDate().getTime();
    }

    @Override
    public BaseMqttMessage getMessage(int messageIndex) {
        if (this.messages != null && this.messages.size() > messageIndex) {
            return this.messages.get(messageIndex);
        }
        return null;
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Message Audit Log IO");
        while (this.running) {
            long now = TimeUtils.getMonotonicTime();
            if (now > this.lastUpdated) {
                long sinceLastUpdated = now - this.lastUpdated;
                double increase = (double)sinceLastUpdated * this.speed;
                this.replayTime += (long)increase;
                this.lastUpdated = now;
            }
            if (!ThreadingUtils.sleep(10L)) continue;
            break;
        }
        this.stop();
        ThreadingUtils.logThreadEnding();
    }

    @Override
    public int getMessageCount() {
        if (this.messages == null) {
            return 0;
        }
        return this.messages.size();
    }
}

