/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity.topicmatching;

import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.topicmatching.MapBasedSubscriptionStore;

public class TopicMatcher {
    private static final Logger logger = LoggerFactory.getLogger(TopicMatcher.class);
    private SubscriptionsStore subscriptionsStore;
    private Set<String> topics = new HashSet<String>();

    public TopicMatcher() {
        this.subscriptionsStore = new SubscriptionsStore();
        this.subscriptionsStore.init(new MapBasedSubscriptionStore());
    }

    public List<String> getMatchingSubscriptions(String topic) {
        List<Subscription> matchingSubscriptions = this.subscriptionsStore.matches(topic);
        ArrayList<String> matchingSubscriptionTopics = new ArrayList<String>();
        for (Subscription matchingSubscription : matchingSubscriptions) {
            matchingSubscriptionTopics.add(matchingSubscription.getTopicFilter());
        }
        return matchingSubscriptionTopics;
    }

    public void addSubscriptionToStore(String topic, String clientId) {
        ISessionsStore.ClientTopicCouple subscription = new ISessionsStore.ClientTopicCouple(clientId, topic);
        if (!this.topics.contains(topic)) {
            logger.debug("Added subscription " + topic + " (" + clientId + ") to store");
            this.subscriptionsStore.add(subscription);
            this.topics.add(topic);
        }
    }

    public void removeSubscriptionFromStore(String topic, String clientId) {
        this.subscriptionsStore.removeSubscription(topic, clientId);
        this.topics.remove(topic);
    }
}

