/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity.handlers;

import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class MqttMessageHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessageHandler.class);
    private final Queue<FormattedMqttMessage> queue;
    private MqttAsyncConnection connection;

    public MqttMessageHandler(MqttAsyncConnection connection, Queue<FormattedMqttMessage> queue) {
        this.queue = queue;
        this.connection = connection;
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Message Handler for " + this.connection.getName());
        logger.debug("Starting processing thread for connection " + this.connection.getProperties().getName());
        try {
            while (true) {
                if (this.queue.size() > 0) {
                    FormattedMqttMessage content = this.queue.remove();
                    this.connection.messageReceived(content);
                    Thread.sleep(1L);
                    continue;
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            ThreadingUtils.logThreadEnding();
            return;
        }
    }

    public int getMessagesToProcess() {
        return this.queue.size();
    }
}

