/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity.handlers;

import javafx.application.Platform;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttEventHandler;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttConnectionAttemptFailureEvent;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttDisconnectionAttemptSuccessEvent;

public class MqttDisconnectionResultHandler
implements IMqttActionListener {
    private static final Logger logger = LoggerFactory.getLogger(MqttDisconnectionResultHandler.class);

    @Override
    public void onSuccess(IMqttToken asyncActionToken) {
        MqttAsyncConnection connection = (MqttAsyncConnection)asyncActionToken.getUserContext();
        try {
            logger.info(connection.getProperties().getName() + " disconnected");
            Platform.runLater((Runnable)new MqttEventHandler(new MqttDisconnectionAttemptSuccessEvent(connection)));
        }
        catch (IllegalStateException e) {
            logger.debug("Application about to close");
        }
    }

    @Override
    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
        MqttAsyncConnection connection = (MqttAsyncConnection)asyncActionToken.getUserContext();
        Platform.runLater((Runnable)new MqttEventHandler(new MqttConnectionAttemptFailureEvent(connection, exception)));
        logger.warn("Disconnecting from " + connection.getProperties().getName() + " failed");
    }
}

