/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.ProtocolVersionEnum;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.MqttConfigurationManager;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.utils.MqttStylingUtils;
import pl.baczkowicz.mqttspy.utils.ConnectionUtils;
import pl.baczkowicz.mqttspy.utils.MqttUtils;
import pl.baczkowicz.spy.common.generated.ConnectionGroupReference;
import pl.baczkowicz.spy.common.generated.ConnectionReference;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.ConfigurationException;
import pl.baczkowicz.spy.ui.configuration.ConfiguredConnectionGroupDetails;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.connections.IConnectionFactory;
import pl.baczkowicz.spy.ui.controllers.ControlPanelController;
import pl.baczkowicz.spy.ui.controllers.EditConnectionsController;
import pl.baczkowicz.spy.ui.events.CreateNewConnectionEvent;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;
import pl.baczkowicz.spy.ui.properties.ConnectionListItemProperties;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class MqttConnectionFactory
implements IConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(MqttConnectionFactory.class);
    private EditMqttConnectionController editConnectionPaneController;
    private MqttConnectionViewManager connectionManager;
    private IKBus eventBus;
    private IConfigurationManager configurationManager;
    private AnchorPane editConnectionPane;

    public static String getIconNameForProtocol(String protocol) {
        return protocol.toLowerCase() + "-icon";
    }

    @Override
    public void populateProtocolCell(TableCell<ConnectionListItemProperties, String> cell, String item) {
        if (item.contains("MQTT")) {
            cell.setGraphic((Node)ImageUtils.createIcon(MqttConnectionFactory.getIconNameForProtocol("MQTT"), 18));
            cell.setText(item.replace("Default", ""));
        } else {
            cell.setText(item);
        }
    }

    @Override
    public ModifiableConnection newConnection(String protocol) {
        return MqttConnectionFactory.newConnection();
    }

    public static ModifiableConnection newConnection() {
        UserInterfaceMqttConnectionDetails baseConnection = new UserInterfaceMqttConnectionDetails();
        baseConnection.getServerURI().add("127.0.0.1");
        baseConnection.setClientID(MqttUtils.generateClientIdWithTimestamp(System.getProperty("user.name").replaceAll("[^A-Za-z0-9]", ""), ProtocolVersionEnum.MQTT_DEFAULT));
        baseConnection.setName(ConnectionUtils.composeConnectionName(baseConnection.getClientID(), baseConnection.getServerURI()));
        baseConnection.setAutoConnect(true);
        ConfiguredMqttConnectionDetails connectionDetails = new ConfiguredMqttConnectionDetails(true, true, baseConnection);
        connectionDetails.setID(MqttConfigurationManager.generateConnectionId());
        return connectionDetails;
    }

    @Override
    public ModifiableConnection duplicateConnection(ModifiableConnection copyFrom) {
        if (copyFrom instanceof UserInterfaceMqttConnectionDetails) {
            ConfiguredMqttConnectionDetails connectionDetails = new ConfiguredMqttConnectionDetails(true, true, (UserInterfaceMqttConnectionDetails)((Object)copyFrom));
            connectionDetails.setID(MqttConfigurationManager.generateConnectionId());
            return connectionDetails;
        }
        return null;
    }

    @Override
    public Collection<AnchorPane> loadControllers(Object parent) {
        ArrayList<AnchorPane> items = new ArrayList<AnchorPane>();
        items.add(this.loadController(parent));
        return items;
    }

    @Override
    public Collection<MenuItem> createMenuItems() {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.createMenuItemForProtocol("MQTT"));
        return items;
    }

    public MenuItem createMenuItemForProtocol(final String protocol) {
        MenuItem newConnection = new MenuItem("Create new " + protocol + " connection");
        newConnection.setGraphic((Node)ImageUtils.createIcon(MqttConnectionFactory.getIconNameForProtocol(protocol), 18));
        newConnection.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MqttConnectionFactory.this.eventBus.publish(new CreateNewConnectionEvent(protocol));
            }
        });
        return newConnection;
    }

    @Override
    public ConnectionListItemProperties createConnectionListItemProperties(ModifiableConnection connection) {
        ConnectionListItemProperties properties = null;
        if (connection instanceof ConfiguredMqttConnectionDetails) {
            ConfiguredMqttConnectionDetails mqttConnection = (ConfiguredMqttConnectionDetails)connection;
            ProtocolVersionEnum protocol = mqttConnection.getProtocol();
            properties = new ConnectionListItemProperties(connection.getName(), protocol == null ? ProtocolVersionEnum.MQTT_DEFAULT.value() : protocol.value(), mqttConnection.getClientID() + "@" + ConnectionUtils.serverURIsToString(mqttConnection.getServerURI()), mqttConnection.getSSL() != null, mqttConnection.getUserAuthentication() != null);
        }
        return properties;
    }

    @Override
    public void findConnections(ConfiguredConnectionGroupDetails parentGroup, List<ModifiableConnection> connections) {
        for (ConnectionGroupReference connectionGroupReference : parentGroup.getSubgroups()) {
            ConfiguredConnectionGroupDetails groupDetails = (ConfiguredConnectionGroupDetails)connectionGroupReference.getReference();
            this.findConnections(groupDetails, connections);
        }
        for (ConnectionReference connectionReference : parentGroup.getConnections()) {
            ModifiableConnection connectionDetails = (ModifiableConnection)connectionReference.getReference();
            connections.add(connectionDetails);
        }
    }

    public AnchorPane loadController(Object parent) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("EditMqttConnectionPane.fxml");
        this.editConnectionPane = FxmlUtils.loadAnchorPane(loader);
        this.editConnectionPaneController = (EditMqttConnectionController)((Object)loader.getController());
        this.editConnectionPaneController.setConfigurationManager(this.configurationManager);
        this.editConnectionPaneController.setEventBus(this.eventBus);
        this.editConnectionPaneController.setConnectionManager(this.connectionManager);
        this.editConnectionPaneController.setEditConnectionsController((EditConnectionsController)parent);
        this.editConnectionPaneController.init();
        return this.editConnectionPane;
    }

    @Override
    public void editConnection(ModifiableConnection connection) {
        if (connection instanceof ConfiguredMqttConnectionDetails) {
            this.editConnectionPaneController.editConnection((ConfiguredMqttConnectionDetails)connection);
        }
    }

    @Override
    public void openConnection(ModifiableConnection connection) {
        if (connection instanceof ConfiguredMqttConnectionDetails) {
            this.editConnectionPaneController.openConnection((ConfiguredMqttConnectionDetails)connection);
        }
    }

    @Override
    public void setRecordModifications(boolean record) {
        this.editConnectionPaneController.setRecordModifications(record);
    }

    @Override
    public void setPerspective(SpyPerspective perspective) {
        this.editConnectionPaneController.setPerspective(perspective);
    }

    @Override
    public void setEmptyConnectionListMode(boolean empty) {
        this.editConnectionPaneController.setEmptyConnectionListMode(empty);
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setConnectionManager(MqttConnectionViewManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void setVisible(boolean groupSelected) {
        this.editConnectionPane.setVisible(!groupSelected);
    }

    @Override
    public Button createConnectionButton(ModifiableConnection connectionDetails) {
        if (connectionDetails instanceof UserInterfaceMqttConnectionDetails) {
            return MqttConnectionFactory.createMqttConnectionButton(connectionDetails, this.connectionManager);
        }
        return null;
    }

    private static Button createMqttConnectionButton(final ModifiableConnection connectionDetails, final MqttConnectionViewManager connectionManager) {
        MqttAsyncConnection connection = null;
        for (MqttAsyncConnection openedConnection : connectionManager.getMqttConnections()) {
            if (!connectionDetails.getID().equals(openedConnection.getId())) continue;
            connection = openedConnection;
            break;
        }
        Button connectionButton = new Button();
        connectionButton.setFocusTraversable(false);
        String connectionName = connectionDetails.getName();
        if (connection != null) {
            logger.trace("Button for " + connectionName + " " + (Object)((Object)connection.getConnectionStatus()) + "/" + connection.isOpening() + "/" + connection.isOpened());
        }
        if (connection == null || !connection.isOpened() && !connection.isOpening()) {
            String buttonText = "Open " + connectionName;
            connectionButton.getStyleClass().add((Object)MqttStylingUtils.getStyleForMqttConnectionStatus(null));
            connectionButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    try {
                        connectionManager.openConnection(connectionDetails);
                        event.consume();
                    }
                    catch (ConfigurationException e) {
                        logger.error("Cannot open connection", e);
                    }
                }
            });
            connectionButton.setText(buttonText);
        } else if (connection.isOpening()) {
            MqttConnectionFactory.showPending("Opening", null, connectionButton, connectionName, MqttConnectionViewManager.createNextAction(null, connection, connectionManager));
        } else if (connection.getConnectionStatus() == ConnectionStatus.CONNECTING) {
            MqttConnectionFactory.showPending("Connecting to", connection.getConnectionStatus(), connectionButton, connectionName, MqttConnectionViewManager.createNextAction(connection.getConnectionStatus(), connection, connectionManager));
        } else if (connection.getConnectionStatus() != null) {
            String buttonText = ControlPanelController.nextActionTitle.get((Object)connection.getConnectionStatus()) + " " + connectionName;
            connectionButton.getStyleClass().add((Object)MqttStylingUtils.getStyleForMqttConnectionStatus(connection.getConnectionStatus()));
            connectionButton.setOnAction(MqttConnectionViewManager.createNextAction(connection.getConnectionStatus(), connection, connectionManager));
            connectionButton.setGraphic(null);
            connectionButton.setText(buttonText);
        }
        return connectionButton;
    }

    public static void showPending(String statusText, ConnectionStatus status, Button connectionButton, String connectionName, EventHandler<ActionEvent> action) {
        connectionButton.getStyleClass().add((Object)MqttStylingUtils.getStyleForMqttConnectionStatus(status));
        connectionButton.setOnAction(action);
        HBox buttonBox = new HBox();
        ProgressIndicator buttonProgress = new ProgressIndicator();
        buttonProgress.setMaxSize(15.0, 15.0);
        buttonBox.getChildren().add((Object)buttonProgress);
        buttonBox.getChildren().add((Object)new Label(" " + statusText + " " + connectionName));
        connectionButton.setGraphic((Node)buttonBox);
        connectionButton.setText(null);
    }
}

