/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import pl.baczkowicz.mqttspy.common.generated.MqttConnectionDetails;
import pl.baczkowicz.mqttspy.common.generated.ProtocolVersionEnum;
import pl.baczkowicz.mqttspy.utils.MqttConfigurationUtils;
import pl.baczkowicz.spy.common.generated.Property;
import pl.baczkowicz.spy.common.generated.SecureSocketModeEnum;
import pl.baczkowicz.spy.exceptions.ConfigurationException;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.security.SecureSocketFactoryBuilder;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class MqttConnectionDetailsWithOptions
extends MqttConnectionDetails {
    private static final long serialVersionUID = 5693589380291267334L;
    private final String id;
    private MqttConnectOptions options;

    public MqttConnectionDetailsWithOptions(String id, MqttConnectionDetails details) throws ConfigurationException {
        this.id = id;
        this.setProtocol(details.getProtocol());
        this.setName(details.getName());
        this.setClientID(details.getClientID());
        this.getServerURI().addAll(details.getServerURI());
        this.setConnectionTimeout(details.getConnectionTimeout());
        this.setKeepAliveInterval(details.getKeepAliveInterval());
        this.setCleanSession(details.isCleanSession());
        this.setLastWillAndTestament(details.getLastWillAndTestament());
        this.setUserCredentials(details.getUserCredentials());
        this.setReconnectionSettings(details.getReconnectionSettings());
        this.setSSL(details.getSSL());
        boolean sslEnabled = details.getSSL() != null && details.getSSL().getMode() != null && !details.getSSL().getMode().equals((Object)SecureSocketModeEnum.DISABLED);
        this.setWebSocket(details.isWebSocket());
        MqttConfigurationUtils.completeServerURIs(this, sslEnabled, Boolean.TRUE.equals(this.isWebSocket()));
        MqttConfigurationUtils.populateConnectionDefaults(this);
        try {
            this.populateMqttConnectOptions();
        }
        catch (IllegalArgumentException | SpyException e) {
            throw new ConfigurationException("Invalid configuration parameters", e);
        }
    }

    private void populateMqttConnectOptions() throws SpyException {
        this.options = new MqttConnectOptions();
        if (ProtocolVersionEnum.MQTT_3_1_1.equals((Object)this.getProtocol())) {
            this.options.setMqttVersion(4);
        } else if (ProtocolVersionEnum.MQTT_3_1.equals((Object)this.getProtocol())) {
            this.options.setMqttVersion(3);
        } else {
            this.options.setMqttVersion(0);
        }
        if (this.getServerURI().size() > 1) {
            this.options.setServerURIs(this.getServerURI().toArray(new String[this.getServerURI().size()]));
        }
        this.options.setCleanSession(this.isCleanSession());
        this.options.setConnectionTimeout(this.getConnectionTimeout());
        this.options.setKeepAliveInterval(this.getKeepAliveInterval());
        if (this.getUserCredentials() != null) {
            this.options.setUserName(this.getUserCredentials().getUsername());
            this.options.setPassword(ConversionUtils.base64ToString(this.getUserCredentials().getPassword()).toCharArray());
        }
        if (this.getLastWillAndTestament() != null) {
            this.options.setWill(this.getLastWillAndTestament().getTopic(), Base64.decodeBase64(this.getLastWillAndTestament().getValue()), (int)this.getLastWillAndTestament().getQos(), (boolean)this.getLastWillAndTestament().isRetained());
        }
        if (this.getSSL() != null) {
            if (SecureSocketModeEnum.PROPERTIES.equals((Object)this.getSSL().getMode())) {
                Properties props = new Properties();
                for (Property prop : this.getSSL().getProperty()) {
                    props.put(prop.getName(), prop.getValue());
                }
                this.options.setSSLProperties(props);
            } else if (SecureSocketModeEnum.BASIC.equals((Object)this.getSSL().getMode())) {
                this.options.setSocketFactory(SecureSocketFactoryBuilder.getSocketFactory(this.getSSL().getProtocol()));
            } else if (SecureSocketModeEnum.SERVER_ONLY.equals((Object)this.getSSL().getMode())) {
                this.options.setSocketFactory(SecureSocketFactoryBuilder.getSocketFactory(this.getSSL().getProtocol(), this.getSSL().getCertificateAuthorityFile()));
            } else if (SecureSocketModeEnum.SERVER_KEYSTORE.equals((Object)this.getSSL().getMode())) {
                this.options.setSocketFactory(SecureSocketFactoryBuilder.getSocketFactory(this.getSSL().getProtocol(), this.getSSL().getServerKeyStoreFile(), this.getSSL().getServerKeyStorePassword()));
            } else if (SecureSocketModeEnum.SERVER_AND_CLIENT.equals((Object)this.getSSL().getMode())) {
                this.options.setSocketFactory(SecureSocketFactoryBuilder.getSocketFactory(this.getSSL().getProtocol(), this.getSSL().getCertificateAuthorityFile(), this.getSSL().getClientCertificateFile(), this.getSSL().getClientKeyFile(), this.getSSL().getClientKeyPassword(), Boolean.TRUE.equals(this.getSSL().isClientKeyPEM())));
            } else if (SecureSocketModeEnum.SERVER_AND_CLIENT_KEYSTORES.equals((Object)this.getSSL().getMode())) {
                this.options.setSocketFactory(SecureSocketFactoryBuilder.getSocketFactory(this.getSSL().getProtocol(), this.getSSL().getServerKeyStoreFile(), this.getSSL().getServerKeyStorePassword(), this.getSSL().getClientKeyStoreFile(), this.getSSL().getClientKeyStorePassword(), this.getSSL().getClientKeyPassword()));
            }
        }
    }

    public MqttConnectOptions getOptions() {
        return this.options;
    }

    public String getId() {
        return this.id;
    }
}

