/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.IMqttConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttConnectionDetailsWithOptions;
import pl.baczkowicz.mqttspy.connectivity.topicmatching.TopicMatcher;
import pl.baczkowicz.spy.common.generated.ReconnectionSettings;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.exceptions.ExceptionUtils;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.utils.TimeUtils;

public abstract class BaseMqttConnection
implements IMqttConnection {
    private static final Logger logger = LoggerFactory.getLogger(BaseMqttConnection.class);
    private int connectionAttempts = 0;
    private long lastConnectionAttemptTimestamp = 0L;
    private Date lastSuccessfulConnectionAttempt;
    protected final Map<String, BaseMqttSubscription> subscriptions = new HashMap<String, BaseMqttSubscription>();
    private int lastUsedSubscriptionId = 0;
    protected MqttAsyncClient client;
    protected final MqttConnectionDetailsWithOptions connectionDetails;
    private ConnectionStatus connectionStatus = ConnectionStatus.NOT_CONNECTED;
    private String disconnectionReason;
    private final TopicMatcher topicMatcher;
    private BaseScriptManagerInterface scriptManager;

    public BaseMqttConnection(MqttConnectionDetailsWithOptions connectionDetails) {
        this.connectionDetails = connectionDetails;
        this.topicMatcher = new TopicMatcher();
    }

    public void createClient(MqttCallback callback) throws SpyException {
        try {
            logger.debug("Creating MQTT client with server URI {} and client ID {}", (Object)this.connectionDetails.getServerURI().get(0), (Object)this.connectionDetails.getClientID());
            this.client = new MqttAsyncClient(this.connectionDetails.getServerURI().get(0), this.connectionDetails.getClientID(), null);
            this.client.setCallback(callback);
        }
        catch (IllegalArgumentException e) {
            throw new SpyException("Cannot instantiate the MQTT client", e);
        }
        catch (MqttException e) {
            throw new SpyException("Cannot instantiate the MQTT client", e);
        }
    }

    public void connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws SpyException {
        this.recordConnectionAttempt();
        try {
            this.client.connect(options, userContext, callback);
        }
        catch (IllegalArgumentException e) {
            throw new SpyException("Connection attempt failed", e);
        }
        catch (MqttSecurityException e) {
            throw new SpyException("Connection attempt failed", e);
        }
        catch (MqttException e) {
            throw new SpyException("Connection attempt failed", e);
        }
    }

    public void connectAndWait(MqttConnectOptions options) throws SpyException {
        this.recordConnectionAttempt();
        try {
            this.client.connect(options).waitForCompletion();
        }
        catch (IllegalArgumentException e) {
            throw new SpyException("Connection attempt failed", e);
        }
        catch (MqttSecurityException e) {
            throw new SpyException("Connection attempt failed", e);
        }
        catch (MqttException e) {
            throw new SpyException("Connection attempt failed", e);
        }
    }

    protected void recordConnectionAttempt() {
        this.lastConnectionAttemptTimestamp = TimeUtils.getMonotonicTime();
        ++this.connectionAttempts;
    }

    public void recordSuccessfulConnection() {
        this.lastSuccessfulConnectionAttempt = new Date();
    }

    public String getLastSuccessfulyConnectionAttempt() {
        return TimeUtils.DATE_WITH_SECONDS_SDF.format(this.lastSuccessfulConnectionAttempt);
    }

    private void subscribeToTopic(String topic, int qos) throws SpyException {
        if (this.client == null || !this.client.isConnected()) {
            logger.warn("Client not connected");
            return;
        }
        try {
            this.client.subscribe(topic, qos);
            this.topicMatcher.addSubscriptionToStore(topic, "subscription");
        }
        catch (MqttException e) {
            throw new SpyException("Subscription attempt failed", e);
        }
    }

    @Override
    public boolean subscribe(String topic, int qos) {
        try {
            this.subscribeToTopic(topic, qos);
            logger.info("Successfully subscribed to " + topic);
            return true;
        }
        catch (SpyException e) {
            logger.error("Subscription attempt failed for topic {}", (Object)topic, (Object)e);
            return false;
        }
    }

    @Override
    public boolean subscribe(BaseMqttSubscription subscription) {
        subscription.setSubscriptionRequested(true);
        this.addSubscription(subscription);
        if (subscription.isActive()) {
            return false;
        }
        if (this.client == null || !this.client.isConnected()) {
            logger.warn("Client not connected");
            return false;
        }
        try {
            subscription.setSubscribing(true);
            logger.debug("Subscribing to " + subscription.getTopic());
            this.client.subscribe(subscription.getTopic(), subscription.getQos());
            logger.info("Subscribed to " + subscription.getTopic());
            subscription.setActive(true);
            subscription.setSubscribing(false);
            logger.trace("Subscription " + subscription.getTopic() + " is active = " + subscription.isActive());
            if (subscription.getDetails() != null && subscription.getDetails().getScriptFile() != null && !subscription.getDetails().getScriptFile().isEmpty()) {
                Script script = this.scriptManager.addScript(new ScriptDetails(false, false, subscription.getDetails().getScriptFile()));
                subscription.setScript(script);
                this.scriptManager.runScript(script, false);
                if (this.scriptManager.invokeBefore(script)) {
                    subscription.setScriptActive(true);
                }
            }
            return true;
        }
        catch (MqttException e) {
            subscription.setSubscribing(false);
            logger.error("Cannot subscribe to " + subscription.getTopic(), e);
            this.removeSubscription(subscription);
            return false;
        }
    }

    @Override
    public void addSubscription(BaseMqttSubscription subscription) {
        if (this.subscriptions.put(subscription.getTopic(), subscription) == null) {
            subscription.setId(this.lastUsedSubscriptionId++);
        }
        logger.debug("Adding topic " + subscription.getTopic() + " to the subsciption store");
        this.addSubscriptionToMatcher(subscription);
    }

    @Override
    public void removeSubscription(BaseMqttSubscription subscription) {
        this.subscriptions.remove(subscription.getTopic());
        this.removeSubscriptionFromMatcher(subscription);
    }

    public void addSubscriptionToMatcher(BaseMqttSubscription subscription) {
        this.getTopicMatcher().addSubscriptionToStore(subscription.getTopic(), "subscription" + subscription.getId());
    }

    public void removeSubscriptionFromMatcher(BaseMqttSubscription subscription) {
        this.getTopicMatcher().removeSubscriptionFromStore(subscription.getTopic(), "subscription" + subscription.getId());
    }

    public int getLastUsedSubscriptionId() {
        return this.lastUsedSubscriptionId;
    }

    public void unsubscribeFromTopic(String topic) throws SpyException {
        if (this.client == null || !this.client.isConnected()) {
            logger.warn("Client not connected");
            return;
        }
        try {
            this.client.unsubscribe(topic);
        }
        catch (MqttException e) {
            throw new SpyException("Unsubscription attempt failed", e);
        }
    }

    @Override
    public boolean unsubscribe(String topic) {
        try {
            this.unsubscribeFromTopic(topic);
            logger.info("Successfully unsubscribed from " + topic);
            return true;
        }
        catch (SpyException e) {
            logger.error("Unsubscribe attempt failed for topic {}", (Object)topic, (Object)e);
            return false;
        }
    }

    public abstract boolean unsubscribeAll(boolean var1);

    @Override
    public boolean canPublish() {
        return this.client != null && this.client.isConnected();
    }

    public void connectionLost(Throwable connectionLostCause) {
        this.setDisconnectionReason(ExceptionUtils.getInfo(connectionLostCause));
        this.setConnectionStatus(ConnectionStatus.DISCONNECTED);
    }

    public void setDisconnectionReason(String message) {
        this.disconnectionReason = message;
        if (!message.isEmpty()) {
            this.disconnectionReason = this.disconnectionReason + " (" + TimeUtils.DATE_WITH_SECONDS_SDF.format(new Date()) + ")";
        }
    }

    public void disconnect() {
        try {
            this.client.disconnect(0L);
            logger.info("Client {} disconnected", (Object)this.client.getClientId());
        }
        catch (MqttException e) {
            logger.error("Cannot disconnect", e);
        }
    }

    public String getDisconnectionReason() {
        return this.disconnectionReason;
    }

    public MqttConnectionDetailsWithOptions getMqttConnectionDetails() {
        return this.connectionDetails;
    }

    public ReconnectionSettings getReconnectionSettings() {
        return this.connectionDetails.getReconnectionSettings();
    }

    public String getName() {
        return this.connectionDetails.getName();
    }

    public long getLastConnectionAttemptTimestamp() {
        return this.lastConnectionAttemptTimestamp;
    }

    public int getConnectionAttempts() {
        return this.connectionAttempts;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public TopicMatcher getTopicMatcher() {
        return this.topicMatcher;
    }

    public MqttAsyncClient getClient() {
        return this.client;
    }

    public void setClient(MqttAsyncClient client) {
        this.client = client;
    }

    public void setScriptManager(BaseScriptManagerInterface scriptManager) {
        this.scriptManager = scriptManager;
    }

    @Override
    public BaseMqttSubscription getMqttSubscriptionForTopic(String topic) {
        return this.subscriptions.get(topic);
    }
}

