/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.configuration.ConfigurationUtils;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.Connectivity;
import pl.baczkowicz.mqttspy.configuration.generated.MqttSpyConfiguration;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.common.generated.Formatting;
import pl.baczkowicz.spy.connectivity.BaseSubscription;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.configuration.BaseConfigurationManager;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;
import pl.baczkowicz.spy.xml.XMLParser;

public class MqttConfigurationManager
extends BaseConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(MqttConfigurationManager.class);
    public static final String PACKAGE = "pl.baczkowicz.mqttspy.configuration.generated";
    public static final String SCHEMA = "/mqtt-spy-configuration.xsd";
    public static final String MQTT_COMMON_SCHEMA = "/mqtt-spy-common.xsd";
    private MqttSpyConfiguration configuration;
    private List<ConfiguredMqttConnectionDetails> connections = new ArrayList<ConfiguredMqttConnectionDetails>();
    private final XMLParser parser;

    public MqttConfigurationManager() throws XMLException {
        this.loadDefaultPropertyFile();
        this.loadUiPropertyFile();
        this.parser = new XMLParser(PACKAGE, new String[]{"/spy-common.xsd", MQTT_COMMON_SCHEMA, SCHEMA});
        this.configuration = new MqttSpyConfiguration();
        this.configuration.setConnectivity(new Connectivity());
        this.configuration.setFormatting(new Formatting());
    }

    @Override
    public boolean loadConfiguration(File file) {
        this.configuration = (MqttSpyConfiguration)this.loadConfiguration(this.parser, file);
        this.initialiseConfiguration();
        return this.configuration != null;
    }

    @Override
    public void initialiseConfiguration() {
        this.createConnections(this.configuration.getConnectivity().getConnectionV2());
        this.createConnectionGroups(this.configuration.getConnectionGroups(), new ArrayList<ModifiableConnection>(this.getConnections()));
        this.createConfigurationDefaults();
    }

    private void createConfigurationDefaults() {
        if (this.configuration.getFormatting() == null) {
            this.configuration.setFormatting(new Formatting());
        }
    }

    public static ConfiguredMqttConnectionDetails toConfiguredMqttConnectionDetails(UserInterfaceMqttConnectionDetails connectionDetails) {
        ConfigurationUtils.populateConnectionDefaults(connectionDetails);
        ConfiguredMqttConnectionDetails configuredConnectionDetails = new ConfiguredMqttConnectionDetails(false, false, connectionDetails);
        if (configuredConnectionDetails.getID() == null) {
            configuredConnectionDetails.setID(MqttConfigurationManager.generateConnectionId());
        }
        return configuredConnectionDetails;
    }

    private void createConnections(List<UserInterfaceMqttConnectionDetails> loadedConnections) {
        for (UserInterfaceMqttConnectionDetails connectionDetails : loadedConnections) {
            if (!(connectionDetails instanceof UserInterfaceMqttConnectionDetails)) continue;
            this.connections.add(MqttConfigurationManager.toConfiguredMqttConnectionDetails(connectionDetails));
        }
    }

    @Override
    public boolean saveConfiguration() {
        if (this.isConfigurationWritable()) {
            try {
                this.configuration.getConnectivity().getConnectionV2().clear();
                this.configuration.getConnectivity().getConnectionV2().addAll(this.connections);
                this.configuration.getConnectionGroups().clear();
                this.configuration.getConnectionGroups().addAll(this.getConnectionGrops());
                this.populateMissingFormatters(this.configuration.getFormatting().getFormatter(), this.connections);
                this.parser.saveToFile(this.getLoadedConfigurationFile(), new JAXBElement(new QName("http://baczkowicz.pl/mqtt-spy-configuration", "MqttSpyConfiguration"), MqttSpyConfiguration.class, (Object)this.configuration));
                return true;
            }
            catch (XMLException e) {
                this.setLastException(e);
                logger.error("Cannot save the configuration file", e);
            }
        }
        return false;
    }

    private void populateMissingFormatters(List<FormatterDetails> formatters, List<ConfiguredMqttConnectionDetails> connections) {
        for (ConfiguredMqttConnectionDetails connection : connections) {
            if (connection.getFormatter() == null) continue;
            boolean formatterFound = false;
            for (FormatterDetails formatter : formatters) {
                if (!((FormatterDetails)connection.getFormatter()).getID().equals(formatter.getID())) continue;
                formatterFound = true;
            }
            if (formatterFound) continue;
            formatters.add((FormatterDetails)connection.getFormatter());
        }
    }

    @Override
    public void clear() {
        this.connections.clear();
        this.configuration = null;
        this.setLoadedConfigurationFile(null);
        this.setLastException(null);
    }

    public ConfiguredMqttConnectionDetails getMatchingConnection(String id) {
        for (ConfiguredMqttConnectionDetails details : this.getConnections()) {
            if (!id.equals(details.getID())) continue;
            return details;
        }
        return null;
    }

    @Override
    public void updateSubscriptionConfiguration(String connectionId, BaseSubscription subscription) {
        ConfiguredMqttConnectionDetails details = this.getMatchingConnection(connectionId);
        boolean matchFound = false;
        for (TabbedSubscriptionDetails subscriptionDetails : details.getSubscription()) {
            if (!subscriptionDetails.getTopic().equals(subscription.getTopic())) continue;
            if (subscription instanceof MqttSubscription) {
                subscriptionDetails.setQos(((MqttSubscription)subscription).getQos());
            }
            subscriptionDetails.setCreateTab(true);
            subscriptionDetails.setScriptFile(subscription.getDetails().getScriptFile());
            matchFound = true;
            break;
        }
        if (!matchFound) {
            TabbedSubscriptionDetails subscriptionDetails = new TabbedSubscriptionDetails();
            subscriptionDetails.setTopic(subscription.getTopic());
            if (subscription instanceof MqttSubscription) {
                subscriptionDetails.setQos(((MqttSubscription)subscription).getQos());
            }
            subscriptionDetails.setCreateTab(true);
            subscriptionDetails.setScriptFile(subscription.getDetails().getScriptFile());
            details.getSubscription().add(subscriptionDetails);
        }
        this.saveConfiguration();
    }

    @Override
    public void deleteSubscriptionConfiguration(String connectionId, BaseSubscription subscription) {
        ConfiguredMqttConnectionDetails details = this.getMatchingConnection(connectionId);
        TabbedSubscriptionDetails itemToRemove = null;
        for (TabbedSubscriptionDetails subscriptionDetails : details.getSubscription()) {
            if (!subscriptionDetails.getTopic().equals(subscription.getTopic())) continue;
            itemToRemove = subscriptionDetails;
            break;
        }
        if (itemToRemove != null) {
            details.getSubscription().remove(itemToRemove);
        }
        this.saveConfiguration();
    }

    public MqttSpyConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<ConfiguredMqttConnectionDetails> getConnections() {
        return this.connections;
    }

    @Override
    public List<FormatterDetails> getFormatters() {
        return this.configuration.getFormatting().getFormatter();
    }

    @Override
    public boolean removeFormatter(FormatterDetails formatter) {
        for (ConfiguredMqttConnectionDetails connectionDetails : this.getConnections()) {
            if (!formatter.getID().equals(((FormatterDetails)connectionDetails.getFormatter()).getID())) continue;
            connectionDetails.setFormatter(null);
        }
        this.getFormatters().remove(formatter);
        return this.saveConfiguration();
    }

    @Override
    public int countFormatter(FormatterDetails formatter) {
        int count = 0;
        for (ConfiguredMqttConnectionDetails connectionDetails : this.getConnections()) {
            if (connectionDetails.getFormatter() == null || !formatter.getID().equals(((FormatterDetails)connectionDetails.getFormatter()).getID())) continue;
            ++count;
        }
        return count;
    }
}

