/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.reactfx.util.ConcatView;
import org.reactfx.util.ListConcatenation;

public final class Lists {
    private Lists() {
    }

    public static <E> int hashCode(List<E> list) {
        int hashCode = 1;
        for (E e : list) {
            hashCode = 31 * hashCode + Objects.hashCode(e);
        }
        return hashCode;
    }

    public static boolean equals(List<?> list, Object o) {
        if (o == list) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        if (list.size() != that.size()) {
            return false;
        }
        Iterator<?> it1 = list.iterator();
        Iterator it2 = that.iterator();
        while (it1.hasNext()) {
            if (Objects.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static String toString(List<?> list) {
        StringBuilder res = new StringBuilder();
        res.append('[');
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            res.append(it.next());
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        res.append(']');
        return res.toString();
    }

    public static <E> Iterator<E> readOnlyIterator(final Collection<? extends E> col) {
        return new Iterator<E>(){
            private final Iterator<? extends E> delegate;
            {
                this.delegate = col.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public E next() {
                return this.delegate.next();
            }
        };
    }

    public static boolean isValidIndex(int index, int size) {
        return Lists.isValidIndex(0, index, size);
    }

    public static boolean isValidIndex(int min, int index, int max) {
        return min <= index && index < max;
    }

    public static void checkIndex(int index, int size) {
        Lists.checkIndex(0, index, size);
    }

    public static void checkIndex(int min, int index, int max) {
        if (!Lists.isValidIndex(min, index, max)) {
            throw new IndexOutOfBoundsException(index + " not in [" + min + ", " + max + ")");
        }
    }

    public static boolean isValidPosition(int position, int size) {
        return Lists.isValidPosition(0, position, size);
    }

    public static boolean isValidPosition(int min, int position, int max) {
        return min <= position && position <= max;
    }

    public static void checkPosition(int position, int size) {
        Lists.checkPosition(0, position, size);
    }

    public static void checkPosition(int min, int position, int max) {
        if (!Lists.isValidPosition(min, position, max)) {
            throw new IndexOutOfBoundsException(position + " not in [" + min + ", " + max + "]");
        }
    }

    public static boolean isValidRange(int from, int to, int size) {
        return Lists.isValidRange(0, from, to, size);
    }

    public static boolean isValidRange(int min, int from, int to, int max) {
        return min <= from && from <= to && to <= max;
    }

    public static void checkRange(int from, int to, int size) {
        Lists.checkRange(0, from, to, size);
    }

    public static void checkRange(int min, int from, int to, int max) {
        if (!Lists.isValidRange(min, from, to, max)) {
            throw new IndexOutOfBoundsException("[" + from + ", " + to + ") is not a valid range within " + "[" + min + ", " + max + ")");
        }
    }

    public static boolean isNonEmptyRange(int from, int to, int size) {
        return Lists.isNonEmptyRange(0, from, to, size);
    }

    public static boolean isNonEmptyRange(int min, int from, int to, int max) {
        return min <= from && from < to && to <= max;
    }

    public static boolean isProperRange(int from, int to, int size) {
        return Lists.isProperRange(0, from, to, size);
    }

    public static boolean isProperRange(int min, int from, int to, int max) {
        return Lists.isValidRange(min, from, to, max) && (min < from || to < max);
    }

    public static boolean isProperNonEmptyRange(int from, int to, int size) {
        return Lists.isProperNonEmptyRange(0, from, to, size);
    }

    public static boolean isProperNonEmptyRange(int min, int from, int to, int max) {
        return Lists.isNonEmptyRange(min, from, to, max) && (min < from || to < max);
    }

    public static boolean isStrictlyInsideRange(int from, int to, int size) {
        return Lists.isStrictlyInsideRange(0, from, to, size);
    }

    public static boolean isStrictlyInsideRange(int min, int from, int to, int max) {
        return min < from && from <= to && to < max;
    }

    public static boolean isStrictlyInsideNonEmptyRange(int from, int to, int size) {
        return Lists.isStrictlyInsideNonEmptyRange(0, from, to, size);
    }

    public static boolean isStrictlyInsideNonEmptyRange(int min, int from, int to, int max) {
        return min < from && from < to && to < max;
    }

    public static <E, F> List<F> mappedView(final List<? extends E> source, final Function<? super E, ? extends F> f) {
        return new AbstractList<F>(){

            @Override
            public F get(int index) {
                return f.apply(source.get(index));
            }

            @Override
            public int size() {
                return source.size();
            }
        };
    }

    @SafeVarargs
    public static <E> List<E> concatView(List<? extends E> ... lists) {
        return Lists.concatView(Arrays.asList(lists));
    }

    public static <E> List<E> concatView(List<List<? extends E>> lists) {
        if (lists.isEmpty()) {
            return Collections.emptyList();
        }
        return ConcatView.create(lists);
    }

    @SafeVarargs
    public static <E> List<E> concat(List<? extends E> ... lists) {
        return Lists.concat(Arrays.asList(lists));
    }

    public static <E> List<E> concat(List<List<? extends E>> lists) {
        return ListConcatenation.create(lists);
    }
}

