/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactfx.util.FingerTree;
import org.reactfx.util.MapToMonoid;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuple3;

class ListConcatenation<E>
extends AbstractList<E> {
    private static final MapToMonoid<List<?>, Integer> LIST_SIZE_MONOID = new MapToMonoid<List<?>, Integer>(){

        @Override
        public Integer apply(List<?> t) {
            return t.size();
        }

        @Override
        public Integer unit() {
            return 0;
        }

        @Override
        public Integer reduce(Integer left, Integer right) {
            return left + right;
        }
    };
    private final FingerTree<List<E>, Integer> ft;

    static <E> List<E> create(List<List<? extends E>> lists) {
        return lists.stream().filter(l -> !l.isEmpty()).map(l -> {
            List lst = l;
            return lst instanceof ListConcatenation ? ((ListConcatenation)lst).ft : FingerTree.mkTree(Collections.singletonList(lst), LIST_SIZE_MONOID);
        }).reduce(FingerTree::join).map(ListConcatenation::new).orElse(Collections.emptyList());
    }

    ListConcatenation(FingerTree<List<E>, Integer> ft) {
        this.ft = ft;
    }

    @Override
    public E get(int index) {
        return (E)this.ft.get(Integer::intValue, index, List::get);
    }

    @Override
    public int size() {
        return this.ft.getStats();
    }

    @Override
    public List<E> subList(int from, int to) {
        Tuple3<FingerTree<List<Object>, Integer>, Optional<Tuple2<List<Object>, Integer>>, FingerTree<List<Object>, Integer>> lmr = this.ft.split(Integer::intValue, from);
        Optional m = (Optional)lmr._2;
        FingerTree r = (FingerTree)lmr._3;
        FingerTree t = m.map(t2 -> t2.map((lst, i) -> r.prepend(lst.subList((int)i, lst.size())))).orElse(r);
        lmr = t.split(Integer::intValue, to - from);
        FingerTree l = (FingerTree)lmr._1;
        m = (Optional)lmr._2;
        t = m.map(t2 -> t2.map((lst, i) -> l.append(lst.subList(0, (int)i)))).orElse(l);
        return new ListConcatenation<E>(t);
    }
}

