/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.Collection;
import org.reactfx.collection.AccessorListMethods;

interface ReadOnlyListImpl<E>
extends AccessorListMethods<E> {
    @Override
    default public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    default public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return !c.isEmpty();
    }

    @Override
    default public boolean addAll(int index, Collection<? extends E> c) {
        for (E e : c) {
            this.add(index++, e);
        }
        return !c.isEmpty();
    }

    @Override
    default public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i != -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        return c.stream().anyMatch(this::remove);
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (c.contains(this.get(i))) continue;
            this.remove(i);
            changed = true;
        }
        return changed;
    }

    @Override
    default public void clear() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }
}

