/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Supplier;
import org.reactfx.BiSuspendable;
import org.reactfx.Guard;
import org.reactfx.MultiSuspendable;

public interface Suspendable {
    public Guard suspend();

    default public void suspendWhile(Runnable r) {
        try (Guard g = this.suspend();){
            r.run();
        }
    }

    default public <U> U suspendWhile(Supplier<U> f) {
        try (Guard g = this.suspend();){
            U u = f.get();
            return u;
        }
    }

    public static Suspendable combine(Suspendable ... suspendables) {
        switch (suspendables.length) {
            case 0: {
                throw new IllegalArgumentException("Must invoke with at least 1 argument");
            }
            case 1: {
                return suspendables[0];
            }
            case 2: {
                return new BiSuspendable(suspendables[0], suspendables[1]);
            }
        }
        return new MultiSuspendable(suspendables);
    }
}

