/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils.chart;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.input.MouseEvent;
import org.gillius.jfxutils.EventHandlerManager;
import org.gillius.jfxutils.chart.AxisConstraint;
import org.gillius.jfxutils.chart.AxisConstraintStrategies;
import org.gillius.jfxutils.chart.AxisConstraintStrategy;
import org.gillius.jfxutils.chart.ChartZoomManager;
import org.gillius.jfxutils.chart.DefaultChartInputContext;
import org.gillius.jfxutils.chart.XYChartInfo;

public class ChartPanManager {
    public static final EventHandler<MouseEvent> DEFAULT_FILTER = ChartZoomManager.DEFAULT_FILTER;
    private final EventHandlerManager handlerManager;
    private final ValueAxis<?> xAxis;
    private final ValueAxis<?> yAxis;
    private final XYChartInfo chartInfo;
    private AxisConstraint panMode = AxisConstraint.None;
    private AxisConstraintStrategy axisConstraintStrategy = AxisConstraintStrategies.getDefault();
    private EventHandler<? super MouseEvent> mouseFilter = DEFAULT_FILTER;
    private boolean dragging = false;
    private boolean wasXAnimated;
    private boolean wasYAnimated;
    private double lastX;
    private double lastY;

    public ChartPanManager(XYChart<?, ?> chart) {
        this.handlerManager = new EventHandlerManager((Node)chart);
        this.xAxis = (ValueAxis)chart.getXAxis();
        this.yAxis = (ValueAxis)chart.getYAxis();
        this.chartInfo = new XYChartInfo(chart, (Node)chart);
        this.handlerManager.addEventHandler(false, MouseEvent.DRAG_DETECTED, new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (ChartPanManager.this.passesFilter(mouseEvent)) {
                    ChartPanManager.this.startDrag(mouseEvent);
                }
            }
        });
        this.handlerManager.addEventHandler(false, MouseEvent.MOUSE_DRAGGED, new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ChartPanManager.this.drag(mouseEvent);
            }
        });
        this.handlerManager.addEventHandler(false, MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ChartPanManager.this.release();
            }
        });
    }

    public AxisConstraintStrategy getAxisConstraintStrategy() {
        return this.axisConstraintStrategy;
    }

    public void setAxisConstraintStrategy(AxisConstraintStrategy axisConstraintStrategy) {
        this.axisConstraintStrategy = axisConstraintStrategy;
    }

    public EventHandler<? super MouseEvent> getMouseFilter() {
        return this.mouseFilter;
    }

    public void setMouseFilter(EventHandler<? super MouseEvent> mouseFilter) {
        this.mouseFilter = mouseFilter;
    }

    public void start() {
        this.handlerManager.addAllHandlers();
    }

    public void stop() {
        this.handlerManager.removeAllHandlers();
        this.release();
    }

    private boolean passesFilter(MouseEvent event) {
        if (this.mouseFilter != null) {
            MouseEvent cloned = (MouseEvent)event.clone();
            this.mouseFilter.handle((Event)cloned);
            if (cloned.isConsumed()) {
                return false;
            }
        }
        return true;
    }

    private void startDrag(MouseEvent event) {
        DefaultChartInputContext context = new DefaultChartInputContext(this.chartInfo, event.getX(), event.getY());
        this.panMode = this.axisConstraintStrategy.getConstraint(context);
        if (this.panMode != AxisConstraint.None) {
            this.lastX = event.getX();
            this.lastY = event.getY();
            this.wasXAnimated = this.xAxis.getAnimated();
            this.wasYAnimated = this.yAxis.getAnimated();
            this.xAxis.setAnimated(false);
            this.xAxis.setAutoRanging(false);
            this.yAxis.setAnimated(false);
            this.yAxis.setAutoRanging(false);
            this.dragging = true;
        }
    }

    private void drag(MouseEvent event) {
        if (!this.dragging) {
            return;
        }
        if (this.panMode == AxisConstraint.Both || this.panMode == AxisConstraint.Horizontal) {
            double dX = (event.getX() - this.lastX) / -this.xAxis.getScale();
            this.lastX = event.getX();
            this.xAxis.setAutoRanging(false);
            this.xAxis.setLowerBound(this.xAxis.getLowerBound() + dX);
            this.xAxis.setUpperBound(this.xAxis.getUpperBound() + dX);
        }
        if (this.panMode == AxisConstraint.Both || this.panMode == AxisConstraint.Vertical) {
            double dY = (event.getY() - this.lastY) / -this.yAxis.getScale();
            this.lastY = event.getY();
            this.yAxis.setAutoRanging(false);
            this.yAxis.setLowerBound(this.yAxis.getLowerBound() + dY);
            this.yAxis.setUpperBound(this.yAxis.getUpperBound() + dY);
        }
    }

    private void release() {
        if (!this.dragging) {
            return;
        }
        this.dragging = false;
        this.xAxis.setAnimated(this.wasXAnimated);
        this.yAxis.setAnimated(this.wasYAnimated);
    }
}

