/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils;

import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;

public class EventHandlerManager {
    private final Node target;
    private final List<Registration<? extends Event>> registrations;

    public EventHandlerManager(Node target) {
        this.target = target;
        this.registrations = new ArrayList<Registration<? extends Event>>();
    }

    public Node getTarget() {
        return this.target;
    }

    public <T extends Event> void addEventHandler(boolean addImmediately, EventType<T> type, EventHandler<? super T> handler) {
        Registration<T> reg = new Registration<T>(type, handler);
        this.registrations.add(reg);
        if (addImmediately) {
            this.target.addEventHandler(type, handler);
            reg.setRegistered(true);
        }
    }

    public <T extends Event> void addEventHandler(EventType<T> type, EventHandler<? super T> handler) {
        this.addEventHandler(true, type, handler);
    }

    public void addAllHandlers() {
        for (Registration<? extends Event> registration : this.registrations) {
            if (registration.isRegistered()) continue;
            this.target.addEventHandler(registration.getType(), registration.getHandler());
            registration.setRegistered(true);
        }
    }

    public void removeAllHandlers() {
        for (Registration<? extends Event> registration : this.registrations) {
            if (!registration.isRegistered()) continue;
            this.target.removeEventHandler(registration.getType(), registration.getHandler());
            registration.setRegistered(false);
        }
    }

    private static class Registration<T extends Event> {
        private final EventType<T> type;
        private final EventHandler<? super T> handler;
        private boolean registered = false;

        public Registration(EventType<T> type, EventHandler<? super T> handler) {
            if (type == null) {
                throw new IllegalArgumentException("type cannot be null");
            }
            if (handler == null) {
                throw new IllegalArgumentException("handler cannot be null");
            }
            this.type = type;
            this.handler = handler;
        }

        public EventType<T> getType() {
            return this.type;
        }

        public EventHandler<? super T> getHandler() {
            return this.handler;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public void setRegistered(boolean registered) {
            this.registered = registered;
        }
    }
}

