/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.skin;

import java.util.List;
import java.util.function.Function;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import org.fxmisc.wellbehaved.skin.Behavior;
import org.fxmisc.wellbehaved.skin.ComplexVisualBase;
import org.fxmisc.wellbehaved.skin.SimpleVisualBase;

public final class Skins {
    public static <C extends Control, V extends SimpleVisualBase<? super C>> Skin<C> createSimpleSkin(final C control, final Function<? super C, ? extends V> visualFactory, final Function<? super V, ? extends Behavior> behaviorFactory) {
        return new SkinBase<C>(control){
            private final V visual;
            private final Behavior behavior;
            private final Node node;
            {
                super(x0);
                this.visual = (SimpleVisualBase)visualFactory.apply(control);
                this.behavior = (Behavior)behaviorFactory.apply(this.visual);
                this.node = ((SimpleVisualBase)this.visual).getNode();
                this.getChildren().add((Object)this.node);
            }

            public void dispose() {
                this.behavior.dispose();
                this.visual.dispose();
                this.getChildren().remove((Object)this.node);
            }

            public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
                return this.visual.getCssMetaData();
            }
        };
    }

    public static <C extends Control, V extends ComplexVisualBase<C>> Skin<C> createComplexSkin(final C control, final Function<? super C, ? extends V> visualFactory, final Function<? super V, ? extends Behavior> behaviorFactory) {
        return new SkinBase<C>(control){
            private final V visual;
            private final Behavior behavior;
            {
                super(x0);
                this.visual = (ComplexVisualBase)visualFactory.apply(control);
                this.behavior = (Behavior)behaviorFactory.apply(this.visual);
            }

            public void dispose() {
                this.behavior.dispose();
                ((ComplexVisualBase)this.visual).dispose();
            }

            public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
                return this.visual.getCssMetaData();
            }
        };
    }
}

