/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.event.Event;
import javafx.event.EventType;
import org.fxmisc.wellbehaved.event.EventHandlerTemplate;
import org.fxmisc.wellbehaved.event.EventPattern;

public final class StatefulEventHandlerTemplate<T, S, E extends Event>
implements EventHandlerTemplate<T, E> {
    private final Supplier<? extends S> initialStateSupplier;
    private final StateTransitioningHandler<? super T, S, ? super E> handler;

    public static <T, S, E extends Event, F extends E> On<T, S, E, F> on(EventPattern<? super E, ? extends F> eventMatcher) {
        return Builder.empty().on(eventMatcher);
    }

    public static <T, S, E extends Event, F extends E> On<T, S, E, F> on(EventType<? extends F> eventType) {
        return Builder.empty().on(eventType);
    }

    public static <T, S, E extends Event> Builder<T, S, E> startWith(StateTransitioningHandler<? super T, S, ? super E> handler) {
        return Builder.empty().addHandler(handler);
    }

    StatefulEventHandlerTemplate(StateTransitioningHandler<? super T, S, ? super E> handler, Supplier<? extends S> initialStateSupplier) {
        this.initialStateSupplier = initialStateSupplier;
        this.handler = handler;
    }

    @Override
    public BiConsumer<? super T, ? super E> getHandler() {
        return new BiConsumer<T, E>(){
            private S state;
            {
                this.state = StatefulEventHandlerTemplate.this.initialStateSupplier.get();
            }

            @Override
            public void accept(T t, E e) {
                this.state = StatefulEventHandlerTemplate.this.handler.handle(t, this.state, e);
            }
        };
    }

    public <U extends T> StatefulEventHandlerTemplate<U, S, ? super E> onlyWhen(BiPredicate<? super U, ? super S> condition) {
        return this.handler.onlyWhen(condition).initialStateSupplier(this.initialStateSupplier);
    }

    public <U extends T, F extends E> StatefulEventHandlerTemplate<U, S, F> addHandler(StateTransitioningHandler<? super U, S, ? super F> nextHandler) {
        return this.handler.orElse(nextHandler).initialStateSupplier(this.initialStateSupplier);
    }

    public static class When<T, S, E extends Event, F extends E> {
        private final Builder<? super T, S, ? super E> previousBuilder;
        private final EventPattern<? super E, ? extends F> eventMatcher;
        private final BiPredicate<? super T, ? super S> condition;

        private When(Builder<? super T, S, ? super E> previousBuilder, EventPattern<? super E, ? extends F> eventMatcher, BiPredicate<? super T, ? super S> condition) {
            this.previousBuilder = previousBuilder;
            this.eventMatcher = eventMatcher;
            this.condition = condition;
        }

        public <U extends T> Builder<U, S, E> act(BiConsumer<? super U, ? super F> action) {
            return this.act((? super U u, S s, ? super F e) -> {
                action.accept((Object)u, (Object)e);
                return s;
            });
        }

        public <U extends T> Builder<U, S, E> act(StateTransition<? super U, S, ? super F> action) {
            return this.previousBuilder.addHandler((u, s, e) -> {
                Optional<F> optF = this.eventMatcher.match(e);
                if (optF.isPresent() && this.condition.test(u, s)) {
                    Event f = (Event)optF.get();
                    Object newState = action.transition((Object)u, (S)s, (F)f);
                    f.consume();
                    return newState;
                }
                return s;
            });
        }
    }

    public static class On<T, S, E extends Event, F extends E> {
        private final Builder<? super T, S, ? super E> previousBuilder;
        private final EventPattern<? super E, ? extends F> eventMatcher;

        private On(Builder<? super T, S, ? super E> previousBuilder, EventPattern<? super E, ? extends F> eventMatcher) {
            this.previousBuilder = previousBuilder;
            this.eventMatcher = eventMatcher;
        }

        public On<T, S, E, F> where(Predicate<? super E> condition) {
            return new On<T, S, E, E>(this.previousBuilder, this.eventMatcher.and(condition));
        }

        public <U extends T> When<U, S, E, F> when(Predicate<? super U> condition) {
            return this.when((? super U u, ? super S s) -> condition.test((Object)u));
        }

        public <U extends T> When<U, S, E, F> when(BiPredicate<? super U, ? super S> condition) {
            return new When(this.previousBuilder, this.eventMatcher, condition);
        }

        public <U extends T> Builder<U, S, E> act(BiConsumer<? super U, ? super E> action) {
            return this.act((? super U u, S s, ? super F e) -> {
                action.accept((Object)u, (Object)e);
                return s;
            });
        }

        public <U extends T> Builder<U, S, E> act(StateTransition<? super U, S, ? super F> action) {
            return this.previousBuilder.addHandler((u, s, e) -> {
                Optional<F> optF = this.eventMatcher.match(e);
                if (optF.isPresent()) {
                    Event f = (Event)optF.get();
                    Object newState = action.transition((Object)u, (S)s, (F)f);
                    f.consume();
                    return newState;
                }
                return s;
            });
        }
    }

    private static class CompositeBuilder<T, S, E extends Event>
    extends Builder<T, S, E> {
        private final Builder<? super T, S, ? super E> previousBuilder;
        private final StateTransitioningHandler<? super T, S, ? super E> handler;

        private CompositeBuilder(Builder<? super T, S, ? super E> previousBuilder, StateTransitioningHandler<? super T, S, ? super E> handler) {
            this.previousBuilder = previousBuilder;
            this.handler = handler;
        }

        @Override
        <U extends T, F extends E> List<StateTransitioningHandler<? super U, S, ? super F>> getHandlers(int additionalCapacity) {
            List<StateTransitioningHandler<U, S, F>> handlers = this.previousBuilder.getHandlers(additionalCapacity + 1);
            handlers.add(this.handler);
            return handlers;
        }
    }

    public static abstract class Builder<T, S, E extends Event> {
        private static <T, S, E extends Event> Builder<T, S, E> empty() {
            return new Builder<T, S, E>(){

                @Override
                <U extends T, F extends E> List<StateTransitioningHandler<? super U, S, ? super F>> getHandlers(int additionalCapacity) {
                    return new ArrayList(additionalCapacity);
                }
            };
        }

        private Builder() {
        }

        public <F extends E> On<T, S, E, F> on(EventPattern<? super E, ? extends F> eventMatcher) {
            return new On(this, eventMatcher);
        }

        public <F extends E> On<T, S, E, F> on(EventType<? extends F> eventType) {
            return this.on(EventPattern.eventTypePattern(eventType));
        }

        public <U extends T, F extends E> Builder<U, S, F> addHandler(StateTransitioningHandler<? super U, S, ? super F> handler) {
            return new CompositeBuilder(this, handler);
        }

        public StateTransitioningHandler<T, S, E> createHandler() {
            return (t, s, e) -> {
                Object newState = s;
                for (StateTransitioningHandler<Object, Object, Event> stateTransitioningHandler : this.getHandlers()) {
                    newState = stateTransitioningHandler.handle(t, newState, e);
                    if (!e.isConsumed()) continue;
                    break;
                }
                return newState;
            };
        }

        public StatefulEventHandlerTemplate<T, S, E> initialStateSupplier(Supplier<? extends S> initialStateSupplier) {
            return this.createHandler().initialStateSupplier(initialStateSupplier);
        }

        List<StateTransitioningHandler<? super T, S, ? super E>> getHandlers() {
            return this.getHandlers(0);
        }

        abstract <U extends T, F extends E> List<StateTransitioningHandler<? super U, S, ? super F>> getHandlers(int var1);
    }

    @FunctionalInterface
    public static interface StateTransitioningHandler<T, S, E extends Event> {
        public S handle(T var1, S var2, E var3);

        default public <U extends T, F extends E> StateTransitioningHandler<U, S, F> orElse(StateTransitioningHandler<? super U, S, ? super F> nextHandler) {
            return (u, s, f) -> {
                Object newState = this.handle(u, s, f);
                if (f.isConsumed()) {
                    return newState;
                }
                return nextHandler.handle((Object)u, (S)s, (Object)f);
            };
        }

        default public <U extends T> StateTransitioningHandler<U, S, E> onlyWhen(BiPredicate<? super U, ? super S> condition) {
            return (u, s, e) -> condition.test((Object)u, (S)s) ? this.handle(u, s, e) : s;
        }

        default public StatefulEventHandlerTemplate<T, S, E> initialStateSupplier(Supplier<? extends S> initialStateSupplier) {
            return new StatefulEventHandlerTemplate(this, initialStateSupplier);
        }
    }

    @FunctionalInterface
    public static interface StateTransition<T, S, E extends Event> {
        public S transition(T var1, S var2, E var3);
    }
}

