/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import org.fxmisc.wellbehaved.event.EventHandlerHelper;
import org.fxmisc.wellbehaved.event.NodeHelper;
import org.fxmisc.wellbehaved.event.SceneHelper;

public abstract class EventSourceHelper<T, E extends Event> {
    private final ObjectProperty<EventHandler<? super E>> onEvent = new SimpleObjectProperty(EventHandlerHelper.empty());
    private final T source;

    public static <T extends Node, E extends Event> EventSourceHelper<T, E> forNode(T node, EventType<? extends E> eventType) {
        return new NodeHelper<T, E>(node, eventType);
    }

    public static <E extends Event> EventSourceHelper<Scene, E> forScene(Scene scene, EventType<? extends E> eventType) {
        return new SceneHelper<E>(scene, eventType);
    }

    EventSourceHelper(T eventSource, EventType<? extends E> eventType) {
        this.source = eventSource;
        this.onEvent.addListener((obs, oldHandler, newHandler) -> {
            if (oldHandler != EventHandlerHelper.empty()) {
                this.removeEventHandler(this.source, (EventType)eventType, (EventHandler)oldHandler);
            }
            if (newHandler != EventHandlerHelper.empty()) {
                this.addEventHandler(this.source, (EventType)eventType, (EventHandler)newHandler);
            }
        });
    }

    abstract <F extends Event> void addEventHandler(T var1, EventType<F> var2, EventHandler<? super F> var3);

    abstract <F extends Event> void removeEventHandler(T var1, EventType<F> var2, EventHandler<? super F> var3);

    public final ObjectProperty<EventHandler<? super E>> onEventProperty() {
        return this.onEvent;
    }

    public final T getEventSource() {
        return this.source;
    }

    public final void dispose() {
        this.onEvent.set(EventHandlerHelper.empty());
    }
}

