/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.undo.impl;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.impl.ChangeQueue;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.SuspendableNo;

public class UndoManagerImpl<C>
implements UndoManager {
    private final ChangeQueue<C> queue;
    private final Function<? super C, ? extends C> invert;
    private final Consumer<C> apply;
    private final BiFunction<C, C, Optional<C>> merge;
    private final Subscription subscription;
    private final SuspendableNo performingAction = new SuspendableNo();
    private final BooleanBinding undoAvailable = new BooleanBinding(){

        protected boolean computeValue() {
            return UndoManagerImpl.this.queue.hasPrev();
        }
    };
    private final BooleanBinding redoAvailable = new BooleanBinding(){

        protected boolean computeValue() {
            return UndoManagerImpl.this.queue.hasNext();
        }
    };
    private final BooleanBinding atMarkedPosition = new BooleanBinding(){

        protected boolean computeValue() {
            return UndoManagerImpl.this.mark.equals(UndoManagerImpl.this.queue.getCurrentPosition());
        }
    };
    private boolean canMerge;
    private ChangeQueue.QueuePosition mark;
    private C expectedChange = null;

    public UndoManagerImpl(ChangeQueue<C> queue, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, EventStream<C> changeSource) {
        this.queue = queue;
        this.invert = invert;
        this.apply = apply;
        this.merge = merge;
        this.mark = queue.getCurrentPosition();
        this.subscription = changeSource.subscribe(this::changeObserved);
    }

    @Override
    public void close() {
        this.subscription.unsubscribe();
    }

    @Override
    public boolean undo() {
        if (this.isUndoAvailable()) {
            this.canMerge = false;
            this.performChange(this.invert.apply(this.queue.prev()));
            this.undoAvailable.invalidate();
            this.redoAvailable.invalidate();
            this.atMarkedPosition.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public boolean redo() {
        if (this.isRedoAvailable()) {
            this.canMerge = false;
            this.performChange(this.queue.next());
            this.undoAvailable.invalidate();
            this.redoAvailable.invalidate();
            this.atMarkedPosition.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public boolean isUndoAvailable() {
        return this.undoAvailable.get();
    }

    @Override
    public ObservableBooleanValue undoAvailableProperty() {
        return this.undoAvailable;
    }

    @Override
    public boolean isRedoAvailable() {
        return this.redoAvailable.get();
    }

    @Override
    public ObservableBooleanValue redoAvailableProperty() {
        return this.redoAvailable;
    }

    @Override
    public boolean isPerformingAction() {
        return this.performingAction.get();
    }

    @Override
    public ObservableBooleanValue performingActionProperty() {
        return this.performingAction;
    }

    @Override
    public boolean isAtMarkedPosition() {
        return this.atMarkedPosition.get();
    }

    @Override
    public ObservableBooleanValue atMarkedPositionProperty() {
        return this.atMarkedPosition;
    }

    @Override
    public UndoManager.UndoPosition getCurrentPosition() {
        return new UndoPositionImpl(this.queue.getCurrentPosition());
    }

    @Override
    public void preventMerge() {
        this.canMerge = false;
    }

    @Override
    public void forgetHistory() {
        this.queue.forgetHistory();
        this.undoAvailable.invalidate();
    }

    private void performChange(C change) {
        this.expectedChange = change;
        this.performingAction.suspendWhile(() -> this.apply.accept(change));
    }

    private void changeObserved(C change) {
        if (this.expectedChange == null) {
            this.addChange(change);
        } else if (this.expectedChange.equals(change)) {
            this.expectedChange = null;
        } else {
            throw new IllegalArgumentException("Unexpected change received.\nExpected:\n" + this.expectedChange + "\nReceived:\n" + change);
        }
    }

    private void addChange(C change) {
        if (this.canMerge && this.queue.hasPrev()) {
            C prev = this.queue.prev();
            this.queue.push(this.merge(prev, change));
        } else {
            this.queue.push(change);
        }
        this.canMerge = true;
        this.undoAvailable.invalidate();
        this.redoAvailable.invalidate();
        this.atMarkedPosition.invalidate();
    }

    private C[] merge(C c1, C c2) {
        Optional<C> merged = this.merge.apply(c1, c2);
        if (merged.isPresent()) {
            return new Object[]{merged.get()};
        }
        return new Object[]{c1, c2};
    }

    private class UndoPositionImpl
    implements UndoManager.UndoPosition {
        private final ChangeQueue.QueuePosition queuePos;

        UndoPositionImpl(ChangeQueue.QueuePosition queuePos) {
            this.queuePos = queuePos;
        }

        @Override
        public void mark() {
            UndoManagerImpl.this.mark = this.queuePos;
            UndoManagerImpl.this.canMerge = false;
            UndoManagerImpl.this.atMarkedPosition.invalidate();
        }

        @Override
        public boolean isValid() {
            return this.queuePos.isValid();
        }
    }
}

