/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import java.util.Optional;
import java.util.function.Predicate;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.IndexRange;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.skin.CharacterHit;
import org.fxmisc.richtext.skin.ParagraphBox;
import org.fxmisc.richtext.skin.StyledTextAreaView;
import org.fxmisc.richtext.skin.StyledTextAreaVisual;
import org.fxmisc.wellbehaved.event.EventHandlerHelper;
import org.fxmisc.wellbehaved.event.EventHandlerTemplate;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.skin.Behavior;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class StyledTextAreaBehavior
implements Behavior {
    private static final boolean isMac;
    private static final boolean isWindows;
    private static final EventHandlerTemplate<StyledTextAreaBehavior, ? super KeyEvent> KEY_PRESSED_TEMPLATE;
    private static final EventHandlerTemplate<StyledTextAreaBehavior, ? super KeyEvent> KEY_TYPED_TEMPLATE;
    private final StyledTextArea<?> area;
    private final StyledTextAreaVisual<?> visual;
    private final StyledTextAreaView<?> view;
    private final Subscription subscription;
    private DragState dragSelection = DragState.NO_DRAG;
    private Optional<ParagraphBox.CaretOffsetX> targetCaretOffset = Optional.empty();
    private final Var<Point2D> autoscrollTo = Var.newSimpleVar(null);

    private void clearTargetCaretOffset() {
        this.targetCaretOffset = Optional.empty();
    }

    private ParagraphBox.CaretOffsetX getTargetCaretOffset() {
        if (!this.targetCaretOffset.isPresent()) {
            this.targetCaretOffset = Optional.of(this.view.getCaretOffsetX());
        }
        return this.targetCaretOffset.get();
    }

    public StyledTextAreaBehavior(StyledTextAreaVisual<?> visual) {
        this.area = (StyledTextArea)visual.getControl();
        this.visual = visual;
        this.view = visual.getNode();
        EventHandler<? super KeyEvent> keyPressedHandler = KEY_PRESSED_TEMPLATE.bind(this);
        EventHandler<? super KeyEvent> keyTypedHandler = KEY_TYPED_TEMPLATE.bind(this);
        EventHandlerHelper.installAfter(this.area.onKeyPressedProperty(), keyPressedHandler);
        EventHandlerHelper.installAfter(this.area.onKeyTypedProperty(), keyTypedHandler);
        this.subscription = Subscription.multi(EventStreams.eventsOf(this.area, MouseEvent.MOUSE_PRESSED).subscribe(this::mousePressed), EventStreams.eventsOf(this.area, MouseEvent.MOUSE_DRAGGED).subscribe(this::mouseDragged), EventStreams.eventsOf(this.area, MouseEvent.DRAG_DETECTED).subscribe(this::dragDetected), EventStreams.eventsOf(this.area, MouseEvent.MOUSE_RELEASED).subscribe(this::mouseReleased), () -> {
            EventHandlerHelper.remove(this.area.onKeyPressedProperty(), keyPressedHandler);
            EventHandlerHelper.remove(this.area.onKeyTypedProperty(), keyTypedHandler);
        });
        Val<Point2D> projection = Val.combine(this.autoscrollTo, this.view.layoutBoundsProperty(), StyledTextAreaBehavior::project);
        Val<Point2D> distance = Val.combine(this.autoscrollTo, projection, Point2D::subtract);
        EventStream<Point2D> deltas = EventStreams.nonNullValuesOf(distance).emitBothOnEach(EventStreams.animationFrames()).map(t -> t.map((ds, nanos) -> ds.multiply((double)nanos.longValue() / 1.0E8)));
        EventStreams.valuesOf(this.autoscrollTo).flatMap(p -> p == null ? EventStreams.never() : deltas).subscribe(ds -> {
            this.view.scrollBy((Point2D)ds);
            projection.ifPresent(this::dragTo);
        });
    }

    @Override
    public void dispose() {
        this.subscription.unsubscribe();
    }

    private void keyTyped(KeyEvent event) {
        String text = event.getCharacter();
        int n = text.length();
        if (n == 0) {
            return;
        }
        this.area.replaceSelection(text);
    }

    private static boolean isLegal(String text) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isISOControl(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void deleteBackward(KeyEvent ignore) {
        IndexRange selection = this.area.getSelection();
        if (selection.getLength() == 0) {
            this.area.deletePreviousChar();
        } else {
            this.area.replaceSelection("");
        }
    }

    private void deleteForward(KeyEvent ignore) {
        IndexRange selection = this.area.getSelection();
        if (selection.getLength() == 0) {
            this.area.deleteNextChar();
        } else {
            this.area.replaceSelection("");
        }
    }

    private void left(KeyEvent ignore) {
        IndexRange sel = this.area.getSelection();
        if (sel.getLength() == 0) {
            this.area.previousChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.area.moveTo(sel.getStart(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void right(KeyEvent ignore) {
        IndexRange sel = this.area.getSelection();
        if (sel.getLength() == 0) {
            this.area.nextChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.area.moveTo(sel.getEnd(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void selectLeft(KeyEvent ignore) {
        this.area.previousChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void selectRight(KeyEvent ignore) {
        this.area.nextChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void selectWord() {
        this.area.previousWord(NavigationActions.SelectionPolicy.CLEAR);
        this.area.nextWord(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void deletePrevWord(KeyEvent ignore) {
        int end = this.area.getCaretPosition();
        if (end > 0) {
            this.area.previousWord(NavigationActions.SelectionPolicy.CLEAR);
            int start = this.area.getCaretPosition();
            this.area.replaceText(start, end, "");
        }
    }

    private void deleteNextWord(KeyEvent ignore) {
        int start = this.area.getCaretPosition();
        if (start < this.area.getLength()) {
            this.area.nextWord(NavigationActions.SelectionPolicy.CLEAR);
            int end = this.area.getCaretPosition();
            this.area.replaceText(start, end, "");
        }
    }

    private void downLines(NavigationActions.SelectionPolicy selectionPolicy, int nLines) {
        TwoDimensional.Position targetLine;
        TwoDimensional.Position currentLine = this.view.currentLine();
        if (!currentLine.sameAs(targetLine = currentLine.offsetBy(nLines, TwoDimensional.Bias.Forward).clamp())) {
            CharacterHit hit = this.view.hit(this.getTargetCaretOffset(), targetLine);
            ((StyledTextArea)this.visual.getControl()).moveTo(hit.getInsertionIndex(), selectionPolicy);
        }
    }

    private void prevLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(selectionPolicy, -1);
    }

    private void nextLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(selectionPolicy, 1);
    }

    private void prevPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.view.showCaretAtBottom();
        CharacterHit hit = this.view.hit(this.getTargetCaretOffset(), 1.0);
        ((StyledTextArea)this.visual.getControl()).moveTo(hit.getInsertionIndex(), selectionPolicy);
    }

    private void nextPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.view.showCaretAtTop();
        CharacterHit hit = this.view.hit(this.getTargetCaretOffset(), this.view.getViewportHeight() - 1.0);
        ((StyledTextArea)this.visual.getControl()).moveTo(hit.getInsertionIndex(), selectionPolicy);
    }

    private void mousePressed(MouseEvent e) {
        if (this.area.isDisabled()) {
            return;
        }
        if (e.getButton() == MouseButton.PRIMARY) {
            this.area.requestFocus();
            CharacterHit hit = this.view.hit(e.getX(), e.getY());
            if (e.isShiftDown()) {
                this.area.moveTo(hit.getInsertionIndex(), isMac ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.ADJUST);
            } else {
                switch (e.getClickCount()) {
                    case 1: {
                        this.firstLeftPress(hit);
                        break;
                    }
                    case 2: {
                        this.selectWord();
                        break;
                    }
                    case 3: {
                        this.area.selectLine();
                        break;
                    }
                }
            }
            e.consume();
        }
    }

    private void firstLeftPress(CharacterHit hit) {
        this.clearTargetCaretOffset();
        IndexRange selection = this.area.getSelection();
        if (this.area.isEditable() && selection.getLength() != 0 && hit.getCharacterIndex().isPresent() && hit.getCharacterIndex().getAsInt() >= selection.getStart() && hit.getCharacterIndex().getAsInt() < selection.getEnd()) {
            this.dragSelection = DragState.POTENTIAL_DRAG;
        } else {
            this.dragSelection = DragState.NO_DRAG;
            this.area.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void dragDetected(MouseEvent e) {
        if (this.dragSelection == DragState.POTENTIAL_DRAG) {
            this.dragSelection = DragState.DRAG;
        }
        e.consume();
    }

    private void mouseDragged(MouseEvent e) {
        if (this.area.isDisabled()) {
            return;
        }
        if (e.getButton() != MouseButton.PRIMARY || e.isMiddleButtonDown() || e.isSecondaryButtonDown()) {
            return;
        }
        Point2D p = new Point2D(e.getX(), e.getY());
        if (this.view.getLayoutBounds().contains(p)) {
            this.dragTo(p);
            this.autoscrollTo.setValue(null);
        } else {
            this.autoscrollTo.setValue(p);
        }
        e.consume();
    }

    private void dragTo(Point2D p) {
        CharacterHit hit = this.view.hit(p.getX(), p.getY());
        if (this.dragSelection == DragState.DRAG || this.dragSelection == DragState.POTENTIAL_DRAG) {
            this.area.positionCaret(hit.getInsertionIndex());
        } else {
            this.area.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
        }
    }

    private void mouseReleased(MouseEvent e) {
        this.autoscrollTo.setValue(null);
        if (this.area.isDisabled()) {
            return;
        }
        switch (this.dragSelection) {
            case POTENTIAL_DRAG: {
                CharacterHit hit = this.view.hit(e.getX(), e.getY());
                this.area.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR);
                break;
            }
            case DRAG: {
                CharacterHit h = this.view.hit(e.getX(), e.getY());
                this.area.moveSelectedText(h.getInsertionIndex());
            }
        }
        this.dragSelection = DragState.NO_DRAG;
        e.consume();
    }

    private static Point2D project(Point2D p, Bounds bounds) {
        double x = StyledTextAreaBehavior.clamp(p.getX(), bounds.getMinX(), bounds.getMaxX());
        double y = StyledTextAreaBehavior.clamp(p.getY(), bounds.getMinY(), bounds.getMaxY());
        return new Point2D(x, y);
    }

    private static double clamp(double x, double min, double max) {
        return Math.min(Math.max(x, min), max);
    }

    static {
        String os = System.getProperty("os.name");
        isMac = os.startsWith("Mac");
        isWindows = os.startsWith("Windows");
        NavigationActions.SelectionPolicy selPolicy = isMac ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.ADJUST;
        EventHandlerTemplate<StyledTextAreaBehavior, Event> edits = EventHandlerTemplate.on(EventPattern.keyPressed(KeyCode.DELETE, new KeyCombination.Modifier[0])).act(StyledTextAreaBehavior::deleteForward).on(EventPattern.keyPressed(KeyCode.BACK_SPACE, new KeyCombination.Modifier[0])).act(StyledTextAreaBehavior::deleteBackward).on(EventPattern.keyPressed(KeyCode.DELETE, KeyCombination.SHORTCUT_DOWN)).act(StyledTextAreaBehavior::deleteNextWord).on(EventPattern.keyPressed(KeyCode.BACK_SPACE, KeyCombination.SHORTCUT_DOWN)).act(StyledTextAreaBehavior::deletePrevWord).on(EventPattern.keyPressed(KeyCode.CUT, new KeyCombination.Modifier[0])).act((b, e) -> b.area.cut()).on(EventPattern.keyPressed(KeyCode.X, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.cut()).on(EventPattern.keyPressed(KeyCode.DELETE, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.area.cut()).on(EventPattern.keyPressed(KeyCode.PASTE, new KeyCombination.Modifier[0])).act((b, e) -> b.area.paste()).on(EventPattern.keyPressed(KeyCode.V, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.paste()).on(EventPattern.keyPressed(KeyCode.INSERT, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.area.paste()).on(EventPattern.keyPressed(KeyCode.ENTER, new KeyCombination.Modifier[0])).act((b, e) -> b.area.replaceSelection("\n")).on(EventPattern.keyPressed(KeyCode.TAB, new KeyCombination.Modifier[0])).act((b, e) -> b.area.replaceSelection("\t")).on(EventPattern.keyPressed(KeyCode.Z, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.undo()).on(EventPattern.keyPressed(KeyCode.Y, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.redo()).on(EventPattern.keyPressed(KeyCode.Z, KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.area.redo()).create().onlyWhen(b -> b.area.isEditable());
        EventHandlerTemplate<StyledTextAreaBehavior, Event> verticalNavigation = EventHandlerTemplate.on(EventPattern.keyPressed(KeyCode.UP, new KeyCombination.Modifier[0])).act((b, e) -> b.prevLine(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.KP_UP, new KeyCombination.Modifier[0])).act((b, e) -> b.prevLine(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.DOWN, new KeyCombination.Modifier[0])).act((b, e) -> b.nextLine(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.KP_DOWN, new KeyCombination.Modifier[0])).act((b, e) -> b.nextLine(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.PAGE_UP, new KeyCombination.Modifier[0])).act((b, e) -> b.prevPage(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[0])).act((b, e) -> b.nextPage(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.UP, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.prevLine(NavigationActions.SelectionPolicy.ADJUST)).on(EventPattern.keyPressed(KeyCode.KP_UP, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.prevLine(NavigationActions.SelectionPolicy.ADJUST)).on(EventPattern.keyPressed(KeyCode.DOWN, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.nextLine(NavigationActions.SelectionPolicy.ADJUST)).on(EventPattern.keyPressed(KeyCode.KP_DOWN, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.nextLine(NavigationActions.SelectionPolicy.ADJUST)).on(EventPattern.keyPressed(KeyCode.PAGE_UP, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.prevPage(NavigationActions.SelectionPolicy.ADJUST)).on(EventPattern.keyPressed(KeyCode.PAGE_DOWN, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.nextPage(NavigationActions.SelectionPolicy.ADJUST)).create();
        EventHandlerTemplate<StyledTextAreaBehavior, Event> otherNavigation = EventHandlerTemplate.on(EventPattern.keyPressed(KeyCode.RIGHT, new KeyCombination.Modifier[0])).act(StyledTextAreaBehavior::right).on(EventPattern.keyPressed(KeyCode.KP_RIGHT, new KeyCombination.Modifier[0])).act(StyledTextAreaBehavior::right).on(EventPattern.keyPressed(KeyCode.LEFT, new KeyCombination.Modifier[0])).act(StyledTextAreaBehavior::left).on(EventPattern.keyPressed(KeyCode.KP_LEFT, new KeyCombination.Modifier[0])).act(StyledTextAreaBehavior::left).on(EventPattern.keyPressed(KeyCode.HOME, new KeyCombination.Modifier[0])).act((b, e) -> b.area.lineStart(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.END, new KeyCombination.Modifier[0])).act((b, e) -> b.area.lineEnd(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.nextWord(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.nextWord(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.previousWord(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.previousWord(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.start(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.end(NavigationActions.SelectionPolicy.CLEAR)).on(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHIFT_DOWN)).act(StyledTextAreaBehavior::selectRight).on(EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHIFT_DOWN)).act(StyledTextAreaBehavior::selectRight).on(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHIFT_DOWN)).act(StyledTextAreaBehavior::selectLeft).on(EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHIFT_DOWN)).act(StyledTextAreaBehavior::selectLeft).on(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.area.lineStart(selPolicy)).on(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHIFT_DOWN)).act((b, e) -> b.area.lineEnd(selPolicy)).on(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.start(selPolicy)).on(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.end(selPolicy)).on(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.previousWord(selPolicy)).on(EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.previousWord(selPolicy)).on(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.nextWord(selPolicy)).on(EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.nextWord(selPolicy)).on(EventPattern.keyPressed(KeyCode.A, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.selectAll()).create();
        EventHandlerTemplate<StyledTextAreaBehavior, Event> otherActions = EventHandlerTemplate.on(EventPattern.keyPressed(KeyCode.COPY, new KeyCombination.Modifier[0])).act((b, e) -> b.area.copy()).on(EventPattern.keyPressed(KeyCode.C, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.copy()).on(EventPattern.keyPressed(KeyCode.INSERT, KeyCombination.SHORTCUT_DOWN)).act((b, e) -> b.area.copy()).create();
        Predicate<KeyEvent> noControlKeys = e -> !e.isControlDown() && !e.isMetaDown() || isWindows && !e.isMetaDown() && (!e.isControlDown() || e.isAltDown());
        Predicate<KeyEvent> isChar = e -> e.getCode().isLetterKey() || e.getCode().isDigitKey() || e.getCode().isWhitespaceKey();
        EventHandlerTemplate<StyledTextAreaBehavior, Event> charPressConsumer = EventHandlerTemplate.on(EventPattern.keyPressed()).where(isChar.and(noControlKeys)).act((b, e) -> {}).create();
        KEY_PRESSED_TEMPLATE = edits.orElse(otherNavigation).ifConsumed((b, e) -> b.clearTargetCaretOffset()).orElse(verticalNavigation).orElse(otherActions).orElse(charPressConsumer);
        KEY_TYPED_TEMPLATE = EventHandlerTemplate.on(KeyEvent.KEY_TYPED).where(noControlKeys).where(e -> StyledTextAreaBehavior.isLegal(e.getCharacter())).act(StyledTextAreaBehavior::keyTyped).create().onlyWhen(b -> b.area.isEditable());
    }

    private static enum DragState {
        NO_DRAG,
        POTENTIAL_DRAG,
        DRAG;

    }
}

