/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.StyledText;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.skin.TextExt;
import org.fxmisc.richtext.skin.TextFlowExt;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class ParagraphText<S>
extends TextFlowExt {
    private final ObjectProperty<Paint> highlightTextFill = new SimpleObjectProperty((Object)Color.WHITE);
    private final Var<Integer> caretPosition = Var.newSimpleVar(0);
    private final Val<Integer> clampedCaretPosition;
    private final ObjectProperty<IndexRange> selection = new SimpleObjectProperty((Object)StyledTextArea.EMPTY_RANGE);
    private final Paragraph<S> paragraph;
    private final Path caretShape = new Path();
    private final Path selectionShape = new Path();
    private final List<Path> backgroundShapes = new ArrayList<Path>();
    private final Var<Boolean> caretVisible = Var.newSimpleVar(false);

    public ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    public Var<Integer> caretPositionProperty() {
        return this.caretPosition;
    }

    public void setCaretPosition(int pos) {
        this.caretPosition.setValue(pos);
    }

    public ObjectProperty<IndexRange> selectionProperty() {
        return this.selection;
    }

    public void setSelection(IndexRange sel) {
        this.selection.set((Object)sel);
    }

    public ParagraphText(Paragraph<S> par, BiConsumer<? super TextExt, S> applyStyle) {
        this.caretShape.visibleProperty().bind(this.caretVisible);
        this.paragraph = par;
        this.getStyleClass().add((Object)"paragraph-text");
        int parLen = this.paragraph.length();
        this.clampedCaretPosition = this.caretPosition.map(i -> Math.min(i, parLen));
        this.clampedCaretPosition.addListener((ChangeListener<Integer>)((ChangeListener)(obs, oldPos, newPos) -> this.requestLayout()));
        this.selection.addListener((obs, old, sel) -> this.requestLayout());
        Val<Double> leftInset = Val.map(this.insetsProperty(), ins -> ins.getLeft());
        Val<Double> topInset = Val.map(this.insetsProperty(), ins -> ins.getTop());
        this.selectionShape.setManaged(false);
        this.selectionShape.setFill((Paint)Color.DODGERBLUE);
        this.selectionShape.setStrokeWidth(0.0);
        this.selectionShape.layoutXProperty().bind(leftInset);
        this.selectionShape.layoutYProperty().bind(topInset);
        this.getChildren().add((Object)this.selectionShape);
        this.caretShape.getStyleClass().add((Object)"caret");
        this.caretShape.setManaged(false);
        this.caretShape.setStrokeWidth(1.0);
        this.caretShape.layoutXProperty().bind(leftInset);
        this.caretShape.layoutYProperty().bind(topInset);
        this.getChildren().add((Object)this.caretShape);
        for (StyledText<S> segment : par.getSegments()) {
            TextExt t = new TextExt(segment.toString());
            t.setTextOrigin(VPos.TOP);
            t.getStyleClass().add((Object)"text");
            applyStyle.accept(t, segment.getStyle());
            t.impl_selectionFillProperty().bind((ObservableValue)t.fillProperty());
            this.getChildren().add((Object)t);
            Path backgroundShape = new Path();
            backgroundShape.setManaged(false);
            backgroundShape.setStrokeWidth(0.0);
            backgroundShape.layoutXProperty().bind(leftInset);
            backgroundShape.layoutYProperty().bind(topInset);
            this.backgroundShapes.add(backgroundShape);
            this.getChildren().add(0, (Object)backgroundShape);
        }
    }

    public Paragraph<S> getParagraph() {
        return this.paragraph;
    }

    public Var<Boolean> caretVisibleProperty() {
        return this.caretVisible;
    }

    public ObjectProperty<Paint> highlightFillProperty() {
        return this.selectionShape.fillProperty();
    }

    public double getCaretOffsetX() {
        this.layout();
        Bounds bounds = this.caretShape.getLayoutBounds();
        return (bounds.getMinX() + bounds.getMaxX()) / 2.0;
    }

    public Bounds getCaretBounds() {
        this.layout();
        return this.caretShape.getBoundsInParent();
    }

    public Bounds getCaretBoundsOnScreen() {
        this.layout();
        Bounds localBounds = this.caretShape.getBoundsInLocal();
        return this.caretShape.localToScreen(localBounds);
    }

    public Optional<Bounds> getSelectionBoundsOnScreen() {
        if (((IndexRange)this.selection.get()).getLength() == 0) {
            return Optional.empty();
        }
        this.layout();
        Bounds localBounds = this.selectionShape.getBoundsInLocal();
        return Optional.of(this.selectionShape.localToScreen(localBounds));
    }

    public int currentLineIndex() {
        return this.getLineOfCharacter((Integer)this.clampedCaretPosition.getValue());
    }

    private void updateCaretShape() {
        Object[] shape = this.getCaretShape((Integer)this.clampedCaretPosition.getValue(), true);
        this.caretShape.getElements().setAll(shape);
    }

    private void updateSelectionShape() {
        int start = ((IndexRange)this.selection.get()).getStart();
        int end = ((IndexRange)this.selection.get()).getEnd();
        Object[] shape = this.getRangeShape(start, end);
        this.selectionShape.getElements().setAll(shape);
    }

    private void updateBackgroundShapes() {
        int index = 0;
        int start = 0;
        FilteredList nodeList = this.getChildren().filtered(node -> node instanceof TextExt);
        for (Node node2 : nodeList) {
            TextExt text = (TextExt)node2;
            Path backgroundShape = this.backgroundShapes.get(index++);
            int end = start + text.getText().length();
            Paint paint = (Paint)text.backgroundFillProperty().get();
            if (paint != null) {
                backgroundShape.setFill(paint);
                Object[] shape = this.getRangeShape(start, end);
                backgroundShape.getElements().setAll(shape);
            }
            start = end;
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.updateCaretShape();
        this.updateSelectionShape();
        this.updateBackgroundShapes();
    }
}

