/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.ReadOnlyStyledDocument;
import org.fxmisc.richtext.StyleSpan;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyleSpansBuilder;
import org.fxmisc.richtext.StyledDocument;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.TwoLevelNavigator;

abstract class StyledDocumentBase<S, L extends List<Paragraph<S>>>
implements StyledDocument<S> {
    protected final L paragraphs;
    protected final TwoLevelNavigator navigator;

    protected StyledDocumentBase(L paragraphs) {
        this.paragraphs = paragraphs;
        this.navigator = new TwoLevelNavigator(() -> paragraphs.size(), i -> ((Paragraph)paragraphs.get(i)).length() + (i == paragraphs.size() - 1 ? 0 : 1));
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int offset, TwoDimensional.Bias bias) {
        return this.navigator.offsetToPosition(offset, bias);
    }

    @Override
    public TwoDimensional.Position position(int row, int col) {
        return this.navigator.position(row, col);
    }

    @Override
    public String getText(IndexRange range) {
        return this.getText(range.getStart(), range.getEnd());
    }

    @Override
    public String getText(int start, int end) {
        return this.sub(start, end, Paragraph::toString, Paragraph::substring, pars -> String.join((CharSequence)"\n", pars));
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public char charAt(int index) {
        TwoDimensional.Position pos = this.offsetToPosition(index, TwoDimensional.Bias.Forward);
        return ((Paragraph)this.paragraphs.get(pos.getMajor())).charAt(pos.getMinor());
    }

    @Override
    public StyledDocument<S> subSequence(IndexRange range) {
        return this.subSequence(range.getStart(), range.getEnd());
    }

    @Override
    public StyledDocument<S> subSequence(int start, int end) {
        return this.sub(start, end, p -> p, (p, a, b) -> p.subSequence(a, b), pars -> new ReadOnlyStyledDocument(pars, ReadOnlyStyledDocument.ParagraphsPolicy.ADOPT));
    }

    @Override
    public StyledDocument<S> subDocument(int paragraphIndex) {
        return new ReadOnlyStyledDocument(Arrays.asList((Paragraph)this.paragraphs.get(paragraphIndex)), ReadOnlyStyledDocument.ParagraphsPolicy.ADOPT);
    }

    @Override
    public final StyledDocument<S> concat(StyledDocument<S> that) {
        List pars1 = this.getParagraphs();
        List<Paragraph<S>> pars2 = that.getParagraphs();
        int n1 = pars1.size();
        int n2 = pars2.size();
        ArrayList pars = new ArrayList(n1 + n2 - 1);
        pars.addAll(pars1.subList(0, n1 - 1));
        pars.add(pars1.get(n1 - 1).concat(pars2.get(0)));
        pars.addAll(pars2.subList(1, n2));
        return new ReadOnlyStyledDocument(pars, ReadOnlyStyledDocument.ParagraphsPolicy.ADOPT);
    }

    @Override
    public S getStyleOfChar(int index) {
        TwoDimensional.Position pos2D = this.navigator.offsetToPosition(index, TwoDimensional.Bias.Forward);
        int paragraph = pos2D.getMajor();
        int col = pos2D.getMinor();
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleOfChar(col);
    }

    @Override
    public S getStyleOfChar(int paragraph, int column) {
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleOfChar(column);
    }

    @Override
    public S getStyleAtPosition(int position) {
        TwoDimensional.Position pos2D = this.navigator.offsetToPosition(position, TwoDimensional.Bias.Forward);
        int paragraph = pos2D.getMajor();
        int col = pos2D.getMinor();
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleAtPosition(col);
    }

    @Override
    public S getStyleAtPosition(int paragraph, int position) {
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleAtPosition(position);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int position) {
        TwoDimensional.Position pos2D = this.navigator.offsetToPosition(position, TwoDimensional.Bias.Forward);
        int paragraph = pos2D.getMajor();
        int col = pos2D.getMinor();
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleRangeAtPosition(col);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int paragraph, int position) {
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleRangeAtPosition(position);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int from, int to) {
        TwoDimensional.Position start = this.offsetToPosition(from, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end = to == from ? start : start.offsetBy(to - from, TwoDimensional.Bias.Backward);
        int startParIdx = start.getMajor();
        int endParIdx = end.getMajor();
        int affectedPars = endParIdx - startParIdx + 1;
        ArrayList subSpans = new ArrayList(affectedPars);
        if (startParIdx == endParIdx) {
            Paragraph par = (Paragraph)this.paragraphs.get(startParIdx);
            subSpans.add(par.getStyleSpans(start.getMinor(), end.getMinor()));
        } else {
            Paragraph startPar = (Paragraph)this.paragraphs.get(startParIdx);
            subSpans.add(startPar.getStyleSpans(start.getMinor(), startPar.length() + 1));
            for (int i = startParIdx + 1; i < endParIdx; ++i) {
                Paragraph par = (Paragraph)this.paragraphs.get(i);
                subSpans.add(par.getStyleSpans(0, par.length() + 1));
            }
            Paragraph endPar = (Paragraph)this.paragraphs.get(endParIdx);
            subSpans.add(endPar.getStyleSpans(0, end.getMinor()));
        }
        int n = subSpans.stream().mapToInt(sr -> sr.getSpanCount()).sum();
        StyleSpansBuilder builder = new StyleSpansBuilder(n);
        for (StyleSpans styleSpans : subSpans) {
            for (StyleSpan span : styleSpans) {
                builder.add(span);
            }
        }
        return builder.create();
    }

    @Override
    public StyleSpans<S> getStyleSpans(int paragraph) {
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleSpans();
    }

    @Override
    public StyleSpans<S> getStyleSpans(int paragraph, int from, int to) {
        return ((Paragraph)this.paragraphs.get(paragraph)).getStyleSpans(from, to);
    }

    public final boolean equals(Object other) {
        if (other instanceof StyledDocument) {
            StyledDocument that = (StyledDocument)other;
            return Objects.equals(this.paragraphs, that.getParagraphs());
        }
        return false;
    }

    public final int hashCode() {
        return this.paragraphs.hashCode();
    }

    private <P, R> R sub(int start, int end, Function<Paragraph<S>, P> map, SubMap<Paragraph<S>, P> subMap, Function<List<P>, R> combine) {
        TwoDimensional.Position start2D = this.navigator.offsetToPosition(start, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end2D = end == start ? start2D : start2D.offsetBy(end - start, TwoDimensional.Bias.Forward);
        int p1 = start2D.getMajor();
        int col1 = start2D.getMinor();
        int p2 = end2D.getMajor();
        int col2 = end2D.getMinor();
        ArrayList<P> pars = new ArrayList<P>(p2 - p1 + 1);
        if (p1 == p2) {
            pars.add(subMap.subrange((Paragraph<S>)this.paragraphs.get(p1), col1, col2));
        } else {
            Paragraph par1 = (Paragraph)this.paragraphs.get(p1);
            pars.add(subMap.subrange(par1, col1, par1.length()));
            for (int i = p1 + 1; i < p2; ++i) {
                pars.add(map.apply((Paragraph<S>)this.paragraphs.get(i)));
            }
            pars.add(subMap.subrange((Paragraph<S>)this.paragraphs.get(p2), 0, col2));
        }
        return combine.apply(pars);
    }

    private static interface SubMap<A, B> {
        public B subrange(A var1, int var2, int var3);
    }
}

