/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import org.fxmisc.richtext.StyleSpan;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyleSpansBase;

public class StyleSpansBuilder<S> {
    private boolean created = false;
    private final ArrayList<StyleSpan<S>> spans;

    static <S> StyleSpans<S> overlay(StyleSpans<S> s1, StyleSpans<S> s2, BiFunction<? super S, ? super S, ? extends S> f) {
        StyleSpansBuilder<S> acc = new StyleSpansBuilder<S>(s1.getSpanCount() + s2.getSpanCount());
        Iterator<StyleSpan<S>> t1 = s1.iterator();
        Iterator<StyleSpan<S>> t2 = s2.iterator();
        StyleSpan<S> h1 = t1.next();
        StyleSpan<S> h2 = t2.next();
        while (true) {
            int len2;
            int len1;
            if ((len1 = h1.getLength()) == (len2 = h2.getLength())) {
                acc.add(f.apply(h1.getStyle(), h2.getStyle()), len1);
                if (!t1.hasNext()) {
                    return acc.addAll(t2).create();
                }
                if (!t2.hasNext()) {
                    return acc.addAll(t1).create();
                }
                h1 = t1.next();
                h2 = t2.next();
                continue;
            }
            if (len1 < len2) {
                acc.add(f.apply(h1.getStyle(), h2.getStyle()), len1);
                h2 = new StyleSpan<S>(h2.getStyle(), len2 - len1);
                if (t1.hasNext()) {
                    h1 = t1.next();
                    continue;
                }
                return acc.add(h2).addAll(t2).create();
            }
            acc.add(f.apply(h1.getStyle(), h2.getStyle()), len2);
            h1 = new StyleSpan<S>(h1.getStyle(), len1 - len2);
            if (!t2.hasNext()) break;
            h2 = t2.next();
        }
        return acc.add(h1).addAll(t1).create();
    }

    public StyleSpansBuilder(int initialCapacity) {
        this.spans = new ArrayList(initialCapacity);
    }

    public StyleSpansBuilder() {
        this.spans = new ArrayList();
    }

    public StyleSpansBuilder<S> add(StyleSpan<S> styleSpan) {
        this.ensureNotCreated();
        this._add(styleSpan);
        return this;
    }

    public StyleSpansBuilder<S> add(S style, int length) {
        return this.add(new StyleSpan<S>(style, length));
    }

    public StyleSpansBuilder<S> addAll(Collection<? extends StyleSpan<S>> styleSpans) {
        return this.addAll(styleSpans, styleSpans.size());
    }

    public StyleSpansBuilder<S> addAll(Iterable<? extends StyleSpan<S>> styleSpans, int sizeHint) {
        this.spans.ensureCapacity(this.spans.size() + sizeHint);
        return this.addAll(styleSpans);
    }

    public StyleSpansBuilder<S> addAll(Iterable<? extends StyleSpan<S>> styleSpans) {
        this.ensureNotCreated();
        for (StyleSpan<S> span : styleSpans) {
            this._add(span);
        }
        return this;
    }

    public StyleSpansBuilder<S> addAll(Iterator<? extends StyleSpan<S>> styleSpans) {
        this.ensureNotCreated();
        while (styleSpans.hasNext()) {
            this._add(styleSpans.next());
        }
        return this;
    }

    public StyleSpans<S> create() {
        this.ensureNotCreated();
        if (this.spans.isEmpty()) {
            throw new IllegalStateException("No spans have been added");
        }
        this.created = true;
        return new StyleSpansImpl<S>(Collections.unmodifiableList(this.spans));
    }

    private void _add(StyleSpan<S> span) {
        if (this.spans.isEmpty()) {
            this.spans.add(span);
        } else if (span.getLength() > 0) {
            if (this.spans.size() == 1 && this.spans.get(0).getLength() == 0) {
                this.spans.set(0, span);
            } else {
                StyleSpan<S> prev = this.spans.get(this.spans.size() - 1);
                if (prev.getStyle().equals(span.getStyle())) {
                    this.spans.set(this.spans.size() - 1, new StyleSpan<S>(span.getStyle(), prev.getLength() + span.getLength()));
                } else {
                    this.spans.add(span);
                }
            }
        }
    }

    private void ensureNotCreated() {
        if (this.created) {
            throw new IllegalStateException("Cannot reus StyleRangesBuilder after StyleRanges have been created.");
        }
    }

    private static class StyleSpansImpl<S>
    extends StyleSpansBase<S> {
        private final List<StyleSpan<S>> spans;
        private int length = -1;

        StyleSpansImpl(List<StyleSpan<S>> spans) {
            this.spans = spans;
        }

        @Override
        public Iterator<StyleSpan<S>> iterator() {
            return this.spans.iterator();
        }

        @Override
        public int length() {
            if (this.length == -1) {
                this.length = this.spans.stream().mapToInt(span -> span.getLength()).sum();
            }
            return this.length;
        }

        @Override
        public int getSpanCount() {
            return this.spans.size();
        }

        @Override
        public StyleSpan<S> getStyleSpan(int index) {
            return this.spans.get(index);
        }
    }
}

