/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.Codec;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.StyledDocument;
import org.fxmisc.richtext.StyledDocumentBase;
import org.fxmisc.richtext.StyledText;

public class ReadOnlyStyledDocument<S>
extends StyledDocumentBase<S, List<Paragraph<S>>> {
    private static final Pattern LINE_TERMINATOR = Pattern.compile("\r\n|\r|\n");
    private int length = -1;
    private String text = null;

    public static <S> ReadOnlyStyledDocument<S> fromString(String str, S style) {
        Matcher m = LINE_TERMINATOR.matcher(str);
        int n = 1;
        while (m.find()) {
            ++n;
        }
        ArrayList<Paragraph<S>> res = new ArrayList<Paragraph<S>>(n);
        int start = 0;
        m.reset();
        while (m.find()) {
            String s = str.substring(start, m.start());
            res.add(new Paragraph<S>(s, style));
            start = m.end();
        }
        String last = str.substring(start);
        res.add(new Paragraph<S>(last, style));
        return new ReadOnlyStyledDocument<S>(res, ParagraphsPolicy.ADOPT);
    }

    static <S> Codec<StyledDocument<S>> codec(final Codec<S> styleCodec) {
        return new Codec<StyledDocument<S>>(){
            private final Codec<List<Paragraph<S>>> codec;
            {
                this.codec = Codec.listCodec(ReadOnlyStyledDocument.paragraphCodec(styleCodec));
            }

            @Override
            public String getName() {
                return "application/richtextfx-styled-document<" + styleCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, StyledDocument<S> doc) throws IOException {
                this.codec.encode(os, doc.getParagraphs());
            }

            @Override
            public StyledDocument<S> decode(DataInputStream is) throws IOException {
                return new ReadOnlyStyledDocument(this.codec.decode(is), ParagraphsPolicy.ADOPT);
            }
        };
    }

    private static <S> Codec<Paragraph<S>> paragraphCodec(final Codec<S> styleCodec) {
        return new Codec<Paragraph<S>>(){
            private final Codec<List<StyledText<S>>> segmentsCodec;
            {
                this.segmentsCodec = Codec.listCodec(ReadOnlyStyledDocument.styledTextCodec(styleCodec));
            }

            @Override
            public String getName() {
                return "paragraph<" + styleCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, Paragraph<S> p) throws IOException {
                this.segmentsCodec.encode(os, p.getSegments());
            }

            @Override
            public Paragraph<S> decode(DataInputStream is) throws IOException {
                List segments = this.segmentsCodec.decode(is);
                return new Paragraph(segments);
            }
        };
    }

    private static <S> Codec<StyledText<S>> styledTextCodec(final Codec<S> styleCodec) {
        return new Codec<StyledText<S>>(){

            @Override
            public String getName() {
                return "styledtext<" + styleCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, StyledText<S> t) throws IOException {
                STRING_CODEC.encode(os, t.toString());
                styleCodec.encode(os, t.getStyle());
            }

            @Override
            public StyledText<S> decode(DataInputStream is) throws IOException {
                String text = (String)STRING_CODEC.decode(is);
                Object style = styleCodec.decode(is);
                return new StyledText(text, style);
            }
        };
    }

    ReadOnlyStyledDocument(List<Paragraph<S>> paragraphs, ParagraphsPolicy policy) {
        super(policy == ParagraphsPolicy.ADOPT ? paragraphs : new ArrayList(paragraphs));
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = this.computeLength();
        }
        return this.length;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.getText(0, this.length());
        }
        return this.text;
    }

    @Override
    public List<Paragraph<S>> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    private int computeLength() {
        return this.paragraphs.stream().mapToInt(Paragraph::length).sum() + this.paragraphs.size() - 1;
    }

    static enum ParagraphsPolicy {
        ADOPT,
        COPY;

    }
}

