/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.IntFunction;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import org.fxmisc.richtext.StyledTextArea;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;

public class LineNumberFactory
implements IntFunction<Node> {
    private static final Insets DEFAULT_INSETS = new Insets(0.0, 5.0, 0.0, 5.0);
    private static final Paint DEFAULT_TEXT_FILL = Color.web((String)"#666");
    private static final Font DEFAULT_FONT = Font.font((String)"monospace", (FontPosture)FontPosture.ITALIC, (double)13.0);
    private static final Background DEFAULT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#ddd"), null, null)});
    private final Val<Integer> nParagraphs;
    private final IntFunction<String> format;

    public static IntFunction<Node> get(StyledTextArea<?> area) {
        return LineNumberFactory.get(area, digits -> "%0" + digits + "d");
    }

    public static IntFunction<Node> get(StyledTextArea<?> area, IntFunction<String> format) {
        return new LineNumberFactory(area, format);
    }

    private LineNumberFactory(StyledTextArea<?> area, IntFunction<String> format) {
        this.nParagraphs = LiveList.sizeOf(area.getParagraphs());
        this.format = format;
    }

    @Override
    public Node apply(int idx) {
        Val<String> formatted = this.nParagraphs.map(n -> this.format(idx + 1, (int)n));
        Label lineNo = new Label();
        lineNo.setFont(DEFAULT_FONT);
        lineNo.setBackground(DEFAULT_BACKGROUND);
        lineNo.setTextFill(DEFAULT_TEXT_FILL);
        lineNo.setPadding(DEFAULT_INSETS);
        lineNo.getStyleClass().add((Object)"lineno");
        lineNo.textProperty().bind(formatted.conditionOnShowing((Node)lineNo));
        return lineNo;
    }

    private String format(int x, int max) {
        int digits = (int)Math.floor(Math.log10(max)) + 1;
        return String.format(this.format.apply(digits), x);
    }
}

