/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.HorizontalHelper;
import org.fxmisc.flowless.OrientationHelper;
import org.fxmisc.flowless.VerticalHelper;
import org.fxmisc.flowless.VirtualFlowContent;
import org.fxmisc.flowless.VirtualFlowHit;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class VirtualFlow<T, C extends Cell<T, ?>>
extends Region {
    private final ScrollBar hbar;
    private final ScrollBar vbar;
    private final VirtualFlowContent<T, C> content;

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createHorizontal(ObservableList<T> items, Function<? super T, ? extends C> cellFactory) {
        return VirtualFlow.createHorizontal(items, cellFactory, Gravity.FRONT);
    }

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createHorizontal(ObservableList<T> items, Function<? super T, ? extends C> cellFactory, Gravity gravity) {
        return new VirtualFlow<T, C>(items, cellFactory, new HorizontalHelper(), gravity);
    }

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createVertical(ObservableList<T> items, Function<? super T, ? extends C> cellFactory) {
        return VirtualFlow.createVertical(items, cellFactory, Gravity.FRONT);
    }

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createVertical(ObservableList<T> items, Function<? super T, ? extends C> cellFactory, Gravity gravity) {
        return new VirtualFlow<T, C>(items, cellFactory, new VerticalHelper(), gravity);
    }

    private VirtualFlow(ObservableList<T> items, Function<? super T, ? extends C> cellFactory, OrientationHelper orientation, Gravity gravity) {
        this.getStyleClass().add((Object)"virtual-flow");
        this.content = new VirtualFlowContent<T, C>(items, cellFactory, orientation, gravity);
        this.hbar = new ScrollBar();
        this.vbar = new ScrollBar();
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.hbar.setMin(0.0);
        this.vbar.setMin(0.0);
        this.hbar.maxProperty().bind(orientation.widthEstimateProperty(this.content));
        this.vbar.maxProperty().bind(orientation.heightEstimateProperty(this.content));
        VirtualFlow.setupUnitIncrement(this.hbar);
        VirtualFlow.setupUnitIncrement(this.vbar);
        this.hbar.blockIncrementProperty().bind((ObservableValue)this.hbar.visibleAmountProperty());
        this.vbar.blockIncrementProperty().bind((ObservableValue)this.vbar.visibleAmountProperty());
        Bindings.bindBidirectional(Var.doubleVar(this.hbar.valueProperty()), orientation.horizontalPositionProperty(this.content));
        Bindings.bindBidirectional(Var.doubleVar(this.vbar.valueProperty()), orientation.verticalPositionProperty(this.content));
        this.addEventHandler(ScrollEvent.SCROLL, se -> {
            this.scrollX(-se.getDeltaX());
            this.scrollY(-se.getDeltaY());
            se.consume();
        });
        Val<Double> layoutWidth = Val.map(this.layoutBoundsProperty(), Bounds::getWidth);
        Val<Double> layoutHeight = Val.map(this.layoutBoundsProperty(), Bounds::getHeight);
        Val<Boolean> needsHBar0 = Val.combine(orientation.widthEstimateProperty(this.content), layoutWidth, (cw, lw) -> cw > lw);
        Val<Boolean> needsVBar0 = Val.combine(orientation.heightEstimateProperty(this.content), layoutHeight, (ch, lh) -> ch > lh);
        Val<Boolean> needsHBar = Val.combine(needsHBar0, needsVBar0, orientation.widthEstimateProperty(this.content), this.vbar.widthProperty(), layoutWidth, (needsH, needsV, cw, vbw, lw) -> needsH != false || needsV != false && cw + vbw.doubleValue() > lw);
        Val<Boolean> needsVBar = Val.combine(needsVBar0, needsHBar0, orientation.heightEstimateProperty(this.content), this.hbar.heightProperty(), layoutHeight, (needsV, needsH, ch, hbh, lh) -> needsV != false || needsH != false && ch + hbh.doubleValue() > lh);
        this.hbar.visibleProperty().bind(needsHBar);
        this.vbar.visibleProperty().bind(needsVBar);
        this.hbar.visibleProperty().addListener(obs -> Platform.runLater(() -> this.requestLayout()));
        this.vbar.visibleProperty().addListener(obs -> Platform.runLater(() -> this.requestLayout()));
        this.getChildren().addAll((Object[])new Node[]{this.content, this.hbar, this.vbar});
    }

    public void dispose() {
        this.content.dispose();
    }

    public Orientation getContentBias() {
        return this.content.getContentBias();
    }

    public double getViewportWidth() {
        return this.content.getWidth();
    }

    public double getViewportHeight() {
        return this.content.getHeight();
    }

    public ReadOnlyDoubleProperty breadthOffsetProperty() {
        return this.content.breadthOffsetProperty();
    }

    public Bounds cellToViewport(C cell, Bounds bounds) {
        return cell.getNode().localToParent(bounds);
    }

    public Point2D cellToViewport(C cell, Point2D point) {
        return cell.getNode().localToParent(point);
    }

    public Point2D cellToViewport(C cell, double x, double y) {
        return cell.getNode().localToParent(x, y);
    }

    public void show(int index) {
        this.content.show(index);
    }

    public void show(double primaryAxisOffset) {
        this.content.show(primaryAxisOffset);
    }

    public void showAsFirst(int itemIndex) {
        this.content.showAsFirst(itemIndex);
    }

    public void showAsLast(int itemIndex) {
        this.content.showAsLast(itemIndex);
    }

    public void showAtOffset(int itemIndex, double offset) {
        this.content.showAtOffset(itemIndex, offset);
    }

    public void show(int itemIndex, Bounds region) {
        this.content.showRegion(itemIndex, region);
    }

    public void scrollX(double deltaX) {
        this.content.scrollX(deltaX);
    }

    public void scrollY(double deltaY) {
        this.content.scrollY(deltaY);
    }

    public C getCell(int itemIndex) {
        return this.content.getCellFor(itemIndex);
    }

    public Optional<C> getCellIfVisible(int itemIndex) {
        return this.content.getCellIfVisible(itemIndex);
    }

    public ObservableList<C> visibleCells() {
        return this.content.visibleCells();
    }

    public VirtualFlowHit<C> hit(double x, double y) {
        return this.content.hit(x, y);
    }

    protected double computePrefWidth(double height) {
        return this.content.prefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return this.content.prefHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.vbar.minWidth(-1.0);
    }

    protected double computeMinHeight(double width) {
        return this.hbar.minHeight(-1.0);
    }

    protected double computeMaxWidth(double height) {
        return this.content.maxWidth(height);
    }

    protected double computeMaxHeight(double width) {
        return this.content.maxHeight(width);
    }

    protected void layoutChildren() {
        double layoutWidth = this.getLayoutBounds().getWidth();
        double layoutHeight = this.getLayoutBounds().getHeight();
        boolean vbarVisible = this.vbar.isVisible();
        boolean hbarVisible = this.hbar.isVisible();
        double vbarWidth = vbarVisible ? this.vbar.prefWidth(-1.0) : 0.0;
        double hbarHeight = hbarVisible ? this.hbar.prefHeight(-1.0) : 0.0;
        double w = layoutWidth - vbarWidth;
        double h = layoutHeight - hbarHeight;
        this.content.resize(w, h);
        this.hbar.setVisibleAmount(w);
        this.vbar.setVisibleAmount(h);
        if (vbarVisible) {
            this.vbar.resizeRelocate(layoutWidth - vbarWidth, 0.0, vbarWidth, h);
        }
        if (hbarVisible) {
            this.hbar.resizeRelocate(0.0, layoutHeight - hbarHeight, w, hbarHeight);
        }
    }

    private static void setupUnitIncrement(final ScrollBar bar) {
        bar.unitIncrementProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{bar.maxProperty(), bar.visibleAmountProperty()});
            }

            protected double computeValue() {
                double visible;
                double max = bar.getMax();
                return max > (visible = bar.getVisibleAmount()) ? 16.0 / (max - visible) * max : 0.0;
            }
        });
    }

    public static enum Gravity {
        FRONT,
        REAR;

    }
}

