/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import org.fxmisc.flowless.Offset;
import org.fxmisc.flowless.StartOffStart;
import org.fxmisc.flowless.TargetPosition;
import org.fxmisc.flowless.TargetPositionVisitor;

final class MinDistanceTo
implements TargetPosition {
    final int itemIndex;
    final Offset minY;
    final Offset maxY;

    MinDistanceTo(int itemIndex, Offset minY, Offset maxY) {
        this.itemIndex = itemIndex;
        this.minY = minY;
        this.maxY = maxY;
    }

    public MinDistanceTo(int itemIndex) {
        this(itemIndex, Offset.fromStart(0.0), Offset.fromEnd(0.0));
    }

    @Override
    public TargetPosition transformByChange(int pos, int removedSize, int addedSize) {
        if (this.itemIndex >= pos + removedSize) {
            return new MinDistanceTo(this.itemIndex - removedSize + addedSize, this.minY, this.maxY);
        }
        if (this.itemIndex >= pos) {
            return new MinDistanceTo(pos, Offset.fromStart(0.0), Offset.fromEnd(0.0));
        }
        return this;
    }

    @Override
    public TargetPosition scrollBy(double delta) {
        return new MinDistanceTo(this.itemIndex, this.minY.add(delta), this.maxY.add(delta));
    }

    @Override
    public void accept(TargetPositionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public TargetPosition clamp(int size) {
        return new MinDistanceTo(StartOffStart.clamp(this.itemIndex, size), this.minY, this.maxY);
    }
}

