/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.usb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.kura.net.modem.ModemDevice;
import org.eclipse.kura.usb.AbstractUsbDevice;

public class UsbModemDevice
extends AbstractUsbDevice
implements ModemDevice {
    private ArrayList<String> m_ttyDevs = new ArrayList();
    private ArrayList<String> m_blockDevs = new ArrayList();

    public UsbModemDevice(String vendorId, String productId, String manufacturerName, String productName, String usbBusNumber, String usbDevicePath) {
        super(vendorId, productId, manufacturerName, productName, usbBusNumber, usbDevicePath);
    }

    public UsbModemDevice(AbstractUsbDevice usbDevice) {
        super(usbDevice);
    }

    @Override
    public List<String> getSerialPorts() {
        return Collections.unmodifiableList(this.m_ttyDevs);
    }

    public List<String> getTtyDevs() {
        return Collections.unmodifiableList(this.m_ttyDevs);
    }

    public List<String> getBlockDevs() {
        return Collections.unmodifiableList(this.m_blockDevs);
    }

    public void addTtyDev(String ttyDev) {
        if (!this.m_ttyDevs.contains(ttyDev)) {
            this.m_ttyDevs.add(ttyDev);
            Collections.sort(this.m_ttyDevs, new DevNameComparator());
        }
    }

    public void addBlockDev(String blockDev) {
        if (!this.m_blockDevs.contains(blockDev)) {
            this.m_blockDevs.add(blockDev);
            Collections.sort(this.m_blockDevs, new DevNameComparator());
        }
    }

    public boolean removeTtyDev(String ttyDev) {
        return this.m_ttyDevs.remove(ttyDev);
    }

    public boolean removeBlockDev(String blockDev) {
        return this.m_blockDevs.remove(blockDev);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.m_ttyDevs == null ? 0 : this.m_ttyDevs.hashCode());
        result = 37 * result + (this.m_blockDevs == null ? 0 : this.m_blockDevs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsbModemDevice other = (UsbModemDevice)obj;
        if (this.m_ttyDevs == null ? other.m_ttyDevs != null : !this.m_ttyDevs.equals(other.m_ttyDevs)) {
            return false;
        }
        return !(this.m_blockDevs == null ? other.m_blockDevs != null : !this.m_blockDevs.equals(other.m_blockDevs));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("UsbModem [");
        sb.append("vendorId=").append(this.getVendorId());
        sb.append(", productId=").append(this.getProductId());
        sb.append(", manufName=").append(this.getManufacturerName());
        sb.append(", productName=").append(this.getProductName());
        sb.append(", usbPort=").append(this.getUsbPort());
        sb.append(", ttyDevs=").append(this.m_ttyDevs.toString());
        sb.append(", blockDevs=").append(this.m_blockDevs.toString());
        sb.append("]");
        return sb.toString();
    }

    private class DevNameComparator
    implements Comparator<String> {
        private DevNameComparator() {
        }

        @Override
        public int compare(String dev1, String dev2) {
            int digitPos1 = this.getDigitPosition(dev1);
            int digitPos2 = this.getDigitPosition(dev2);
            String text1 = dev1.substring(0, digitPos1);
            String text2 = dev2.substring(0, digitPos2);
            String num1 = dev1.substring(digitPos1, dev1.length());
            String num2 = dev2.substring(digitPos2, dev2.length());
            int textCompare = text1.compareTo(text2);
            if (textCompare != 0) {
                return textCompare;
            }
            if (num1 == null || num1.isEmpty()) {
                if (num2 == null || num2.isEmpty()) {
                    return 0;
                }
                return -1;
            }
            if (num2 == null || num2.isEmpty()) {
                return 1;
            }
            Integer int1 = Integer.parseInt(num1);
            Integer int2 = Integer.parseInt(num2);
            return int1.compareTo(int2);
        }

        private int getDigitPosition(String devName) {
            int pos = devName.length();
            int i = devName.length() - 1;
            while (i >= 0) {
                if (!Character.isDigit(devName.charAt(i))) break;
                pos = i--;
            }
            return pos;
        }
    }
}

