/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetInterfaceStatus;

public abstract class NetConfigIP<T extends IPAddress>
implements NetConfig {
    private NetInterfaceStatus m_status;
    private boolean m_autoConnect;
    private boolean m_dhcp;
    private T m_address;
    private short m_networkPrefixLength;
    private T m_subnetMask;
    private T m_gateway;
    private List<T> m_dnsServers;
    private List<String> m_domains;
    private Map<String, Object> m_properties;

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect) {
        this.m_status = status;
        this.m_autoConnect = autoConnect;
        this.m_dhcp = false;
        this.m_address = null;
        this.m_networkPrefixLength = (short)-1;
        this.m_subnetMask = null;
        this.m_gateway = null;
        this.m_dnsServers = new ArrayList<T>();
        this.m_domains = new ArrayList<String>();
        this.m_properties = new HashMap<String, Object>();
    }

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect, boolean dhcp) {
        this.m_status = status;
        this.m_autoConnect = autoConnect;
        this.m_dhcp = dhcp;
        this.m_address = null;
        this.m_networkPrefixLength = (short)-1;
        this.m_subnetMask = null;
        this.m_gateway = null;
        this.m_dnsServers = new ArrayList<T>();
        this.m_domains = new ArrayList<String>();
        this.m_properties = new HashMap<String, Object>();
    }

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect, T address, short networkPrefixLength, T gateway) throws KuraException {
        this.m_status = status;
        this.m_autoConnect = autoConnect;
        this.m_dhcp = false;
        this.m_address = address;
        this.m_networkPrefixLength = networkPrefixLength;
        this.m_subnetMask = this.calculateNetmaskFromNetworkPrefix(networkPrefixLength);
        this.m_gateway = gateway;
        this.m_dnsServers = new ArrayList<T>();
        this.m_domains = new ArrayList<String>();
        this.m_properties = new HashMap<String, Object>();
    }

    NetConfigIP(NetInterfaceStatus status, boolean autoConnect, T address, T subnetMask, T gateway) throws KuraException {
        this.m_status = status;
        this.m_autoConnect = autoConnect;
        this.m_dhcp = false;
        this.m_address = address;
        this.m_networkPrefixLength = this.calculateNetworkPrefixFromNetmask(((IPAddress)subnetMask).getHostAddress());
        this.m_subnetMask = subnetMask;
        this.m_gateway = gateway;
        this.m_dnsServers = new ArrayList<T>();
        this.m_domains = new ArrayList<String>();
        this.m_properties = new HashMap<String, Object>();
    }

    public NetInterfaceStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(NetInterfaceStatus status) {
        this.m_status = status;
    }

    public boolean isAutoConnect() {
        return this.m_autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.m_autoConnect = autoConnect;
    }

    public boolean isDhcp() {
        return this.m_dhcp;
    }

    public void setDhcp(boolean dhcp) {
        this.m_dhcp = dhcp;
    }

    public T getAddress() {
        return this.m_address;
    }

    public void setAddress(T address) throws KuraException {
        this.m_address = address;
    }

    public short getNetworkPrefixLength() {
        return this.m_networkPrefixLength;
    }

    public void setNetworkPrefixLength(short networkPrefixLength) throws KuraException {
        this.m_networkPrefixLength = networkPrefixLength;
        this.m_subnetMask = this.calculateNetmaskFromNetworkPrefix(networkPrefixLength);
    }

    public T getSubnetMask() {
        return this.m_subnetMask;
    }

    public void setSubnetMask(T subnetMask) throws KuraException {
        this.m_networkPrefixLength = this.calculateNetworkPrefixFromNetmask(((IPAddress)subnetMask).getHostAddress());
        this.m_subnetMask = subnetMask;
    }

    public T getGateway() {
        return this.m_gateway;
    }

    public void setGateway(T gateway) {
        this.m_gateway = gateway;
    }

    public List<T> getDnsServers() {
        if (this.m_dnsServers != null) {
            return Collections.unmodifiableList(this.m_dnsServers);
        }
        return null;
    }

    public void setDnsServers(List<T> dnsServers) {
        this.m_dnsServers = dnsServers;
    }

    public List<String> getDomains() {
        if (this.m_domains != null) {
            return Collections.unmodifiableList(this.m_domains);
        }
        return null;
    }

    public void setDomains(List<String> domains) {
        this.m_domains = domains;
    }

    public Map<String, Object> getProperties() {
        if (this.m_properties != null) {
            return Collections.unmodifiableMap(this.m_properties);
        }
        return null;
    }

    public void setProperties(Map<String, Object> properties) {
        this.m_properties = properties;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_address == null ? 0 : ((IPAddress)this.m_address).hashCode());
        result = 31 * result + (this.m_autoConnect ? 1231 : 1237);
        result = 31 * result + (this.m_dhcp ? 1231 : 1237);
        result = 31 * result + (this.m_dnsServers == null ? 0 : this.m_dnsServers.hashCode());
        result = 31 * result + (this.m_domains == null ? 0 : this.m_domains.hashCode());
        result = 31 * result + (this.m_gateway == null ? 0 : ((IPAddress)this.m_gateway).hashCode());
        result = 31 * result + this.m_networkPrefixLength;
        result = 31 * result + (this.m_properties == null ? 0 : this.m_properties.hashCode());
        result = 31 * result + (this.m_status == null ? 0 : this.m_status.hashCode());
        result = 31 * result + (this.m_subnetMask == null ? 0 : ((IPAddress)this.m_subnetMask).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetConfigIP other = (NetConfigIP)obj;
        if (this.m_address == null ? other.m_address != null : !((IPAddress)this.m_address).equals(other.m_address)) {
            return false;
        }
        if (this.m_autoConnect != other.m_autoConnect) {
            return false;
        }
        if (this.m_dhcp != other.m_dhcp) {
            return false;
        }
        if (this.m_dnsServers == null ? other.m_dnsServers != null : !this.m_dnsServers.equals(other.m_dnsServers)) {
            return false;
        }
        if (this.m_domains == null ? other.m_domains != null : !this.m_domains.equals(other.m_domains)) {
            return false;
        }
        if (this.m_gateway == null ? other.m_gateway != null : !((IPAddress)this.m_gateway).equals(other.m_gateway)) {
            return false;
        }
        if (this.m_networkPrefixLength != other.m_networkPrefixLength) {
            return false;
        }
        if (this.m_properties == null ? other.m_properties != null : !this.m_properties.equals(other.m_properties)) {
            return false;
        }
        if (this.m_status != other.m_status) {
            return false;
        }
        return !(this.m_subnetMask == null ? other.m_subnetMask != null : !((IPAddress)this.m_subnetMask).equals(other.m_subnetMask));
    }

    @Override
    public boolean isValid() {
        if (this.m_dhcp) {
            return true;
        }
        try {
            ((IPAddress)this.m_address).getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        for (IPAddress dns : this.m_dnsServers) {
            try {
                dns.getHostAddress();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NetConfigIP [m_status=");
        builder.append((Object)this.m_status);
        builder.append(", m_autoConnect=");
        builder.append(this.m_autoConnect);
        builder.append(", m_dhcp=");
        builder.append(this.m_dhcp);
        builder.append(", m_address=");
        builder.append(this.m_address);
        builder.append(", m_networkPrefixLength=");
        builder.append(this.m_networkPrefixLength);
        builder.append(", m_subnetMask=");
        builder.append(this.m_subnetMask);
        builder.append(", m_gateway=");
        builder.append(this.m_gateway);
        builder.append(", m_dnsServers=");
        builder.append(this.m_dnsServers);
        builder.append(", m_domains=");
        builder.append(this.m_domains);
        builder.append(", m_properties=");
        builder.append(this.m_properties);
        builder.append("]");
        return builder.toString();
    }

    private short calculateNetworkPrefixFromNetmask(String netmask) throws KuraException {
        if (netmask == null) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, "netmask is null");
        }
        int netmaskValue = 0;
        StringTokenizer st = new StringTokenizer(netmask, ".");
        int i = 24;
        while (i >= 0) {
            netmaskValue |= Integer.parseInt(st.nextToken()) << i;
            i -= 8;
        }
        boolean hitZero = false;
        int displayMask = Integer.MIN_VALUE;
        int count = 0;
        int c = 1;
        while (c <= 32) {
            if ((netmaskValue & displayMask) == 0) {
                hitZero = true;
            } else {
                if (hitZero) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR, "received invalid mask: " + netmask);
                }
                ++count;
            }
            netmaskValue <<= 1;
            ++c;
        }
        return (short)count;
    }

    private T calculateNetmaskFromNetworkPrefix(int networkPrefixLength) throws KuraException {
        int mask = ~((1 << 32 - networkPrefixLength) - 1);
        StringBuffer sb = new StringBuffer(15);
        int shift = 24;
        while (shift > 0) {
            sb.append(Integer.toString(mask >>> shift & 0xFF));
            sb.append('.');
            shift -= 8;
        }
        sb.append(Integer.toString(mask & 0xFF));
        try {
            IPAddress netmask = IPAddress.parseHostAddress(sb.toString());
            return (T)netmask;
        }
        catch (UnknownHostException e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
    }
}

