/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.util.Map;

class SslManagerServiceOptions {
    static final String PROP_PROTOCOL = "ssl.default.protocol";
    static final String PROP_TRUST_STORE = "ssl.default.trustStore";
    static final String PROP_CIPHERS = "ssl.default.cipherSuites";
    static final String PROP_HN_VERIFY = "ssl.hostname.verification";
    static final String PROP_TRUST_PASSWORD = "ssl.keystore.password";
    static final String PROP_DEFAULT_PROTOCOL = "TLSv1";
    static final Boolean PROP_DEFAULT_HN_VERIFY = true;
    static final String PROP_DEFAULT_TRUST_PASSWORD = "changeit";
    private Map<String, Object> m_properties;

    SslManagerServiceOptions(Map<String, Object> properties) {
        this.m_properties = properties;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.m_properties;
    }

    public String getSslProtocol() {
        if (this.m_properties != null && this.m_properties.get(PROP_PROTOCOL) != null && this.m_properties.get(PROP_PROTOCOL) instanceof String) {
            return (String)this.m_properties.get(PROP_PROTOCOL);
        }
        return PROP_DEFAULT_PROTOCOL;
    }

    public String getSslKeyStore() {
        if (this.m_properties != null && this.m_properties.get(PROP_TRUST_STORE) != null && this.m_properties.get(PROP_TRUST_STORE) instanceof String) {
            return (String)this.m_properties.get(PROP_TRUST_STORE);
        }
        return null;
    }

    public String getSslCiphers() {
        if (this.m_properties != null && this.m_properties.get(PROP_CIPHERS) != null && this.m_properties.get(PROP_CIPHERS) instanceof String) {
            return (String)this.m_properties.get(PROP_CIPHERS);
        }
        return null;
    }

    public String getSslKeystorePassword() {
        if (this.m_properties != null && this.m_properties.get(PROP_TRUST_PASSWORD) != null && this.m_properties.get(PROP_TRUST_PASSWORD) instanceof String) {
            return (String)this.m_properties.get(PROP_TRUST_PASSWORD);
        }
        return PROP_DEFAULT_TRUST_PASSWORD;
    }

    public Boolean isSslHostnameVerification() {
        if (this.m_properties != null && this.m_properties.get(PROP_HN_VERIFY) != null && this.m_properties.get(PROP_HN_VERIFY) instanceof Boolean) {
            return (Boolean)this.m_properties.get(PROP_HN_VERIFY);
        }
        return PROP_DEFAULT_HN_VERIFY;
    }
}

