/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.linux.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.kura.core.linux.util.ProcessStats;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.core.util.SafeProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxProcessUtil {
    private static final Logger s_logger;
    private static String s_platform;

    static {
        block12: {
            s_logger = LoggerFactory.getLogger(LinuxProcessUtil.class);
            s_platform = null;
            String uriSpec = System.getProperty("kura.configuration");
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    URI uri = new URI(uriSpec);
                    fis = new FileInputStream(new File(uri));
                    props.load(fis);
                    s_platform = props.getProperty("kura.platform");
                }
                catch (Exception e) {
                    s_logger.error("Failed to obtain platform information - {}", e);
                    if (fis == null) break block12;
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static int start(String command, boolean wait, boolean background) throws Exception {
        SafeProcess proc;
        block9: {
            int n;
            block10: {
                proc = null;
                try {
                    s_logger.info("executing: " + command);
                    proc = ProcessUtil.exec(command);
                    if (!wait) break block9;
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    s_logger.info(String.valueOf(command) + " returned with exit value:" + proc.exitValue());
                    if (proc.exitValue() > 0) {
                        String stdout = LinuxProcessUtil.getInputStreamAsString(proc.getInputStream());
                        String stderr = LinuxProcessUtil.getInputStreamAsString(proc.getErrorStream());
                        s_logger.debug("stdout: " + stdout);
                        s_logger.debug("stderr: " + stderr);
                    }
                    n = proc.exitValue();
                    if (background || proc == null) break block10;
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (!background && proc != null) {
                            ProcessUtil.destroy(proc);
                        }
                        throw throwable;
                    }
                }
                ProcessUtil.destroy(proc);
            }
            return n;
        }
        if (!background && proc != null) {
            ProcessUtil.destroy(proc);
        }
        return 0;
    }

    public static int start(String command) throws Exception {
        return LinuxProcessUtil.start(command, true, false);
    }

    public static int start(String command, boolean wait) throws Exception {
        return LinuxProcessUtil.start(command, wait, false);
    }

    public static int start(String[] command, boolean wait) throws Exception {
        StringBuilder cmdBuilder = new StringBuilder();
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            cmdBuilder.append(cmd).append(' ');
            ++n2;
        }
        return LinuxProcessUtil.start(cmdBuilder.toString(), wait);
    }

    public static int startBackground(String command, boolean wait) throws Exception {
        return LinuxProcessUtil.start(command, wait, true);
    }

    public static ProcessStats startWithStats(String command) throws Exception {
        SafeProcess proc = null;
        s_logger.info("executing: " + command);
        proc = ProcessUtil.exec(command);
        try {
            int exitVal = proc.waitFor();
            s_logger.info(String.valueOf(command) + " returned with exit value:" + exitVal);
        }
        catch (InterruptedException e) {
            s_logger.error("error executing " + command + " command" + e);
        }
        ProcessStats stats = new ProcessStats(proc);
        return stats;
    }

    public static ProcessStats startWithStats(String[] command) throws Exception {
        SafeProcess proc = null;
        StringBuilder cmdBuilder = new StringBuilder();
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            cmdBuilder.append(cmd).append(' ');
            ++n2;
        }
        s_logger.debug("executing: " + cmdBuilder);
        proc = ProcessUtil.exec(command);
        try {
            int exitVal = proc.waitFor();
            s_logger.debug(cmdBuilder + " returned with exit value:" + exitVal);
        }
        catch (InterruptedException e) {
            s_logger.error("error executing " + command + " command" + e);
        }
        ProcessStats stats = new ProcessStats(proc);
        return stats;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPid(String command) throws Exception {
        int n;
        BufferedReader br;
        SafeProcess proc;
        block10: {
            StringTokenizer st = null;
            String line = null;
            String pid = null;
            proc = null;
            br = null;
            if (command == null) return -1;
            if (command.isEmpty()) return -1;
            s_logger.trace("searching process list for " + command);
            proc = "intel-edison".equals(s_platform) ? ProcessUtil.exec("ps") : ProcessUtil.exec("ps -ax");
            proc.waitFor();
            br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            do {
                if ((line = br.readLine()) == null) {
                    return -1;
                }
                st = new StringTokenizer(line);
                pid = st.nextToken();
                st.nextElement();
                st.nextElement();
                st.nextElement();
            } while ((line = line.substring(line.indexOf(st.nextToken()))).indexOf(command) < 0);
            s_logger.trace("found pid " + pid + " for command: " + command);
            n = Integer.parseInt(pid);
            if (br == null) break block10;
            br.close();
        }
        if (proc == null) return n;
        ProcessUtil.destroy(proc);
        return n;
        finally {
            if (br != null) {
                br.close();
            }
            if (proc != null) {
                ProcessUtil.destroy(proc);
            }
        }
    }

    public static int getPid(String command, String[] tokens) throws Exception {
        StringTokenizer st = null;
        String line = null;
        String pid = null;
        SafeProcess proc = null;
        try {
            if (command != null && !command.isEmpty()) {
                s_logger.trace("searching process list for " + command);
                proc = "intel-edison".equals(s_platform) ? ProcessUtil.exec("ps") : ProcessUtil.exec("ps -ax");
                proc.waitFor();
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((line = br.readLine()) != null) {
                    st = new StringTokenizer(line);
                    pid = st.nextToken();
                    st.nextElement();
                    st.nextElement();
                    st.nextElement();
                    line = line.substring(line.indexOf(st.nextToken()));
                    if (line.indexOf(command) < 0) continue;
                    boolean allTokensPresent = true;
                    String[] stringArray = tokens;
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        if (!line.contains(token)) {
                            allTokensPresent = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!allTokensPresent) continue;
                    s_logger.trace("found pid " + pid + " for command: " + command);
                    int n3 = Integer.parseInt(pid);
                    ProcessUtil.destroy(proc);
                    return n3;
                }
            }
            return -1;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ProcessUtil.destroy(proc);
        }
    }

    public static int getKuraPid() throws Exception {
        int pid = -1;
        File kuraPidFile = new File("/var/run/kura.pid");
        if (kuraPidFile.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(kuraPidFile));
            pid = Integer.parseInt(br.readLine());
            br.close();
        }
        return pid;
    }

    public static boolean stop(int pid) {
        return LinuxProcessUtil.stop(pid, false);
    }

    public static boolean kill(int pid) {
        return LinuxProcessUtil.stop(pid, true);
    }

    private static boolean stop(int pid, boolean kill) {
        block6: {
            try {
                StringBuffer cmd = new StringBuffer();
                cmd.append("kill ");
                if (kill) {
                    cmd.append("-9 ");
                }
                cmd.append(pid);
                if (kill) {
                    s_logger.info("attempting to kill -9 pid " + pid);
                } else {
                    s_logger.info("attempting to kill pid " + pid);
                }
                if (LinuxProcessUtil.start(cmd.toString()) != 0) break block6;
                s_logger.info("successfully killed pid " + pid);
                return true;
            }
            catch (Exception exception) {
                s_logger.warn("failed to kill pid " + pid);
                return false;
            }
        }
        s_logger.warn("failed to kill pid " + pid);
        return false;
    }

    public static boolean killAll(String command) {
        block3: {
            try {
                s_logger.info("attempting to kill process " + command);
                if (LinuxProcessUtil.start("killall " + command) != 0) break block3;
                s_logger.info("successfully killed process " + command);
                return true;
            }
            catch (Exception exception) {
                s_logger.warn("failed to kill process " + command);
                return false;
            }
        }
        s_logger.warn("failed to kill process " + command);
        return false;
    }

    public static String getInputStreamAsString(InputStream stream) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            int len;
            br = new BufferedReader(new InputStreamReader(stream));
            char[] cbuf = new char[1024];
            while ((len = br.read(cbuf)) > 0) {
                sb.append(cbuf, 0, len);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return sb.toString();
    }
}

