/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.db.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicIntegerArray;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.eclipse.kura.core.db.pool.KuraJDBCPooledDatasource;
import org.eclipse.kura.core.db.pool.KuraPooledConnectionManager;

public class KuraJDBCConnectionPool
implements ConnectionEventListener,
StatementEventListener {
    AtomicIntegerArray states;
    PooledConnection[] connections;
    KuraJDBCPooledDatasource source = new KuraJDBCPooledDatasource();
    volatile boolean closed;

    public KuraJDBCConnectionPool() {
        this(10);
    }

    public KuraJDBCConnectionPool(int size) {
        this.connections = new PooledConnection[size];
        this.states = new AtomicIntegerArray(size);
    }

    public Connection getConnection() throws SQLException {
        int retries = 300;
        if (this.source.getLoginTimeout() != 0) {
            retries = this.source.getLoginTimeout() * 10;
        }
        if (this.closed) {
            throw new SQLException("connection pool is closed");
        }
        int count = 0;
        while (count < retries) {
            int i = 0;
            while (i < this.states.length()) {
                if (this.states.compareAndSet(i, 1, 2)) {
                    return this.connections[i].getConnection();
                }
                if (this.states.compareAndSet(i, 0, 2)) {
                    try {
                        PooledConnection connection = this.source.getPooledConnection();
                        connection.addConnectionEventListener(this);
                        connection.addStatementEventListener(this);
                        this.connections[i] = connection;
                        return this.connections[i].getConnection();
                    }
                    catch (SQLException sQLException) {
                        this.states.set(i, 0);
                    }
                }
                ++i;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            ++count;
        }
        throw new SQLException("Invalid argument!");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.source.getPooledConnection(username, password).getConnection();
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection connection = (PooledConnection)event.getSource();
        int i = 0;
        while (i < this.connections.length) {
            if (this.connections[i] == connection) {
                this.states.set(i, 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection connection = (PooledConnection)event.getSource();
        int i = 0;
        while (i < this.connections.length) {
            if (this.connections[i] == connection) {
                this.states.set(i, 2);
                this.connections[i] = null;
                this.states.set(i, 0);
                break;
            }
            ++i;
        }
    }

    @Override
    public void statementClosed(StatementEvent event) {
    }

    @Override
    public void statementErrorOccurred(StatementEvent event) {
    }

    public String getUrl() {
        return this.source.getUrl();
    }

    public String getUser() {
        return this.source.getUser();
    }

    public void setUrl(String url) {
        this.source.setUrl(url);
    }

    public void setPassword(String password) {
        this.source.setPassword(password);
    }

    public void setUser(String user) {
        this.source.setUser(user);
    }

    public void close(int wait) throws SQLException {
        if (wait < 0 || wait > 60) {
            throw new SQLException("Out of range!");
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            Thread.sleep(1000 * wait);
        }
        catch (Throwable throwable) {}
        int i = 0;
        while (i < this.connections.length) {
            if (this.connections[i] != null) {
                KuraPooledConnectionManager.releaseConnection(this.connections[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.connections.length) {
            this.connections[i] = null;
            ++i;
        }
    }

    static interface RefState {
        public static final int empty = 0;
        public static final int available = 1;
        public static final int allocated = 2;
    }
}

