/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.core.util.SafeProcess;
import org.eclipse.kura.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudServiceOptions {
    private static final Logger s_logger = LoggerFactory.getLogger(CloudServiceOptions.class);
    private static final String TOPIC_SEPARATOR = "/";
    private static final String TOPIC_ACCOUNT_TOKEN = "#account-name";
    private static final String TOPIC_CLIENT_ID_TOKEN = "#client-id";
    private static final String TOPIC_BIRTH_SUFFIX = "MQTT/BIRTH";
    private static final String TOPIC_DISCONNECT_SUFFIX = "MQTT/DC";
    private static final String TOPIC_APPS_SUFFIX = "MQTT/APPS";
    private static final String TOPIC_CONTROL_PREFIX = "topic.control-prefix";
    private static final String TOPIC_CONTROL_PREFIX_DEFAULT = "$EDC";
    private static final String TOPIC_WILD_CARD = "#";
    private static final String DEVICE_DISPLAY_NAME = "device.display-name";
    private static final String DEVICE_CUSTOM_NAME = "device.custom-name";
    private static final String ENCODE_GZIP = "encode.gzip";
    private static final String REPUB_BIRTH_ON_GPS_LOCK = "republish.mqtt.birth.cert.on.gps.lock";
    private static final String REPUB_BIRTH_ON_MODEM_DETECT = "republish.mqtt.birth.cert.on.modem.detect";
    private static final String DISABLE_DFLT_SUBSCRIPTIONS = "disable.default.subscriptions";
    private static final String DISABLE_REPUB_BIRTH_ON_RECONNECT = "disable.republish.birth.cert.on.reconnect";
    private static final int LIFECYCLE_QOS = 0;
    private static final int LIFECYCLE_PRIORITY = 0;
    private static final boolean LIFECYCLE_RETAIN = false;
    private Map<String, Object> m_properties;
    private SystemService m_systemService;

    CloudServiceOptions(Map<String, Object> properties, SystemService systemService) {
        this.m_properties = properties;
        this.m_systemService = systemService;
    }

    public String getDeviceDisplayName() {
        String displayName = "";
        if (this.m_properties != null) {
            String deviceDisplayNameOption = (String)this.m_properties.get(DEVICE_DISPLAY_NAME);
            if (deviceDisplayNameOption.equals("device-name")) {
                displayName = this.m_systemService.getDeviceName();
                return displayName;
            }
            if (deviceDisplayNameOption.equals("hostname")) {
                String displayTmp;
                displayName = "UNKNOWN";
                if ("Mac OS X".equals(this.m_systemService.getOsName())) {
                    String displayTmp2 = this.getHostname("scutil --get ComputerName");
                    if (displayTmp2.length() > 0) {
                        displayName = displayTmp2;
                    }
                } else if (("Linux".equals(this.m_systemService.getOsName()) || "Linux (Cloudbees)".equals(this.m_systemService.getOsName())) && (displayTmp = this.getHostname("hostname")).length() > 0) {
                    displayName = displayTmp;
                }
                return displayName;
            }
            if (deviceDisplayNameOption.equals("custom")) {
                if (this.m_properties.get(DEVICE_CUSTOM_NAME) != null && this.m_properties.get(DEVICE_CUSTOM_NAME) instanceof String) {
                    displayName = (String)this.m_properties.get(DEVICE_CUSTOM_NAME);
                }
                return displayName;
            }
            if (deviceDisplayNameOption.equals("server")) {
                displayName = "";
                return displayName;
            }
        }
        return displayName;
    }

    public boolean getEncodeGzip() {
        boolean encodeGzip = false;
        if (this.m_properties != null && this.m_properties.get(ENCODE_GZIP) != null && this.m_properties.get(ENCODE_GZIP) instanceof Boolean) {
            encodeGzip = (Boolean)this.m_properties.get(ENCODE_GZIP);
        }
        return encodeGzip;
    }

    public boolean getRepubBirthCertOnGpsLock() {
        boolean repubBirth = false;
        if (this.m_properties != null && this.m_properties.get(REPUB_BIRTH_ON_GPS_LOCK) != null && this.m_properties.get(REPUB_BIRTH_ON_GPS_LOCK) instanceof Boolean) {
            repubBirth = (Boolean)this.m_properties.get(REPUB_BIRTH_ON_GPS_LOCK);
        }
        return repubBirth;
    }

    public boolean getRepubBirthCertOnModemDetection() {
        boolean repubBirth = false;
        if (this.m_properties != null && this.m_properties.get(REPUB_BIRTH_ON_MODEM_DETECT) != null && this.m_properties.get(REPUB_BIRTH_ON_MODEM_DETECT) instanceof Boolean) {
            repubBirth = (Boolean)this.m_properties.get(REPUB_BIRTH_ON_MODEM_DETECT);
        }
        return repubBirth;
    }

    public String getTopicControlPrefix() {
        String prefix = TOPIC_CONTROL_PREFIX_DEFAULT;
        if (this.m_properties != null && this.m_properties.get(TOPIC_CONTROL_PREFIX) != null && this.m_properties.get(TOPIC_CONTROL_PREFIX) instanceof String) {
            prefix = (String)this.m_properties.get(TOPIC_CONTROL_PREFIX);
        }
        return prefix;
    }

    public boolean getDisableDefaultSubscriptions() {
        boolean disable = false;
        if (this.m_properties != null && this.m_properties.get(DISABLE_DFLT_SUBSCRIPTIONS) != null && this.m_properties.get(DISABLE_DFLT_SUBSCRIPTIONS) instanceof Boolean) {
            disable = (Boolean)this.m_properties.get(DISABLE_DFLT_SUBSCRIPTIONS);
        }
        return disable;
    }

    public boolean getDisableRepubBirthCertOnReconnect() {
        boolean disable = false;
        if (this.m_properties != null && this.m_properties.get(DISABLE_REPUB_BIRTH_ON_RECONNECT) != null && this.m_properties.get(DISABLE_REPUB_BIRTH_ON_RECONNECT) instanceof Boolean) {
            disable = (Boolean)this.m_properties.get(DISABLE_REPUB_BIRTH_ON_RECONNECT);
        }
        return disable;
    }

    public String getTopicSeparator() {
        return TOPIC_SEPARATOR;
    }

    public String getTopicAccountToken() {
        return TOPIC_ACCOUNT_TOKEN;
    }

    public String getTopicClientIdToken() {
        return TOPIC_CLIENT_ID_TOKEN;
    }

    public String getTopicBirthSuffix() {
        return TOPIC_BIRTH_SUFFIX;
    }

    public String getTopicDisconnectSuffix() {
        return TOPIC_DISCONNECT_SUFFIX;
    }

    public String getTopicAppsSuffix() {
        return TOPIC_APPS_SUFFIX;
    }

    public String getTopicWildCard() {
        return TOPIC_WILD_CARD;
    }

    public int getLifeCycleMessageQos() {
        return 0;
    }

    public int getLifeCycleMessagePriority() {
        return 0;
    }

    public boolean getLifeCycleMessageRetain() {
        return false;
    }

    private String getHostname(String command) {
        StringBuffer response;
        block18: {
            response = new StringBuffer();
            SafeProcess proc = null;
            BufferedReader br = null;
            try {
                try {
                    proc = ProcessUtil.exec(command);
                    proc.waitFor();
                    br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    String newLine = "";
                    while ((line = br.readLine()) != null) {
                        response.append(newLine);
                        response.append(line);
                        newLine = "\n";
                    }
                }
                catch (Exception e) {
                    s_logger.error("failed to run commands " + command, e);
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {
                            s_logger.error("I/O Exception while closing BufferedReader!");
                        }
                    }
                    if (proc != null) {
                        ProcessUtil.destroy(proc);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        s_logger.error("I/O Exception while closing BufferedReader!");
                    }
                }
                if (proc != null) {
                    ProcessUtil.destroy(proc);
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    s_logger.error("I/O Exception while closing BufferedReader!");
                }
            }
            if (proc != null) {
                ProcessUtil.destroy(proc);
            }
        }
        return response.toString();
    }
}

